/*
 * Decompiled with CFR 0.152.
 */
package io.aboutcode.stage.web.websocket.standard.io.json;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.aboutcode.stage.util.Tuple2;
import io.aboutcode.stage.web.websocket.WebsocketIo;
import io.aboutcode.stage.web.websocket.standard.io.json.JsonMessage;
import java.io.IOException;
import java.util.Map;

public final class JsonWebsocketIo
implements WebsocketIo<JsonMessage> {
    private static final Gson gson = new GsonBuilder().create();
    private final BiMap<String, Class<? extends JsonMessage>> messageIdentifierToMessageClass;

    public JsonWebsocketIo(Map<String, Class<? extends JsonMessage>> messages) {
        this.messageIdentifierToMessageClass = ImmutableBiMap.copyOf(messages);
    }

    private static Tuple2<String, JsonObject> getIdentifier(String message) {
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = parser.parse(message).getAsJsonObject();
        return Tuple2.of((Object)jsonObject.get("type").getAsString(), (Object)jsonObject);
    }

    @Override
    public String serialize(JsonMessage element) {
        element.setIdentifier((String)this.messageIdentifierToMessageClass.inverse().get(element.getClass()));
        return gson.toJson((Object)element);
    }

    @Override
    public JsonMessage deserialize(String message) throws IOException {
        Tuple2<String, JsonObject> parseResult = JsonWebsocketIo.getIdentifier(message);
        Class messageClass = (Class)this.messageIdentifierToMessageClass.get(parseResult.one());
        if (messageClass == null) {
            throw new IOException(String.format("Could not find a matching object type for message: %s", message));
        }
        try {
            return (JsonMessage)gson.fromJson((JsonElement)parseResult.two(), messageClass);
        }
        catch (Exception e) {
            throw new IOException(String.format("Could not deserialize type '%s' from message: %s", messageClass, message), e);
        }
    }
}

