/*
 * Decompiled with CFR 0.152.
 */
package io.aboutcode.stage.web.autowire.versioning;

import io.aboutcode.stage.web.autowire.versioning.Version;
import java.util.Objects;

public final class VersionRange {
    private static final Version START = Version.from(0, 0, 0);
    private static final Version END = Version.from(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private final Version start;
    private final Version end;

    private VersionRange(Version start, Version end) {
        this.start = start == null ? START : start;
        this.end = end == null ? END : end;
    }

    public static VersionRange wildcard() {
        return new VersionRange(null, null);
    }

    public static VersionRange between(Version start, Version end) {
        return new VersionRange(start, end);
    }

    public static VersionRange from(Version start) {
        return new VersionRange(start, null);
    }

    public static VersionRange to(Version end) {
        return new VersionRange(null, end);
    }

    public boolean allows(Version version) {
        return !this.start.isAfter(version) && (this.end == END || this.end.isAfter(version));
    }

    public boolean overlaps(VersionRange versionRange) {
        return !this.start.isAfter(versionRange.end) && !Objects.equals(this.start, versionRange.end) && !this.end.isBefore(versionRange.start) && !Objects.equals(this.end, versionRange.start);
    }
}

