/*
 * Decompiled with CFR 0.152.
 */
package io.aboutcode.stage.web;

import io.aboutcode.stage.component.BaseComponent;
import io.aboutcode.stage.dependency.DependencyContext;
import io.aboutcode.stage.dependency.DependencyException;
import io.aboutcode.stage.web.Route;
import io.aboutcode.stage.web.SparkServer;
import io.aboutcode.stage.web.TslConfiguration;
import io.aboutcode.stage.web.autowire.AutowiringRequestContext;
import io.aboutcode.stage.web.autowire.WebRequestHandler;
import io.aboutcode.stage.web.autowire.WebRequestHandlerParser;
import io.aboutcode.stage.web.autowire.auth.AuthorizationRealm;
import io.aboutcode.stage.web.websocket.WebsocketEndpoint;
import io.aboutcode.stage.web.websocket.WebsocketIo;
import io.aboutcode.stage.web.websocket.standard.TypedWebsocketMessage;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class WebServerComponent
extends BaseComponent {
    private final String rootPath;
    private final int port;
    private final String staticFilesFolder;
    private final boolean isStaticFolderExternal;
    private final Set<Class> validEndpoints;
    private final AutowiringRequestContext autowiringRequestContext;
    private WebsocketIo<? extends TypedWebsocketMessage> websocketIo;
    private TslConfiguration tslConfiguration;
    private SparkServer sparkServer;

    WebServerComponent(String rootPath, int port, String staticFilesFolder, boolean isStaticFolderExternal, AutowiringRequestContext autowiringRequestContext, TslConfiguration tslConfiguration, Set<Class> validEndpoints, WebsocketIo<? extends TypedWebsocketMessage> websocketIo) {
        this.rootPath = rootPath;
        this.port = port;
        this.staticFilesFolder = staticFilesFolder;
        this.isStaticFolderExternal = isStaticFolderExternal;
        this.autowiringRequestContext = autowiringRequestContext;
        this.tslConfiguration = tslConfiguration;
        this.validEndpoints = validEndpoints;
        this.websocketIo = websocketIo;
    }

    public final void start() {
        this.sparkServer.start();
    }

    public final void stop() {
        this.sparkServer.stop();
    }

    public void resolve(DependencyContext context) throws DependencyException {
        this.sparkServer = new SparkServer(this.port, this.tslConfiguration, this.staticFilesFolder, this.isStaticFolderExternal, this.routes(context), this.websocketEndpoints(context), this.websocketIo);
    }

    private Set<WebsocketEndpoint> websocketEndpoints(DependencyContext context) throws DependencyException {
        if (this.validEndpoints == null) {
            return context.retrieveDependencies(WebsocketEndpoint.class);
        }
        HashSet<WebsocketEndpoint> websocketEndpoints = new HashSet<WebsocketEndpoint>();
        for (Class validType : this.validEndpoints) {
            Set elements = context.retrieveDependencies(validType);
            if (!WebsocketEndpoint.class.isAssignableFrom(validType)) continue;
            websocketEndpoints.addAll(elements);
        }
        return websocketEndpoints;
    }

    private List<Route> routes(DependencyContext context) throws DependencyException {
        if (this.validEndpoints == null) {
            return this.routes(context.retrieveDependencies(WebRequestHandler.class), context);
        }
        HashSet<WebRequestHandler> webRequestHandlers = new HashSet<WebRequestHandler>();
        for (Class validType : this.validEndpoints) {
            Set elements = context.retrieveDependencies(validType);
            if (!WebRequestHandler.class.isAssignableFrom(validType)) continue;
            webRequestHandlers.addAll(elements);
        }
        return this.routes(webRequestHandlers, context);
    }

    private List<Route> routes(Set<WebRequestHandler> webRequestHandlers, DependencyContext context) throws DependencyException {
        WebRequestHandlerParser parser = new WebRequestHandlerParser(context.retrieveDependencies(AuthorizationRealm.class), this.autowiringRequestContext);
        return parser.parse(this.rootPath, webRequestHandlers);
    }
}

