/*
 * Decompiled with CFR 0.152.
 */
package io.aboutcode.stage.web;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import io.aboutcode.stage.dispatch.Dispatcher;
import io.aboutcode.stage.web.Route;
import io.aboutcode.stage.web.Session;
import io.aboutcode.stage.web.TslConfiguration;
import io.aboutcode.stage.web.request.Part;
import io.aboutcode.stage.web.request.Request;
import io.aboutcode.stage.web.request.RequestHandler;
import io.aboutcode.stage.web.request.RequestType;
import io.aboutcode.stage.web.response.InternalServerError;
import io.aboutcode.stage.web.response.Ok;
import io.aboutcode.stage.web.response.Response;
import io.aboutcode.stage.web.websocket.DelegatingWebsocketHandler;
import io.aboutcode.stage.web.websocket.WebsocketEndpoint;
import io.aboutcode.stage.web.websocket.WebsocketIo;
import io.aboutcode.stage.web.websocket.standard.TypedWebsocketMessage;
import io.aboutcode.stage.web.websocket.standard.WebsocketDataHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.FilterImpl;
import spark.RouteImpl;
import spark.Service;
import spark.route.HttpMethod;

final class SparkServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkServer.class);
    private static final String KEY_RESPONSE = "-RESPONSE-";
    private static final String KEY_ACCEPT_TYPE = "Accept";
    private final int port;
    private final TslConfiguration tslConfiguration;
    private final String staticFilesFolder;
    private final boolean isStaticFolderExternal;
    private final List<Route> routes;
    private final Set<WebsocketEndpoint> websocketEndpoints;
    private final WebsocketIo<? extends TypedWebsocketMessage> websocketIo;
    private final Dispatcher<RequestType, ServiceRequestProcessor> SERVICE_PROCESSORS = Dispatcher.of((Object)((Object)RequestType.AFTER_ALL), (Object)this.filter(HttpMethod.after)).with((Object)RequestType.BEFORE_ALL, (Object)this.filter(HttpMethod.before)).with((Object)RequestType.GET, (Object)this.route(HttpMethod.get)).with((Object)RequestType.POST, (Object)this.route(HttpMethod.post)).with((Object)RequestType.PUT, (Object)this.route(HttpMethod.put)).with((Object)RequestType.DELETE, (Object)this.route(HttpMethod.delete)).with((Object)RequestType.OPTIONS, (Object)this.route(HttpMethod.options)).with((Object)RequestType.PATCH, (Object)this.route(HttpMethod.patch));
    private Service sparkService;

    SparkServer(int port, TslConfiguration tslConfiguration, String staticFilesFolder, boolean isStaticFolderExternal, List<Route> routes, Set<WebsocketEndpoint> websocketEndpoints, WebsocketIo<? extends TypedWebsocketMessage> websocketIo) {
        this.port = port;
        this.tslConfiguration = tslConfiguration;
        this.staticFilesFolder = staticFilesFolder;
        this.isStaticFolderExternal = isStaticFolderExternal;
        this.routes = routes;
        this.websocketEndpoints = websocketEndpoints;
        this.websocketIo = websocketIo;
    }

    private static Request request(spark.Request rawRequest) {
        return new DefaultRequest(rawRequest);
    }

    private static Response getCurrentResponse(Request request) {
        return (Response)request.attribute(KEY_RESPONSE).orElse(Ok.create());
    }

    private static Response process(Request request, RequestHandler requestHandler) {
        Response response;
        Response currentResponse = SparkServer.getCurrentResponse(request);
        try {
            response = requestHandler.process(request, currentResponse);
        }
        catch (Exception e) {
            LOGGER.error("Processing request caused error: {}", (Object)e.getMessage(), (Object)e);
            response = InternalServerError.with(String.format("Processing request caused error: %s", e.getMessage()));
        }
        response.header("Server", "");
        return response;
    }

    private static String string(Route route) {
        return String.format("%s:%s", new Object[]{route.getType(), route.getPath()});
    }

    private ServiceRequestProcessor filter(HttpMethod method) {
        return (service, route) -> service.addFilter(method, new FilterImpl(route.getPath(), "*/*"){

            public void handle(spark.Request rawRequest, spark.Response rawResponse) {
                Request request = SparkServer.request(rawRequest);
                Response response = SparkServer.process(request, route.getRequestHandler());
                SparkServer.this.apply(rawResponse, request, response);
            }
        });
    }

    private ServiceRequestProcessor route(HttpMethod method) {
        return (service, route) -> service.addRoute(method, new RouteImpl(route.getPath(), "*/*"){

            public Object handle(spark.Request rawRequest, spark.Response rawResponse) {
                Request request = SparkServer.request(rawRequest);
                Response response = SparkServer.getCurrentResponse(request);
                if (!response.finished()) {
                    response = SparkServer.process(request, route.getRequestHandler());
                }
                return SparkServer.this.apply(rawResponse, request, response);
            }
        });
    }

    private Object apply(spark.Response rawResponse, Request request, Response response) {
        HttpServletResponse servletResponse = rawResponse.raw();
        request.header(KEY_ACCEPT_TYPE).map(this::contentTypes).flatMap(types -> types.stream().findFirst()).ifPresent(response::contentType);
        response.headers().forEach((arg_0, arg_1) -> ((HttpServletResponse)servletResponse).setHeader(arg_0, arg_1));
        request.attribute(KEY_RESPONSE, response);
        rawResponse.status(response.status());
        return Optional.ofNullable(response.data()).orElse("");
    }

    private Set<String> contentTypes(String contentTypes) {
        return Splitter.on((char)',').trimResults().withKeyValueSeparator(';').split((CharSequence)contentTypes).keySet();
    }

    private void assign(Service service, Route route) {
        ((ServiceRequestProcessor)this.SERVICE_PROCESSORS.dispatch((Object)route.getType()).orElseThrow(() -> new IllegalArgumentException(String.format("Type %s cannot be processed", route.getType().name())))).process(service, route);
    }

    final void start() {
        this.sparkService = Service.ignite().port(this.port);
        if (this.tslConfiguration != null) {
            this.sparkService.secure(this.tslConfiguration.getKeyStoreLocation(), this.tslConfiguration.getKeyStorePassword(), this.tslConfiguration.getTrustStoreLocation(), this.tslConfiguration.getTrustStorePassword(), this.tslConfiguration.isClientCertificateRequired());
        }
        this.sparkService.initExceptionHandler(e -> LOGGER.error("Error in webserver: {}", (Object)e.getMessage(), e));
        if (this.staticFilesFolder != null) {
            if (this.isStaticFolderExternal) {
                this.sparkService.externalStaticFileLocation(this.staticFilesFolder);
            } else {
                this.sparkService.staticFileLocation(this.staticFilesFolder);
            }
        }
        this.websocketEndpoints.forEach(websocketEndpoint -> websocketEndpoint.getWebSocketRoutes().forEach(route -> {
            DelegatingWebsocketHandler<? extends TypedWebsocketMessage> handler = new DelegatingWebsocketHandler<TypedWebsocketMessage>(this.websocketIo);
            route.getWebSocketDataHandlers().forEach(element -> {
                LOGGER.debug("Adding route: {} -> {}", (Object)route.getPath(), (Object)element.getClass().getSimpleName());
                handler.addandInitialize((WebsocketDataHandler<? extends TypedWebsocketMessage>)element);
            });
            this.sparkService.webSocket(route.getPath(), handler);
        }));
        List<Route> sortedRoutes = this.routes.stream().sorted(Comparator.comparingInt(element -> CharMatcher.is((char)'/').countIn((CharSequence)element.getPath())).reversed()).collect(Collectors.toList());
        List<String> duplicatePaths = sortedRoutes.stream().collect(Collectors.groupingBy(SparkServer::string, Collectors.counting())).entrySet().stream().filter((? super T entry) -> (Long)entry.getValue() > 1L).map(entry -> String.format("Route '%s' declared %d times", entry.getKey(), entry.getValue())).collect(Collectors.toList());
        if (!duplicatePaths.isEmpty()) {
            duplicatePaths.forEach(path -> LOGGER.error("Duplicate declaration of path '{}'", path));
            throw new IllegalStateException("Duplicate path declarations found for web server");
        }
        sortedRoutes.forEach(route -> {
            LOGGER.debug("Adding route: {} -> {}", (Object)route.getType(), (Object)route.getPath());
            this.assign(this.sparkService, (Route)route);
        });
        this.sparkService.init();
    }

    final void stop() {
        this.sparkService.stop();
    }

    private static class WrappingPart
    implements Part {
        private final javax.servlet.http.Part delegate;

        private WrappingPart(javax.servlet.http.Part delegate) {
            this.delegate = delegate;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.delegate.getInputStream();
        }

        @Override
        public String getContentType() {
            return this.delegate.getContentType();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public String getSubmittedFileName() {
            return this.delegate.getSubmittedFileName();
        }

        @Override
        public long getSize() {
            return this.delegate.getSize();
        }
    }

    private static class DefaultRequest
    implements Request {
        private final spark.Request rawRequest;

        private DefaultRequest(spark.Request rawRequest) {
            this.rawRequest = rawRequest;
        }

        @Override
        public Optional<Object> attribute(String name) {
            return Optional.ofNullable(this.rawRequest.attribute(name));
        }

        @Override
        public void attribute(String name, Object value) {
            this.rawRequest.attribute(name, value);
        }

        @Override
        public Optional<String> pathParam(String name) {
            return Optional.ofNullable(this.rawRequest.params(name));
        }

        @Override
        public List<String> queryParams(String name) {
            return Optional.ofNullable(this.rawRequest.queryParamsValues(name)).map(Stream::of).orElse(Stream.empty()).collect(Collectors.toList());
        }

        @Override
        public Optional<String> queryParam(String name) {
            return Optional.ofNullable(this.rawRequest.queryParamsValues(name)).map(Stream::of).orElse(Stream.empty()).findFirst();
        }

        @Override
        public Set<String> queryParams() {
            return this.rawRequest.queryParams();
        }

        @Override
        public String body() {
            return this.rawRequest.body();
        }

        @Override
        public Optional<String> header(String name) {
            return Optional.ofNullable(this.rawRequest.headers(name));
        }

        @Override
        public Set<String> headers() {
            return this.rawRequest.headers();
        }

        @Override
        public RequestType method() {
            String methodString = this.rawRequest.requestMethod().toUpperCase();
            return RequestType.valueOf(methodString);
        }

        @Override
        public Session session() {
            return new Session(){

                @Override
                public <T> Optional<T> attribute(String name) {
                    return Optional.ofNullable(rawRequest.session().attribute(name));
                }

                @Override
                public void attribute(String name, Object value) {
                    rawRequest.session().attribute(name, value);
                }
            };
        }

        @Override
        public String path() {
            return this.rawRequest.pathInfo();
        }

        @Override
        public Stream<Part> parts() throws IOException {
            this.rawRequest.attribute("org.eclipse.jetty.multipartConfig", (Object)new MultipartConfigElement((String)null));
            try {
                return this.rawRequest.raw().getParts().stream().map(x$0 -> new WrappingPart((javax.servlet.http.Part)x$0));
            }
            catch (ServletException e) {
                throw new IOException(e);
            }
        }
    }

    private static interface ServiceRequestProcessor {
        public void process(Service var1, Route var2);
    }
}

