/*
 * Decompiled with CFR 0.152.
 */
package io.aboutcode.stage.web;

import io.aboutcode.stage.application.ApplicationAssemblyContext;
import io.aboutcode.stage.component.Component;
import io.aboutcode.stage.component.ComponentBundle;
import io.aboutcode.stage.configuration.ApplicationConfigurationContext;
import io.aboutcode.stage.web.TslConfiguration;
import io.aboutcode.stage.web.WebServerComponent;
import io.aboutcode.stage.web.WebServerConfiguration;
import io.aboutcode.stage.web.autowire.AutowiringRequestContext;
import io.aboutcode.stage.web.request.Request;
import io.aboutcode.stage.web.response.InternalServerError;
import io.aboutcode.stage.web.response.Response;
import io.aboutcode.stage.web.serialization.ContentTypeException;
import io.aboutcode.stage.web.serialization.DefaultExceptionSerialization;
import io.aboutcode.stage.web.serialization.JsonWebSerialization;
import io.aboutcode.stage.web.serialization.WebSerialization;
import io.aboutcode.stage.web.websocket.WebsocketIo;
import io.aboutcode.stage.web.websocket.standard.TypedWebsocketMessage;
import io.aboutcode.stage.web.websocket.standard.io.NotImplementedIo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

public final class WebServerComponentBundleBuilder {
    private String rootPath;
    private String prefix;
    private Object identifier;
    private boolean secure;
    private String internalStaticFolder;
    private Set<Class> validEndpoints;
    private WebSerialization serialization;
    private WebsocketIo<? extends TypedWebsocketMessage> websocketIo;
    private Function<Exception, Response> exceptionSerialization;

    private WebServerComponentBundleBuilder(String rootPath, String prefix, Object identifier, boolean secure, String internalStaticFolder, Set<Class> validEndpoints, WebSerialization serialization, WebsocketIo<? extends TypedWebsocketMessage> websocketIo, Function<Exception, Response> exceptionSerialization) {
        this.rootPath = rootPath;
        this.prefix = prefix;
        this.identifier = identifier;
        this.secure = secure;
        this.internalStaticFolder = internalStaticFolder;
        this.validEndpoints = validEndpoints;
        this.serialization = serialization;
        this.websocketIo = websocketIo;
        this.exceptionSerialization = exceptionSerialization;
    }

    public static WebServerComponentBundleBuilder create() {
        return new WebServerComponentBundleBuilder(null, null, null, false, null, null, new JsonWebSerialization(), new NotImplementedIo(), new DefaultExceptionSerialization());
    }

    public ComponentBundle build() {
        AutowiringRequestContext context = new AutowiringRequestContext(){

            @Override
            public <T> T deserialize(String input, Class<T> type) {
                return WebServerComponentBundleBuilder.this.serialization.deserialize(input, type);
            }

            @Override
            public String serialize(Object input) {
                return WebServerComponentBundleBuilder.this.serialization.serialize(input);
            }

            @Override
            public void setContentType(Request request, Response response) throws ContentTypeException {
                WebServerComponentBundleBuilder.this.serialization.setContentType(request, response);
            }

            @Override
            public Response serialize(Exception e) {
                try {
                    return (Response)WebServerComponentBundleBuilder.this.exceptionSerialization.apply(e);
                }
                catch (Exception e1) {
                    return InternalServerError.with("Error mapping exception: " + e.getMessage());
                }
            }
        };
        if (this.secure) {
            return new SSLWebComponentBundle(this.rootPath, this.prefix, this.identifier, this.internalStaticFolder, this.validEndpoints, context, this.websocketIo);
        }
        return new DefaultWebComponentBundle(this.rootPath, this.prefix, this.identifier, this.internalStaticFolder, this.validEndpoints, context, this.websocketIo);
    }

    public WebServerComponentBundleBuilder withPrefix(String prefix) {
        return new WebServerComponentBundleBuilder(this.rootPath, prefix, this.identifier, this.secure, this.internalStaticFolder, this.validEndpoints, this.serialization, this.websocketIo, this.exceptionSerialization);
    }

    public WebServerComponentBundleBuilder withIdentifier(Object identifier) {
        return new WebServerComponentBundleBuilder(this.rootPath, this.prefix, identifier, this.secure, this.internalStaticFolder, this.validEndpoints, this.serialization, this.websocketIo, this.exceptionSerialization);
    }

    public WebServerComponentBundleBuilder withInternalStaticFolder(String folder) {
        return new WebServerComponentBundleBuilder(this.rootPath, this.prefix, this.identifier, this.secure, folder, this.validEndpoints, this.serialization, this.websocketIo, this.exceptionSerialization);
    }

    public WebServerComponentBundleBuilder withRootPath(String path) {
        return new WebServerComponentBundleBuilder(path, this.prefix, this.identifier, this.secure, this.internalStaticFolder, this.validEndpoints, this.serialization, this.websocketIo, this.exceptionSerialization);
    }

    public WebServerComponentBundleBuilder secure() {
        return new WebServerComponentBundleBuilder(this.rootPath, this.prefix, this.identifier, true, this.internalStaticFolder, this.validEndpoints, this.serialization, this.websocketIo, this.exceptionSerialization);
    }

    public WebServerComponentBundleBuilder withValidEndpointClasses(Class ... validClasses) {
        return new WebServerComponentBundleBuilder(this.rootPath, this.prefix, this.identifier, this.secure, this.internalStaticFolder, validClasses != null ? new HashSet<Class>(Arrays.asList(validClasses)) : null, this.serialization, this.websocketIo, this.exceptionSerialization);
    }

    public WebServerComponentBundleBuilder withExceptionMapper(Function<Exception, Response> mapper) {
        return new WebServerComponentBundleBuilder(this.rootPath, this.prefix, this.identifier, this.secure, this.internalStaticFolder, this.validEndpoints, this.serialization, this.websocketIo, mapper);
    }

    public WebServerComponentBundleBuilder withWebsocket(WebsocketIo<? extends TypedWebsocketMessage> websocketIo) {
        return new WebServerComponentBundleBuilder(this.rootPath, this.prefix, this.identifier, this.secure, this.internalStaticFolder, this.validEndpoints, this.serialization, websocketIo, this.exceptionSerialization);
    }

    private static class DefaultWebComponentBundle
    implements ComponentBundle {
        private final String rootPath;
        private final String prefix;
        private final Object identifier;
        private final String internalStaticFolder;
        private final Set<Class> validEndpoints;
        private AutowiringRequestContext autowiringRequestContext;
        private WebsocketIo<? extends TypedWebsocketMessage> websocketIo;
        private WebServerConfiguration webServerConfiguration;

        private DefaultWebComponentBundle(String rootPath, String prefix, Object identifier, String internalStaticFolder, Set<Class> validEndpoints, AutowiringRequestContext autowiringRequestContext, WebsocketIo<? extends TypedWebsocketMessage> websocketIo) {
            this.rootPath = rootPath;
            this.prefix = prefix;
            this.identifier = identifier;
            this.internalStaticFolder = internalStaticFolder;
            this.validEndpoints = validEndpoints;
            this.autowiringRequestContext = autowiringRequestContext;
            this.websocketIo = websocketIo;
        }

        public void configure(ApplicationConfigurationContext context) {
            this.webServerConfiguration = (WebServerConfiguration)context.addConfigurationObject(this.prefix, (Object)new WebServerConfiguration(80));
        }

        public void assemble(ApplicationAssemblyContext context) {
            context.addComponent(this.identifier, (Component)new WebServerComponent(this.rootPath, this.webServerConfiguration.getPort(), this.webServerConfiguration.getExternalStaticFolder() == null ? this.internalStaticFolder : this.webServerConfiguration.getExternalStaticFolder(), this.webServerConfiguration.getExternalStaticFolder() != null, this.autowiringRequestContext, null, this.validEndpoints, this.websocketIo));
        }
    }

    private static class SSLWebComponentBundle
    implements ComponentBundle {
        private final String rootPath;
        private final String prefix;
        private final Object identifier;
        private final String internalStaticFolder;
        private final Set<Class> validEndpoints;
        private AutowiringRequestContext autowiringRequestContext;
        private WebsocketIo<? extends TypedWebsocketMessage> websocketIo;
        private TslConfiguration tslConfiguration;
        private WebServerConfiguration webServerConfiguration;

        private SSLWebComponentBundle(String rootPath, String prefix, Object identifier, String internalStaticFolder, Set<Class> validEndpoints, AutowiringRequestContext autowiringRequestContext, WebsocketIo<? extends TypedWebsocketMessage> websocketIo) {
            this.rootPath = rootPath;
            this.prefix = prefix;
            this.identifier = identifier;
            this.internalStaticFolder = internalStaticFolder;
            this.validEndpoints = validEndpoints;
            this.autowiringRequestContext = autowiringRequestContext;
            this.websocketIo = websocketIo;
        }

        public void configure(ApplicationConfigurationContext context) {
            this.tslConfiguration = (TslConfiguration)context.addConfigurationObject(this.prefix, (Object)new TslConfiguration());
            this.webServerConfiguration = (WebServerConfiguration)context.addConfigurationObject(this.prefix, (Object)new WebServerConfiguration(443));
        }

        public void assemble(ApplicationAssemblyContext context) {
            context.addComponent(this.identifier, (Component)new WebServerComponent(this.rootPath, this.webServerConfiguration.getPort(), this.webServerConfiguration.getExternalStaticFolder() == null ? this.internalStaticFolder : this.webServerConfiguration.getExternalStaticFolder(), this.webServerConfiguration.getExternalStaticFolder() != null, this.autowiringRequestContext, this.tslConfiguration, this.validEndpoints, this.websocketIo));
        }
    }
}

