/*
 * Decompiled with CFR 0.152.
 */
package io.aboutcode.stage.web.websocket;

import io.aboutcode.stage.web.websocket.standard.WebsocketDataHandler;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class WebsocketRoute {
    private final String path;
    private final Set<WebsocketDataHandler> webSocketHandlers;

    private WebsocketRoute(String path, Set<WebsocketDataHandler> webSocketHandlers) {
        this.path = path;
        this.webSocketHandlers = webSocketHandlers;
    }

    public static List<WebsocketRoute> list(WebsocketRoute ... routes) {
        return Stream.of(routes).collect(Collectors.toList());
    }

    public static WebsocketRoute at(String path, WebsocketDataHandler ... handlers) {
        return new WebsocketRoute(path, Stream.of(handlers).collect(Collectors.toSet()));
    }

    public String getPath() {
        return this.path;
    }

    public Set<WebsocketDataHandler> getWebSocketDataHandlers() {
        return this.webSocketHandlers;
    }
}

