/*
 * Decompiled with CFR 0.152.
 */
package io.aboutcode.stage.web.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.aboutcode.stage.web.request.Request;
import io.aboutcode.stage.web.response.Response;
import io.aboutcode.stage.web.serialization.WebSerialization;

public final class JsonWebSerialization
implements WebSerialization {
    private final Gson parser = new GsonBuilder().create();

    @Override
    public String serialize(Object data) {
        return this.parser.toJson(data);
    }

    @Override
    public <T> T deserialize(String input, Class<T> type) {
        return (T)this.parser.fromJson(input, type);
    }

    @Override
    public void setContentType(Request request, Response response) {
        response.contentType("application/json");
    }
}

