/*
 * Decompiled with CFR 0.152.
 */
package io.aboutcode.stage.web.response;

import io.aboutcode.stage.web.response.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultResponse
implements Response {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private final Map<String, String> headers = new HashMap<String, String>();
    private final boolean finished;
    private Object data;
    private int status;

    public DefaultResponse(boolean finished, Map<String, String> headers, Object data, int status) {
        this.data = data;
        this.status = status;
        this.finished = finished;
        if (headers != null) {
            this.headers.putAll(headers);
        }
    }

    @Override
    public boolean finished() {
        return this.finished;
    }

    @Override
    public Map<String, String> headers() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public Object data() {
        return this.data;
    }

    @Override
    public int status() {
        return this.status;
    }

    @Override
    public Response data(Object data) {
        this.data = data;
        return this;
    }

    @Override
    public Response header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    @Override
    public Response contentType(String contentType) {
        this.headers.put(CONTENT_TYPE_HEADER, contentType);
        return this;
    }
}

