/*
 * Decompiled with CFR 0.152.
 */
package io.aboutcode.stage.web.autowire.versioning;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    private static final Pattern PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)");
    private final int major;
    private final int minor;
    private final int patch;

    private Version(int major, int minor, int patch) {
        Preconditions.checkArgument((major >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((minor >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((patch >= 0 ? 1 : 0) != 0);
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static Version from(int major, int minor, int patch) {
        return new Version(major, minor, patch);
    }

    public static Optional<Version> from(String version) {
        return Optional.ofNullable(version).flatMap(versionString -> {
            Matcher matcher = PATTERN.matcher((CharSequence)versionString);
            if (matcher.matches()) {
                return Version.version(matcher);
            }
            return Optional.empty();
        });
    }

    private static Optional<Version> version(Matcher matcher) {
        try {
            return Optional.of(new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3))));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    @Override
    public int compareTo(Version other) {
        return Comparator.comparing(Version::getMajor).thenComparing(Version::getMinor).thenComparing(Version::getPatch).compare(this, other);
    }

    public boolean isBefore(Version version) {
        return this.compareTo(version) < 0;
    }

    public boolean isAfter(Version version) {
        return this.compareTo(version) > 0;
    }

    public String toString() {
        return String.format("%s.%s.%s", this.getMajor(), this.getMinor(), this.getPatch());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && this.minor == version.minor && this.patch == version.patch;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }
}

