/*
 * Decompiled with CFR 0.152.
 */
package io.aboutcode.stage.web.autowire;

import io.aboutcode.stage.web.Route;
import io.aboutcode.stage.web.autowire.AccessType;
import io.aboutcode.stage.web.autowire.AutowirableMethod;
import io.aboutcode.stage.web.autowire.AutowiringRequestContext;
import io.aboutcode.stage.web.autowire.Path;
import io.aboutcode.stage.web.autowire.WebRequestHandler;
import io.aboutcode.stage.web.autowire.auth.AuthorizationRealm;
import io.aboutcode.stage.web.autowire.auth.Authorized;
import io.aboutcode.stage.web.autowire.auth.PermissiveAuthorizationRealm;
import io.aboutcode.stage.web.autowire.exception.AutowiringException;
import io.aboutcode.stage.web.autowire.versioning.Version;
import io.aboutcode.stage.web.request.Request;
import io.aboutcode.stage.web.request.RequestHandler;
import io.aboutcode.stage.web.response.NotFound;
import io.aboutcode.stage.web.response.Response;
import io.aboutcode.stage.web.util.Paths;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class WebRequestHandlerParser {
    private static final String VERSION_PATH_PARAMETER = ":VERSION_PATH";
    private static final String DEFAULT_PATH = "/";
    private final Set<AuthorizationRealm> availableAuthorizationRealms;
    private final AutowiringRequestContext context;

    public WebRequestHandlerParser(Set<AuthorizationRealm> availableAuthorizationRealms, AutowiringRequestContext context) {
        this.availableAuthorizationRealms = availableAuthorizationRealms;
        this.context = context;
    }

    private static AuthorizationRealm findRealm(Class<? extends AuthorizationRealm> realmType, Set<AuthorizationRealm> availableAuthorizationRealms) {
        return availableAuthorizationRealms.stream().filter(realm -> Objects.equals(realmType, realm.getClass())).findFirst().orElseThrow(() -> new AutowiringException("Security realm not found: " + realmType.getSimpleName()));
    }

    private String getBasePath(WebRequestHandler handler) {
        return Optional.ofNullable(handler.getClass().getAnnotation(Path.class)).map(Path::value).orElse("");
    }

    private Optional<AutowirableMethod> parseMethod(String basePath, WebRequestHandler handler, Method method, AuthorizationRealm defaultAuthorizationRealm) {
        return AutowirableMethod.from(basePath, handler, method, defaultAuthorizationRealm, this.availableAuthorizationRealms);
    }

    private AuthorizationRealm getAuthorizationRealm(WebRequestHandler handler, Set<AuthorizationRealm> availableAuthoriationRealms) {
        return Optional.ofNullable(handler.getClass().getAnnotation(Authorized.class)).map(Authorized::value).map(realmType -> WebRequestHandlerParser.findRealm(realmType, availableAuthoriationRealms)).orElse(new PermissiveAuthorizationRealm());
    }

    public List<Route> parse(String rootPath, Set<? extends WebRequestHandler> handlers) {
        String path = Objects.isNull(rootPath) || rootPath.trim().isEmpty() ? DEFAULT_PATH : rootPath;
        return handlers.stream().flatMap(handler -> {
            String basePath = this.getBasePath((WebRequestHandler)handler);
            AuthorizationRealm classAuthorizationRealm = this.getAuthorizationRealm((WebRequestHandler)handler, this.availableAuthorizationRealms);
            return Stream.of(handler.getClass().getMethods()).map(method -> this.parseMethod(basePath, (WebRequestHandler)handler, (Method)method, classAuthorizationRealm)).filter(Optional::isPresent).map(Optional::get);
        }).collect(Collectors.groupingBy(this.getEndpointIdentifier(path))).entrySet().stream().map(entry -> this.asRoute((EndpointIdentifier)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }

    private Route asRoute(EndpointIdentifier endpointIdentifier, List<AutowirableMethod> methods) {
        for (AutowirableMethod method : methods) {
            for (AutowirableMethod current : methods) {
                if (method == current || !current.getVersionRange().overlaps(method.getVersionRange())) continue;
                throw new AutowiringException(String.format("Endpoint version for method '%s' on '%s' overlaps with endpoint version for method '%s' on '%s' ", current.getTargetMethod().getName(), current.getTargetObjectType().getSimpleName(), method.getTargetMethod().getName(), method.getTargetObjectType().getSimpleName()));
            }
        }
        AutowiredRequestHandler requestHandler = new AutowiredRequestHandler(methods);
        return endpointIdentifier.accessType.route(endpointIdentifier.path, requestHandler);
    }

    private Function<AutowirableMethod, EndpointIdentifier> getEndpointIdentifier(String rootPath) {
        return method -> new EndpointIdentifier(method.getAccessType(), this.getPath((AutowirableMethod)method, rootPath));
    }

    private String getPath(AutowirableMethod method, String rootPath) {
        String versionPath = method.getVersionRange() == null ? "" : VERSION_PATH_PARAMETER;
        return Paths.concat(rootPath, versionPath, method.getPath()).orElse(DEFAULT_PATH);
    }

    private class AutowiredRequestHandler
    implements RequestHandler {
        private final List<AutowirableMethod> methods;

        private AutowiredRequestHandler(List<AutowirableMethod> methods) {
            this.methods = methods;
        }

        @Override
        public Response process(Request request, Response currentResponse) {
            return request.pathParam(WebRequestHandlerParser.VERSION_PATH_PARAMETER).flatMap(Version::from).map(version -> this.withVersion(request, (Version)version)).orElse(this.withoutVersion(request));
        }

        private Response withVersion(Request request, Version version) {
            return this.methods.stream().filter(method -> method.getVersionRange() != null).filter(method -> method.getVersionRange().allows(version)).findFirst().map(method -> method.invokeFromRequest(request, WebRequestHandlerParser.this.context)).orElse(this.notFound(request, version));
        }

        private Response withoutVersion(Request request) {
            return this.methods.stream().filter(method -> method.getVersionRange() == null).findFirst().map(method -> method.invokeFromRequest(request, WebRequestHandlerParser.this.context)).orElse(this.notFound(request));
        }

        private Response notFound(Request request, Version version) {
            return NotFound.with(String.format("Endpoint '%s' not available in API version %s", request.path(), version));
        }

        private Response notFound(Request request) {
            return NotFound.with(String.format("Endpoint '%s' not available in API", request.path()));
        }
    }

    private static class EndpointIdentifier {
        private final AccessType accessType;
        private final String path;

        private EndpointIdentifier(AccessType accessType, String path) {
            this.accessType = accessType;
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EndpointIdentifier that = (EndpointIdentifier)o;
            return this.accessType == that.accessType && Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.accessType, this.path});
        }
    }
}

