/*
 * Decompiled with CFR 0.152.
 */
package io.aboutcode.stage.web;

import io.aboutcode.stage.web.request.RequestHandler;
import io.aboutcode.stage.web.request.RequestType;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Route {
    private final RequestType type;
    private final String path;
    private final RequestHandler requestHandler;

    private Route(RequestType type, String path, RequestHandler requestHandler) {
        this.type = type;
        this.path = path;
        this.requestHandler = requestHandler;
    }

    public static List<Route> list(Route ... routes) {
        return Stream.of(routes).collect(Collectors.toList());
    }

    public static Route before(String path, RequestHandler requestHandler) {
        return new Route(RequestType.BEFORE_ALL, path, requestHandler);
    }

    public static Route before(RequestHandler requestHandler) {
        return new Route(RequestType.BEFORE_ALL, null, requestHandler);
    }

    public static Route after(String path, RequestHandler requestHandler) {
        return new Route(RequestType.AFTER_ALL, path, requestHandler);
    }

    public static Route after(RequestHandler requestHandler) {
        return new Route(RequestType.AFTER_ALL, null, requestHandler);
    }

    public static Route get(String path, RequestHandler requestHandler) {
        return new Route(RequestType.GET, path, requestHandler);
    }

    public static Route post(String path, RequestHandler requestHandler) {
        return new Route(RequestType.POST, path, requestHandler);
    }

    public static Route put(String path, RequestHandler requestHandler) {
        return new Route(RequestType.PUT, path, requestHandler);
    }

    public static Route delete(String path, RequestHandler requestHandler) {
        return new Route(RequestType.DELETE, path, requestHandler);
    }

    public static Route options(String path, RequestHandler requestHandler) {
        return new Route(RequestType.OPTIONS, path, requestHandler);
    }

    public static Route patch(String path, RequestHandler requestHandler) {
        return new Route(RequestType.PATCH, path, requestHandler);
    }

    public RequestType getType() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }
}

