/*
 * Decompiled with CFR 0.152.
 */
package io.aboutcode.stage.health;

import io.aboutcode.stage.component.BaseComponent;
import io.aboutcode.stage.health.HealthMonitorable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class HealthManager
extends BaseComponent {
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final List<ScheduledFuture> schedules = new ArrayList<ScheduledFuture>();

    public void addHealthMonitorable(HealthMonitorable monitorable, long checkInterval, TimeUnit checkIntervalTimeUnit) {
        this.schedules.add(this.executorService.scheduleWithFixedDelay(() -> {
            if (!monitorable.isHealthy()) {
                monitorable.recover();
            }
        }, checkInterval, checkInterval, checkIntervalTimeUnit));
    }

    public void stop() {
        this.schedules.forEach(scheduledFuture -> scheduledFuture.cancel(true));
    }
}

