/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageDecodeException;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class MessageSerializer {
    private static HttpCore.BodyHandler<Message> messageResponseHandler = new MessageBodyHandler(null);
    private static final String TAG = MessageSerializer.class.getName();

    public static Message[] readMsgpackArray(MessageUnpacker unpacker) throws IOException {
        int count = unpacker.unpackArrayHeader();
        Message[] result = new Message[count];
        for (int i = 0; i < count; ++i) {
            result[i] = Message.fromMsgpack(unpacker);
        }
        return result;
    }

    public static Message[] readMsgpack(byte[] packed) throws AblyException {
        try {
            MessageUnpacker unpacker = Serialisation.msgpackUnpackerConfig.newUnpacker(packed);
            return MessageSerializer.readMsgpackArray(unpacker);
        }
        catch (IOException ioe) {
            throw AblyException.fromThrowable(ioe);
        }
    }

    public static HttpCore.RequestBody asMsgpackRequest(Message message) throws AblyException {
        return MessageSerializer.asMsgpackRequest(new Message[]{message});
    }

    public static HttpCore.RequestBody asMsgpackRequest(Message[] messages) {
        return new HttpUtils.ByteArrayRequestBody(MessageSerializer.writeMsgpackArray(messages), "application/x-msgpack");
    }

    public static byte[] writeMsgpackArray(Message[] messages) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MessagePacker packer = Serialisation.msgpackPackerConfig.newPacker((OutputStream)out);
            MessageSerializer.writeMsgpackArray(messages, packer);
            packer.flush();
            return out.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void writeMsgpackArray(Message[] messages, MessagePacker packer) {
        try {
            int count = messages.length;
            packer.packArrayHeader(count);
            for (Message message : messages) {
                message.writeMsgpack(packer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static HttpCore.RequestBody asMsgpackRequest(Message.Batch[] pubSpecs) {
        return new HttpUtils.ByteArrayRequestBody(MessageSerializer.writeMsgpackArray(pubSpecs), "application/x-msgpack");
    }

    static byte[] writeMsgpackArray(Message.Batch[] pubSpecs) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MessagePacker packer = Serialisation.msgpackPackerConfig.newPacker((OutputStream)out);
            MessageSerializer.writeMsgpackArray(pubSpecs, packer);
            packer.flush();
            return out.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    static void writeMsgpackArray(Message.Batch[] pubSpecs, MessagePacker packer) throws IOException {
        try {
            int count = pubSpecs.length;
            packer.packArrayHeader(count);
            for (Message.Batch spec : pubSpecs) {
                spec.writeMsgpack(packer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Message[] readJSON(byte[] packed) throws IOException {
        return (Message[])Serialisation.gson.fromJson(new String(packed), Message[].class);
    }

    public static HttpCore.RequestBody asJsonRequest(Message message) throws AblyException {
        return MessageSerializer.asJsonRequest(new Message[]{message});
    }

    public static HttpCore.RequestBody asJsonRequest(Message[] messages) {
        return new HttpUtils.JsonRequestBody(Serialisation.gson.toJson((Object)messages));
    }

    public static HttpCore.RequestBody asJSONRequest(Message.Batch[] pubSpecs) {
        return new HttpUtils.JsonRequestBody(Serialisation.gson.toJson((Object)pubSpecs));
    }

    public static HttpCore.BodyHandler<Message> getMessageResponseHandler(ChannelOptions opts) {
        return opts == null ? messageResponseHandler : new MessageBodyHandler(opts);
    }

    private static class MessageBodyHandler
    implements HttpCore.BodyHandler<Message> {
        private ChannelOptions opts;

        public MessageBodyHandler(ChannelOptions opts) {
            this.opts = opts;
        }

        public Message[] handleResponseBody(String contentType, byte[] body) throws AblyException {
            try {
                Message[] messages = null;
                if ("application/json".equals(contentType)) {
                    messages = MessageSerializer.readJSON(body);
                } else if ("application/x-msgpack".equals(contentType)) {
                    messages = MessageSerializer.readMsgpack(body);
                }
                if (messages != null) {
                    for (Message message : messages) {
                        try {
                            message.decode(this.opts);
                        }
                        catch (MessageDecodeException e) {
                            Log.e(TAG, e.errorInfo.message);
                        }
                    }
                }
                return messages;
            }
            catch (IOException e) {
                throw AblyException.fromThrowable(e);
            }
        }
    }
}

