/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.transport;

import io.ably.lib.debug.DebugOptions;
import io.ably.lib.http.HttpHelpers;
import io.ably.lib.realtime.AblyRealtime;
import io.ably.lib.realtime.Channel;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.realtime.Connection;
import io.ably.lib.realtime.ConnectionState;
import io.ably.lib.realtime.ConnectionStateListener;
import io.ably.lib.transport.Defaults;
import io.ably.lib.transport.Hosts;
import io.ably.lib.transport.ITransport;
import io.ably.lib.transport.NetworkConnectivity;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ConnectionDetails;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.ProtocolMessage;
import io.ably.lib.types.ProtocolSerializer;
import io.ably.lib.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ConnectionManager
implements ITransport.ConnectListener {
    private static final String TAG = ConnectionManager.class.getName();
    private static final String INTERNET_CHECK_URL = "http://internet-up.ably-realtime.com/is-the-internet-up.txt";
    private static final String INTERNET_CHECK_OK = "yes";
    static ErrorInfo REASON_CLOSED = new ErrorInfo("Connection closed by client", 200, 10000);
    static ErrorInfo REASON_DISCONNECTED = new ErrorInfo("Connection temporarily unavailable", 503, 80003);
    static ErrorInfo REASON_SUSPENDED = new ErrorInfo("Connection unavailable", 503, 80002);
    static ErrorInfo REASON_FAILED = new ErrorInfo("Connection failed", 503, 80000);
    static ErrorInfo REASON_REFUSED = new ErrorInfo("Access refused", 401, 40100);
    static ErrorInfo REASON_TOO_BIG = new ErrorInfo("Connection closed; message too large", 400, 40000);
    static ErrorInfo REASON_NEVER_CONNECTED = new ErrorInfo("Unable to establish connection", 503, 80002);
    static ErrorInfo REASON_TIMEDOUT = new ErrorInfo("Unable to establish connection", 503, 80014);
    public static final HashMap<ConnectionState, StateInfo> states = new HashMap<ConnectionState, StateInfo>(){
        {
            this.put(ConnectionState.initialized, new StateInfo(ConnectionState.initialized, true, false, false, false, 0L, null));
            this.put(ConnectionState.connecting, new StateInfo(ConnectionState.connecting, true, false, false, false, Defaults.TIMEOUT_CONNECT, null));
            this.put(ConnectionState.connected, new StateInfo(ConnectionState.connected, false, true, false, false, 0L, null));
            this.put(ConnectionState.disconnected, new StateInfo(ConnectionState.disconnected, true, false, false, true, Defaults.TIMEOUT_DISCONNECT, REASON_DISCONNECTED));
            this.put(ConnectionState.suspended, new StateInfo(ConnectionState.suspended, false, false, false, true, Defaults.connectionStateTtl, REASON_SUSPENDED));
            this.put(ConnectionState.closing, new StateInfo(ConnectionState.closing, false, false, false, false, Defaults.TIMEOUT_CONNECT, REASON_CLOSED));
            this.put(ConnectionState.closed, new StateInfo(ConnectionState.closed, false, false, true, false, 0L, REASON_CLOSED));
            this.put(ConnectionState.failed, new StateInfo(ConnectionState.failed, false, false, true, false, 0L, REASON_FAILED));
        }
    };
    long maxIdleInterval = Defaults.maxIdleInterval;
    long connectionStateTtl = Defaults.connectionStateTtl;
    final AblyRealtime ably;
    private final ClientOptions options;
    private final Connection connection;
    private final ITransport.Factory factory;
    private final List<QueuedMessage> queuedMessages;
    private final PendingMessageQueue pendingMessages;
    private final HashSet<Object> heartbeatWaiters = new HashSet();
    private final Hosts hosts;
    private CMThread mgrThread;
    private StateInfo state;
    private ErrorInfo stateError;
    private StateIndication requestedState;
    private ConnectParams pendingConnect;
    private boolean pendingReauth;
    private boolean suppressRetry;
    private ITransport transport;
    private long suspendTime;
    private long msgSerial;
    private long lastActivity;
    private CMConnectivityListener connectivityListener;
    private DebugOptions.RawProtocolListener protocolListener;
    private String lastUsedHost;
    private static final long HEARTBEAT_TIMEOUT = 5000L;

    public ErrorInfo getStateErrorInfo() {
        return this.stateError != null ? this.stateError : this.state.defaultErrorInfo;
    }

    public boolean isActive() {
        return this.state.queueEvents || this.state.sendEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionManager(AblyRealtime ably, Connection connection) {
        this.ably = ably;
        this.options = ably.options;
        this.connection = connection;
        this.queuedMessages = new ArrayList<QueuedMessage>();
        this.pendingMessages = new PendingMessageQueue();
        this.state = states.get((Object)ConnectionState.initialized);
        String transportClass = Defaults.TRANSPORT;
        try {
            this.hosts = new Hosts(this.options.realtimeHost, "realtime.ably.io", this.options);
            if (this.options instanceof DebugOptions) {
                this.protocolListener = ((DebugOptions)this.options).protocolListener;
            }
            this.factory = (ITransport.Factory)Class.forName(transportClass).newInstance();
        }
        catch (Exception e) {
            String msg = "Unable to instance factory class";
            Log.e(this.getClass().getName(), msg, e);
            throw new RuntimeException(msg, e);
        }
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            this.setSuspendTime();
        }
    }

    public String getHost() {
        return this.lastUsedHost;
    }

    public void connect() {
        boolean connectionAttemptInProgress;
        boolean connectionExist = this.state.state == ConnectionState.connected;
        boolean bl = connectionAttemptInProgress = this.requestedState != null && this.requestedState.state == ConnectionState.connecting || this.state.state == ConnectionState.connecting;
        if (!connectionExist && !connectionAttemptInProgress) {
            this.startup();
            this.requestState(ConnectionState.connecting);
        }
    }

    public void close() {
        this.requestState(ConnectionState.closing);
    }

    public synchronized StateInfo getConnectionState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setState(StateIndication newState) {
        ConnectionStateListener.ConnectionStateChange change;
        StateInfo newStateInfo = states.get((Object)newState.state);
        Iterator iterator = this;
        synchronized (iterator) {
            if (newState.state == this.state.state) {
                Log.v(TAG, "setState(): unchanged " + (Object)((Object)newState.state));
                return false;
            }
            ErrorInfo reason = newState.reason;
            if (reason == null) {
                reason = newStateInfo.defaultErrorInfo;
            }
            Log.v(TAG, "setState(): setting " + (Object)((Object)newState.state) + "; reason " + reason);
            change = new ConnectionStateListener.ConnectionStateChange(this.state.state, newState.state, newStateInfo.timeout, reason);
            newStateInfo.host = newState.currentHost;
            this.state = newStateInfo;
            this.stateError = reason;
            if (change.current != change.previous) {
                this.pendingReauth = false;
            }
            if (this.state.terminal) {
                this.clearTransport();
                this.shutdown();
            }
        }
        this.connection.onConnectionStateChange(change);
        if (this.state.sendEvents) {
            this.sendQueuedMessages();
        } else if (!this.state.queueEvents) {
            this.failQueuedMessages(this.state.defaultErrorInfo);
        }
        switch (this.state.state) {
            case connected: {
                for (Channel channel : this.ably.channels.values()) {
                    channel.setConnected();
                }
                break;
            }
            case disconnected: {
                break;
            }
            case failed: {
                for (Channel channel : this.ably.channels.values()) {
                    channel.setConnectionFailed(change.reason);
                }
                break;
            }
            case closed: {
                for (Channel channel : this.ably.channels.values()) {
                    channel.setConnectionClosed(this.state.defaultErrorInfo);
                }
                break;
            }
            case suspended: {
                for (Channel channel : this.ably.channels.values()) {
                    channel.setSuspended(this.state.defaultErrorInfo, true);
                }
                break;
            }
        }
        return true;
    }

    public void requestState(ConnectionState state) {
        this.requestState(new StateIndication(state, null));
    }

    public synchronized void requestState(StateIndication state) {
        Log.v(TAG, "requestState(): requesting " + (Object)((Object)state.state) + "; id = " + this.connection.id);
        this.requestedState = state;
        this.notify();
    }

    private synchronized void requestState(ITransport transport, StateIndication state) {
        if (transport != null) {
            if (this.transport != transport) {
                Log.v(TAG, "requestState: notification received for superseded transport");
                return;
            }
            if (ConnectionManager.states.get((Object)((Object)state.state)).terminal) {
                this.transport = null;
            }
        }
        this.requestState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping(final CompletionListener listener) {
        block8: {
            if (this.state.state != ConnectionState.connected) {
                if (listener != null) {
                    listener.onError(new ErrorInfo("Unable to ping service; not connected", 40000, 400));
                }
                return;
            }
            if (listener != null) {
                Runnable waiter = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean pending;
                        HashSet hashSet = ConnectionManager.this.heartbeatWaiters;
                        synchronized (hashSet) {
                            pending = ConnectionManager.this.heartbeatWaiters.contains(this);
                            if (pending) {
                                try {
                                    ConnectionManager.this.heartbeatWaiters.wait(5000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            pending = ConnectionManager.this.heartbeatWaiters.remove(this);
                        }
                        if (pending) {
                            listener.onError(new ErrorInfo("Timed out waiting for heartbeat response", 50000, 500));
                        } else {
                            listener.onSuccess();
                        }
                    }
                };
                HashSet<Object> hashSet = this.heartbeatWaiters;
                synchronized (hashSet) {
                    this.heartbeatWaiters.add(waiter);
                    new Thread(waiter).start();
                }
            }
            try {
                this.send(new ProtocolMessage(ProtocolMessage.Action.heartbeat), false, null);
            }
            catch (AblyException e) {
                if (listener == null) break block8;
                listener.onError(e.errorInfo);
            }
        }
    }

    public void onAuthUpdated(String token, boolean waitForResponse) throws AblyException {
        ErrorInfo reason;
        ConnectionWaiter waiter = new ConnectionWaiter();
        if (this.state.state == ConnectionState.connected) {
            try {
                ProtocolMessage msg = new ProtocolMessage(ProtocolMessage.Action.auth);
                msg.auth = new ProtocolMessage.AuthDetails(token);
                this.send(msg, false, null);
            }
            catch (AblyException e) {
                Log.v(TAG, "onAuthUpdated: closing transport after send failure");
                this.transport.close(false);
            }
        } else {
            if (this.state.state == ConnectionState.connecting) {
                Log.v(TAG, "onAuthUpdated: closing connecting transport");
                this.transport.close(false);
            }
            this.connect();
        }
        if (!waitForResponse) {
            return;
        }
        block6: while (true) {
            reason = waiter.waitForChange();
            switch (this.state.state) {
                case connected: {
                    Log.v(TAG, "onAuthUpdated: got connected");
                    return;
                }
                case disconnected: 
                case connecting: {
                    continue block6;
                }
            }
            break;
        }
        Log.v(TAG, "onAuthUpdated: throwing exception");
        throw AblyException.fromErrorInfo(reason);
    }

    public void onAuthError(ErrorInfo errorInfo) {
        Log.i(TAG, String.format("onAuthError: (%d) %s", errorInfo.code, errorInfo.message));
        switch (this.state.state) {
            case connecting: {
                ITransport transport = this.transport;
                if (transport == null) break;
                this.onTransportUnavailable(transport, null, errorInfo);
                break;
            }
            case connected: {
                this.connection.emitUpdate(errorInfo);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ITransport transport, ProtocolMessage message) throws AblyException {
        if (transport != null && this.transport != transport) {
            return;
        }
        if (Log.level <= 2) {
            Log.v(TAG, "onMessage() (transport = " + transport + "): " + (Object)((Object)message.action) + ": " + new String(ProtocolSerializer.writeJSON(message)));
        }
        try {
            if (this.protocolListener != null) {
                this.protocolListener.onRawMessageRecv(message);
            }
            switch (message.action) {
                case heartbeat: {
                    this.onHeartbeat(message);
                    break;
                }
                case error: {
                    ErrorInfo reason = message.error;
                    if (reason == null) {
                        Log.e(TAG, "onMessage(): ERROR message received (no error detail)");
                    } else {
                        Log.e(TAG, "onMessage(): ERROR message received; message = " + reason.message + "; code = " + reason.code);
                    }
                    if (message.channel != null) {
                        this.onChannelMessage(message);
                        break;
                    }
                    this.onError(message);
                    break;
                }
                case connected: {
                    this.onConnected(message);
                    break;
                }
                case disconnect: 
                case disconnected: {
                    this.onDisconnected(message);
                    break;
                }
                case closed: {
                    this.onClosed(message);
                    break;
                }
                case ack: {
                    this.onAck(message);
                    break;
                }
                case nack: {
                    this.onNack(message);
                    break;
                }
                case auth: {
                    ConnectionManager connectionManager = this;
                    synchronized (connectionManager) {
                        this.pendingReauth = true;
                        this.notify();
                        break;
                    }
                }
                default: {
                    this.onChannelMessage(message);
                }
            }
        }
        catch (Exception e) {
            throw AblyException.fromThrowable(e);
        }
    }

    private void onChannelMessage(ProtocolMessage message) {
        if (message.connectionSerial != null) {
            this.connection.serial = message.connectionSerial;
            if (this.connection.key != null) {
                this.connection.recoveryKey = this.connection.key + ":" + message.connectionSerial;
            }
        }
        this.ably.channels.onChannelMessage(this.transport, message);
    }

    private synchronized void onConnected(ProtocolMessage message) {
        ErrorInfo error = message.error;
        if (this.connection.id != null && !message.connectionId.equals(this.connection.id)) {
            if (error == null) {
                error = REASON_SUSPENDED;
            }
            this.ably.channels.suspendAll(error, false);
        }
        ConnectionDetails connectionDetails = message.connectionDetails;
        this.connection.key = connectionDetails.connectionKey;
        if (!message.connectionId.equals(this.connection.id)) {
            this.pendingMessages.reset(this.msgSerial, new ErrorInfo("Connection resume failed", 500, 50000));
            this.msgSerial = 0L;
        }
        this.connection.id = message.connectionId;
        if (message.connectionSerial != null) {
            this.connection.serial = message.connectionSerial;
            if (this.connection.key != null) {
                this.connection.recoveryKey = this.connection.key + ":" + message.connectionSerial;
            }
        }
        this.maxIdleInterval = connectionDetails.maxIdleInterval;
        this.connectionStateTtl = connectionDetails.connectionStateTtl;
        String clientId = connectionDetails.clientId;
        try {
            this.ably.auth.setClientId(clientId);
        }
        catch (AblyException e) {
            this.requestState(this.transport, new StateIndication(ConnectionState.failed, e.errorInfo));
        }
        this.setSuspendTime();
        this.requestState(new StateIndication(ConnectionState.connected, error));
    }

    private synchronized void onDisconnected(ProtocolMessage message) {
        this.onTransportUnavailable(this.transport, null, message.error);
    }

    private synchronized void onClosed(ProtocolMessage message) {
        if (message.error != null) {
            this.onError(message);
        } else {
            this.connection.key = null;
            this.requestState(new StateIndication(ConnectionState.closed, null));
        }
    }

    private synchronized void onError(ProtocolMessage message) {
        this.connection.key = null;
        ErrorInfo reason = message.error;
        this.ably.auth.onAuthError(reason);
        ConnectionState destinationState = this.isFatalError(reason) ? ConnectionState.failed : ConnectionState.disconnected;
        this.requestState(this.transport, new StateIndication(destinationState, reason));
    }

    private void onAck(ProtocolMessage message) {
        this.pendingMessages.ack(message.msgSerial, message.count, message.error);
    }

    private void onNack(ProtocolMessage message) {
        this.pendingMessages.nack(message.msgSerial, message.count, message.error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onHeartbeat(ProtocolMessage message) {
        HashSet<Object> hashSet = this.heartbeatWaiters;
        synchronized (hashSet) {
            this.heartbeatWaiters.clear();
            this.heartbeatWaiters.notifyAll();
        }
    }

    private void startup() {
        this.startThread();
        this.startConnectivityListener();
    }

    private void shutdown() {
        this.stopConnectivityListener();
        this.stopThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThread() {
        boolean creating = false;
        Object object = this;
        synchronized (object) {
            if (this.mgrThread == null) {
                this.mgrThread = new CMThread();
                this.state = states.get((Object)ConnectionState.initialized);
                creating = true;
            }
        }
        if (creating) {
            object = this.mgrThread;
            synchronized (object) {
                this.mgrThread.start();
                try {
                    this.mgrThread.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void stopThread() {
        if (this.mgrThread != null) {
            this.mgrThread.setExiting();
            this.mgrThread = null;
        }
    }

    private StateIndication handleStateRequest() {
        StateIndication transitionState = this.requestedState;
        this.requestedState = null;
        if (transitionState.state == ConnectionState.connecting) {
            if (this.connectImpl(transitionState)) {
                return transitionState;
            }
            return new StateIndication(ConnectionState.failed, new ErrorInfo("Connection failed; no host available", 404, 80000), null, this.requestedState.currentHost);
        }
        if (this.state.terminal) {
            return null;
        }
        switch (transitionState.state) {
            case disconnected: {
                if (this.transport == null) break;
                this.transport.close(false);
                break;
            }
            case failed: {
                if (this.transport == null) break;
                this.transport.abort(transitionState.reason);
                break;
            }
            case closing: {
                this.closeImpl(transitionState);
                break;
            }
        }
        return transitionState;
    }

    private boolean checkConnectionStale() {
        if (this.lastActivity == 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        long intervalSinceLastActivity = now - this.lastActivity;
        if (intervalSinceLastActivity > this.maxIdleInterval + this.connectionStateTtl) {
            if (this.connection.key != null) {
                Log.v(TAG, "Clearing stale connection key to suppress resume");
                this.connection.key = null;
                this.connection.recoveryKey = null;
            }
            return true;
        }
        return false;
    }

    private void handleStateChange(StateIndication stateChange) {
        boolean changed;
        if (stateChange.state == ConnectionState.disconnected) {
            if (this.checkConnectionStale()) {
                this.requestState(ConnectionState.suspended);
                return;
            }
            switch (this.state.state) {
                case connecting: {
                    stateChange = this.checkSuspend(stateChange);
                    this.pendingConnect = null;
                    break;
                }
                case closing: {
                    ErrorInfo closeReason = stateChange.reason == REASON_DISCONNECTED ? REASON_CLOSED : stateChange.reason;
                    stateChange = new StateIndication(ConnectionState.closed, closeReason);
                    break;
                }
                case failed: 
                case closed: {
                    stateChange = null;
                    break;
                }
                case connected: {
                    this.setSuspendTime();
                    if (this.suppressRetry) break;
                    this.requestState(ConnectionState.connecting);
                    break;
                }
                case suspended: {
                    Log.v(TAG, "handleStateChange: not moving out of suspended");
                    stateChange = null;
                    break;
                }
            }
        }
        if (stateChange != null && !(changed = this.setState(stateChange)) && stateChange.state == ConnectionState.connected) {
            this.connection.emitUpdate(null);
        }
    }

    private void setSuspendTime() {
        this.suspendTime = System.currentTimeMillis() + this.connectionStateTtl;
    }

    private StateIndication checkSuspend(StateIndication stateChange) {
        String hostFallback;
        if (this.pendingConnect != null && (stateChange.reason == null || stateChange.reason.statusCode >= 500) && this.checkConnectivity() && (hostFallback = this.hosts.getFallback(this.pendingConnect.host)) != null) {
            Log.v(TAG, "checkSuspend: fallback to " + hostFallback);
            this.requestState(new StateIndication(ConnectionState.connecting, null, hostFallback, this.pendingConnect.host));
            return null;
        }
        Log.v(TAG, "checkSuspend: not falling back");
        boolean suspendMode = System.currentTimeMillis() > this.suspendTime;
        ConnectionState expiredState = suspendMode ? ConnectionState.suspended : ConnectionState.disconnected;
        return new StateIndication(expiredState, stateChange.reason);
    }

    private void tryWait(long timeout) {
        if (this.requestedState == null && !this.pendingReauth) {
            try {
                if (timeout == 0L) {
                    this.wait();
                } else {
                    this.wait(timeout);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void handleReauth() {
        this.pendingReauth = false;
        if (this.state.state == ConnectionState.connected) {
            Log.v(TAG, "Server initiated reauth");
            ErrorInfo errorInfo = null;
            try {
                this.ably.auth.renew();
            }
            catch (AblyException e) {
                errorInfo = e.errorInfo;
            }
            if (this.state.state == ConnectionState.connected) {
                this.connection.emitUpdate(errorInfo);
            }
        }
    }

    @Override
    public void onTransportAvailable(ITransport transport, ITransport.TransportParams params) {
        if (this.transport != transport) {
            Log.v(TAG, "onTransportAvailable: ignoring connection event from superseded transport");
            return;
        }
        if (this.protocolListener != null) {
            this.protocolListener.onRawConnect(transport.getURL());
        }
    }

    @Override
    public synchronized void onTransportUnavailable(ITransport transport, ITransport.TransportParams params, ErrorInfo reason) {
        this.onTransportUnavailable(transport, params, reason, ConnectionState.disconnected);
    }

    @Override
    public synchronized void onTransportUnavailable(ITransport transport, ITransport.TransportParams params, ErrorInfo reason, ConnectionState state) {
        if (this.transport != transport) {
            Log.v(TAG, "onTransportUnavailable: ignoring disconnection event from superseded transport");
            return;
        }
        if (reason == null) {
            reason = ConnectionManager.states.get((Object)((Object)state)).defaultErrorInfo;
        }
        if (state == ConnectionState.failed) {
            Log.e(TAG, "onTransportUnavailable: unexpected exception in WsClient: " + reason.message);
        } else {
            Log.i(TAG, "onTransportUnavailable: disconnected: " + reason.message);
        }
        this.ably.auth.onAuthError(reason);
        this.requestState(new StateIndication(state, reason, null, transport.getHost()));
        this.transport = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectImpl(StateIndication request) {
        ITransport oldTransport;
        ITransport transport;
        String host = request.fallback;
        if (host == null) {
            host = this.hosts.getPreferredHost();
        }
        this.checkConnectionStale();
        this.pendingConnect = new ConnectParams(this.options);
        this.pendingConnect.host = host;
        this.lastUsedHost = host;
        try {
            transport = this.factory.getTransport(this.pendingConnect, this);
        }
        catch (Exception e) {
            String msg = "Unable to instance transport class";
            Log.e(this.getClass().getName(), msg, e);
            throw new RuntimeException(msg, e);
        }
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            oldTransport = this.transport;
            this.transport = transport;
        }
        if (oldTransport != null) {
            oldTransport.abort(REASON_TIMEDOUT);
        }
        transport.connect(this);
        return true;
    }

    private void closeImpl(StateIndication request) {
        boolean isConnected;
        boolean bl = isConnected = this.state.state == ConnectionState.connected;
        if (this.transport != null) {
            if (isConnected) {
                try {
                    Log.v(TAG, "Requesting connection close");
                    this.transport.send(new ProtocolMessage(ProtocolMessage.Action.close));
                }
                catch (AblyException e) {
                    this.transport.abort(e.errorInfo);
                }
            } else {
                Log.v(TAG, "Closing incomplete transport");
                this.transport.close(false);
            }
            this.transport = null;
        }
        this.requestState(new StateIndication(ConnectionState.closed, null));
    }

    private void clearTransport() {
        if (this.transport != null) {
            this.transport.close(false);
            this.transport = null;
        }
    }

    protected boolean checkConnectivity() {
        try {
            return HttpHelpers.getUrlString(this.ably.httpCore, INTERNET_CHECK_URL).contains(INTERNET_CHECK_OK);
        }
        catch (AblyException e) {
            return false;
        }
    }

    protected void setLastActivity(long lastActivityTime) {
        this.lastActivity = lastActivityTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ProtocolMessage msg, boolean queueEvents, CompletionListener listener) throws AblyException {
        StateInfo state;
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            state = this.state;
            if (state.sendEvents) {
                this.sendImpl(msg, listener);
                return;
            }
            if (state.queueEvents && queueEvents) {
                int queueSize = this.queuedMessages.size();
                if (queueSize > 0) {
                    QueuedMessage lastQueued = this.queuedMessages.get(queueSize - 1);
                    ProtocolMessage lastMessage = lastQueued.msg;
                    if (ProtocolMessage.mergeTo(lastMessage, msg)) {
                        if (!lastQueued.isMerged) {
                            lastQueued.listener = new CompletionListener.Multicaster(lastQueued.listener);
                            lastQueued.isMerged = true;
                        }
                        ((CompletionListener.Multicaster)lastQueued.listener).add(listener);
                        return;
                    }
                }
                this.queuedMessages.add(new QueuedMessage(msg, listener));
                return;
            }
        }
        throw AblyException.fromErrorInfo(state.defaultErrorInfo);
    }

    private void sendImpl(ProtocolMessage message, CompletionListener listener) throws AblyException {
        if (this.transport == null) {
            Log.v(TAG, "sendImpl(): Discarding message; transport unavailable");
            return;
        }
        if (ProtocolMessage.ackRequired(message)) {
            message.msgSerial = this.msgSerial++;
            this.pendingMessages.push(new QueuedMessage(message, listener));
        }
        if (this.protocolListener != null) {
            this.protocolListener.onRawMessageSend(message);
        }
        this.transport.send(message);
    }

    private void sendImpl(QueuedMessage msg) throws AblyException {
        if (this.transport == null) {
            Log.v(TAG, "sendImpl(): Discarding message; transport unavailable");
            return;
        }
        ProtocolMessage message = msg.msg;
        if (ProtocolMessage.ackRequired(message)) {
            message.msgSerial = this.msgSerial++;
            this.pendingMessages.push(msg);
        }
        if (this.protocolListener != null) {
            this.protocolListener.onRawMessageSend(message);
        }
        this.transport.send(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQueuedMessages() {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            while (this.queuedMessages.size() > 0) {
                try {
                    this.sendImpl(this.queuedMessages.get(0));
                }
                catch (AblyException e) {
                    Log.e(TAG, "sendQueuedMessages(): Unexpected error sending queued messages", e);
                }
                finally {
                    this.queuedMessages.remove(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failQueuedMessages(ErrorInfo reason) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            for (QueuedMessage queued : this.queuedMessages) {
                if (queued.listener == null) continue;
                try {
                    queued.listener.onError(reason);
                }
                catch (Throwable t) {
                    Log.e(TAG, "failQueuedMessages(): Unexpected error calling listener", t);
                }
            }
            this.queuedMessages.clear();
        }
    }

    private void startConnectivityListener() {
        this.connectivityListener = new CMConnectivityListener();
        this.ably.platform.getNetworkConnectivity().addListener(this.connectivityListener);
    }

    private void stopConnectivityListener() {
        this.ably.platform.getNetworkConnectivity().removeListener(this.connectivityListener);
        this.connectivityListener = null;
    }

    void disconnectAndSuppressRetries() {
        this.requestState(ConnectionState.disconnected);
        this.suppressRetry = true;
    }

    private boolean isFatalError(ErrorInfo err) {
        if (err.code != 0) {
            if (err.code >= 40140 && err.code < 40150) {
                return false;
            }
            if (err.code >= 40000 && err.code < 50000) {
                return true;
            }
        }
        return err.statusCode != 0 && err.statusCode < 500;
    }

    private class CMConnectivityListener
    implements NetworkConnectivity.NetworkConnectivityListener {
        private CMConnectivityListener() {
        }

        @Override
        public void onNetworkAvailable() {
            ConnectionManager cm = ConnectionManager.this;
            ConnectionState currentState = ((ConnectionManager)cm).state.state;
            Log.i(TAG, "onNetworkAvailable(): currentState = " + currentState.name());
            if (currentState == ConnectionState.disconnected || currentState == ConnectionState.suspended) {
                Log.i(TAG, "onNetworkAvailable(): initiating reconnect");
                cm.connect();
            }
        }

        @Override
        public void onNetworkUnavailable(ErrorInfo reason) {
            ConnectionManager cm = ConnectionManager.this;
            ConnectionState currentState = ((ConnectionManager)cm).state.state;
            Log.i(TAG, "onNetworkUnavailable(); currentState = " + currentState.name() + "; reason = " + reason.toString());
            if (currentState == ConnectionState.connected || currentState == ConnectionState.connecting) {
                Log.i(TAG, "onNetworkUnavailable(): closing connected transport");
                cm.requestState(new StateIndication(ConnectionState.disconnected, reason));
            }
        }
    }

    private class PendingMessageQueue {
        private long startSerial = 0L;
        private ArrayList<QueuedMessage> queue = new ArrayList();

        private PendingMessageQueue() {
        }

        public synchronized void push(QueuedMessage msg) {
            this.queue.add(msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ack(long msgSerial, int count, ErrorInfo reason) {
            QueuedMessage[] ackMessages = null;
            QueuedMessage[] nackMessages = null;
            PendingMessageQueue pendingMessageQueue = this;
            synchronized (pendingMessageQueue) {
                if (msgSerial < this.startSerial) {
                    if ((count -= (int)(this.startSerial - msgSerial)) < 0) {
                        count = 0;
                    }
                    msgSerial = this.startSerial;
                }
                if (msgSerial > this.startSerial) {
                    int nCount = (int)(msgSerial - this.startSerial);
                    List<QueuedMessage> nackList = this.queue.subList(0, nCount);
                    nackMessages = nackList.toArray(new QueuedMessage[nCount]);
                    nackList.clear();
                    this.startSerial = msgSerial;
                }
                if (msgSerial == this.startSerial) {
                    List<QueuedMessage> ackList = this.queue.subList(0, count);
                    ackMessages = ackList.toArray(new QueuedMessage[count]);
                    ackList.clear();
                    this.startSerial += (long)count;
                }
            }
            if (nackMessages != null) {
                if (reason == null) {
                    reason = new ErrorInfo("Unknown error", 500, 50000);
                }
                for (PendingMessageQueue pendingMessageQueue2 : nackMessages) {
                    try {
                        if (((QueuedMessage)((Object)pendingMessageQueue2)).listener == null) continue;
                        ((QueuedMessage)((Object)pendingMessageQueue2)).listener.onError(reason);
                    }
                    catch (Throwable t) {
                        Log.e(TAG, "ack(): listener exception", t);
                    }
                }
            }
            if (ackMessages != null) {
                for (PendingMessageQueue pendingMessageQueue3 : ackMessages) {
                    try {
                        if (((QueuedMessage)((Object)pendingMessageQueue3)).listener == null) continue;
                        ((QueuedMessage)((Object)pendingMessageQueue3)).listener.onSuccess();
                    }
                    catch (Throwable t) {
                        Log.e(TAG, "ack(): listener exception", t);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void nack(long serial, int count, ErrorInfo reason) {
            QueuedMessage[] nackMessages = null;
            QueuedMessage[] queuedMessageArray = this;
            synchronized (this) {
                if (serial != this.startSerial) {
                    count -= (int)(this.startSerial - serial);
                    serial = this.startSerial;
                }
                List<QueuedMessage> nackList = this.queue.subList(0, count);
                nackMessages = nackList.toArray(new QueuedMessage[count]);
                nackList.clear();
                this.startSerial += (long)count;
                // ** MonitorExit[var6_5] (shouldn't be in output)
                if (nackMessages != null) {
                    if (reason == null) {
                        reason = new ErrorInfo("Unknown error", 500, 50000);
                    }
                    for (QueuedMessage msg : nackMessages) {
                        try {
                            if (msg.listener == null) continue;
                            msg.listener.onError(reason);
                        }
                        catch (Throwable t) {
                            Log.e(TAG, "nack(): listener exception", t);
                        }
                    }
                }
                return;
            }
        }

        public synchronized void reset(long oldMsgSerial, ErrorInfo err) {
            this.nack(this.startSerial, (int)(oldMsgSerial - this.startSerial), err);
            this.startSerial = 0L;
        }
    }

    public static class QueuedMessage {
        public final ProtocolMessage msg;
        public CompletionListener listener;
        private boolean isMerged;

        public QueuedMessage(ProtocolMessage msg, CompletionListener listener) {
            this.msg = msg;
            this.listener = listener;
        }
    }

    private class ConnectParams
    extends ITransport.TransportParams {
        ConnectParams(ClientOptions options) {
            this.options = options;
            this.connectionKey = ((ConnectionManager)ConnectionManager.this).connection.key;
            this.connectionSerial = String.valueOf(((ConnectionManager)ConnectionManager.this).connection.serial);
            this.port = Defaults.getPort(options);
        }
    }

    class CMThread
    extends Thread {
        private boolean exiting = false;

        CMThread() {
        }

        private void setExiting() {
            this.exiting = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConnectionManager cm = ConnectionManager.this;
            while (!this.exiting) {
                StateIndication stateChange = null;
                ConnectionManager connectionManager = cm;
                synchronized (connectionManager) {
                    if (((ConnectionManager)ConnectionManager.this).state.state == ConnectionState.initialized) {
                        CMThread cMThread = this;
                        synchronized (cMThread) {
                            this.notify();
                        }
                    }
                    while (!this.exiting && stateChange == null) {
                        ConnectionManager.this.tryWait(((ConnectionManager)ConnectionManager.this).state.timeout);
                        if (ConnectionManager.this.pendingReauth) {
                            ConnectionManager.this.handleReauth();
                            continue;
                        }
                        if (ConnectionManager.this.requestedState != null) {
                            stateChange = ConnectionManager.this.handleStateRequest();
                            continue;
                        }
                        if (((ConnectionManager)ConnectionManager.this).state.retry && !ConnectionManager.this.suppressRetry) {
                            ConnectionManager.this.requestState(ConnectionState.connecting);
                            continue;
                        }
                        stateChange = ConnectionManager.this.checkSuspend(new StateIndication(ConnectionState.disconnected, REASON_TIMEDOUT));
                    }
                }
                if (this.exiting) break;
                if (stateChange == null) continue;
                ConnectionManager.this.handleStateChange(stateChange);
            }
        }
    }

    public class ConnectionWaiter
    implements ConnectionStateListener {
        private ConnectionStateListener.ConnectionStateChange change;

        public ConnectionWaiter() {
            ConnectionManager.this.connection.on(this);
        }

        public synchronized ErrorInfo waitForChange() {
            Log.d(TAG, "ConnectionWaiter.waitFor()");
            if (this.change == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Log.d(TAG, "ConnectionWaiter.waitFor done: state=" + ConnectionManager.this.state + ")");
            ErrorInfo reason = this.change.reason;
            this.change = null;
            return reason;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectionStateChanged(ConnectionStateListener.ConnectionStateChange state) {
            ConnectionWaiter connectionWaiter = this;
            synchronized (connectionWaiter) {
                this.change = state;
                this.notify();
            }
        }
    }

    public static class StateInfo {
        public final ConnectionState state;
        public final ErrorInfo defaultErrorInfo;
        public final boolean queueEvents;
        public final boolean sendEvents;
        final boolean terminal;
        final boolean retry;
        public long timeout;
        String host;

        StateInfo(ConnectionState state, boolean queueEvents, boolean sendEvents, boolean terminal, boolean retry, long timeout, ErrorInfo defaultErrorInfo) {
            this.state = state;
            this.queueEvents = queueEvents;
            this.sendEvents = sendEvents;
            this.terminal = terminal;
            this.retry = retry;
            this.timeout = timeout;
            this.defaultErrorInfo = defaultErrorInfo;
        }
    }

    public static class StateIndication {
        final ConnectionState state;
        final ErrorInfo reason;
        final String fallback;
        final String currentHost;

        public StateIndication(ConnectionState state, ErrorInfo reason) {
            this(state, reason, null, null);
        }

        public StateIndication(ConnectionState state, ErrorInfo reason, String fallback, String currentHost) {
            this.state = state;
            this.reason = reason;
            this.fallback = fallback;
            this.currentHost = currentHost;
        }
    }
}

