/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.transport;

import io.ably.lib.http.HttpUtils;
import io.ably.lib.realtime.ConnectionState;
import io.ably.lib.transport.ConnectionManager;
import io.ably.lib.transport.ITransport;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Param;
import io.ably.lib.types.ProtocolMessage;
import io.ably.lib.types.ProtocolSerializer;
import io.ably.lib.util.Log;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ServerHandshake;

public class WebSocketTransport
implements ITransport {
    private static final String TAG = WebSocketTransport.class.getName();
    private final ITransport.TransportParams params;
    private final ConnectionManager connectionManager;
    private final boolean channelBinaryMode;
    private String wsUri;
    private ITransport.ConnectListener connectListener;
    private WsClient wsConnection;
    private static final int NEVER_CONNECTED = -1;
    private static final int BUGGYCLOSE = -2;
    private static final int CLOSE_NORMAL = 1000;
    private static final int GOING_AWAY = 1001;
    private static final int CLOSE_PROTOCOL_ERROR = 1002;
    private static final int REFUSE = 1003;
    private static final int ABNORMAL_CLOSE = 1006;
    private static final int NO_UTF8 = 1007;
    private static final int POLICY_VALIDATION = 1008;
    private static final int TOOBIG = 1009;
    private static final int EXTENSION = 1010;
    private static final int UNEXPECTED_CONDITION = 1011;
    private static final int TLS_ERROR = 1015;

    protected WebSocketTransport(ITransport.TransportParams params, ConnectionManager connectionManager) {
        this.params = params;
        this.connectionManager = connectionManager;
        this.channelBinaryMode = params.options.useBinaryProtocol;
        params.heartbeats = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(ITransport.ConnectListener connectListener) {
        this.connectListener = connectListener;
        try {
            boolean isTls = this.params.options.tls;
            String wsScheme = isTls ? "wss://" : "ws://";
            this.wsUri = wsScheme + this.params.host + ':' + String.valueOf(this.params.port) + "/";
            Param[] authParams = this.connectionManager.ably.auth.getAuthParams();
            Param[] connectParams = this.params.getConnectParams(authParams);
            if (connectParams.length > 0) {
                this.wsUri = HttpUtils.encodeParams(this.wsUri, connectParams);
            }
            WebSocketTransport webSocketTransport = this;
            synchronized (webSocketTransport) {
                this.wsConnection = new WsClient(URI.create(this.wsUri));
                if (isTls) {
                    SSLContext sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(null, null, null);
                    SSLSocketFactory factory = sslContext.getSocketFactory();
                    this.wsConnection.setSocket(factory.createSocket());
                }
            }
            this.wsConnection.connect();
        }
        catch (AblyException e) {
            Log.e(TAG, "Unexpected exception attempting connection; wsUri = " + this.wsUri, e);
            connectListener.onTransportUnavailable(this, this.params, e.errorInfo);
        }
        catch (Throwable t) {
            Log.e(TAG, "Unexpected exception attempting connection; wsUri = " + this.wsUri, t);
            connectListener.onTransportUnavailable(this, this.params, AblyException.fromThrowable((Throwable)t).errorInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean sendClose) {
        WebSocketTransport webSocketTransport = this;
        synchronized (webSocketTransport) {
            if (this.wsConnection != null) {
                if (sendClose) {
                    try {
                        this.send(new ProtocolMessage(ProtocolMessage.Action.close));
                    }
                    catch (AblyException e) {
                        Log.e(TAG, "Unexpected exception sending close", e);
                    }
                }
                this.wsConnection.close();
                this.wsConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(ErrorInfo reason) {
        WebSocketTransport webSocketTransport = this;
        synchronized (webSocketTransport) {
            if (this.wsConnection != null) {
                this.wsConnection.close();
                this.wsConnection = null;
            }
        }
        this.connectionManager.notifyState(this, new ConnectionManager.StateIndication(ConnectionState.failed, reason));
    }

    @Override
    public void send(ProtocolMessage msg) throws AblyException {
        try {
            if (this.channelBinaryMode) {
                byte[] encodedMsg = ProtocolSerializer.writeMsgpack(msg);
                if (Log.level <= 2) {
                    ProtocolMessage decodedMsg = ProtocolSerializer.readMsgpack(encodedMsg);
                    Log.v(TAG, "send(): " + (Object)((Object)decodedMsg.action) + ": " + new String(ProtocolSerializer.writeJSON(decodedMsg)));
                }
                this.wsConnection.send(encodedMsg);
            } else {
                if (Log.level <= 2) {
                    Log.v(TAG, "send(): " + new String(ProtocolSerializer.writeJSON(msg)));
                }
                this.wsConnection.send(ProtocolSerializer.writeJSON(msg));
            }
        }
        catch (Exception e) {
            throw AblyException.fromThrowable(e);
        }
    }

    @Override
    public String getHost() {
        return this.params.host;
    }

    public String toString() {
        return WebSocketTransport.class.getName() + " [" + this.getURL() + "]";
    }

    @Override
    public String getURL() {
        return this.wsUri;
    }

    class WsClient
    extends WebSocketClient {
        private Timer timer;
        private long lastActivityTime;

        public WsClient(URI serverUri) {
            super(serverUri);
        }

        public void onOpen(ServerHandshake handshakedata) {
            if (WebSocketTransport.this.connectListener != null) {
                WebSocketTransport.this.connectListener.onTransportAvailable(WebSocketTransport.this, WebSocketTransport.this.params);
                WebSocketTransport.this.connectListener = null;
            }
            this.flagActivity();
        }

        public void onMessage(ByteBuffer blob) {
            try {
                WebSocketTransport.this.connectionManager.onMessage(WebSocketTransport.this, ProtocolSerializer.readMsgpack(blob.array()));
            }
            catch (AblyException e) {
                String msg = "Unexpected exception processing received binary message";
                Log.e(TAG, msg, e);
            }
            this.flagActivity();
        }

        public void onMessage(String string) {
            try {
                WebSocketTransport.this.connectionManager.onMessage(WebSocketTransport.this, ProtocolSerializer.fromJSON(string));
            }
            catch (AblyException e) {
                String msg = "Unexpected exception processing received text message";
                Log.e(TAG, msg, e);
            }
            this.flagActivity();
        }

        public void onWebsocketPing(WebSocket conn, Framedata f) {
            super.onWebsocketPing(conn, f);
            this.flagActivity();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClose(int wsCode, String wsReason, boolean remote) {
            ErrorInfo reason;
            ConnectionState newState;
            this.flagActivity();
            switch (wsCode) {
                case -1: {
                    newState = ConnectionState.disconnected;
                    reason = ConnectionManager.REASON_NEVER_CONNECTED;
                    break;
                }
                case -2: 
                case 1000: 
                case 1001: 
                case 1006: {
                    newState = ConnectionState.disconnected;
                    reason = ConnectionManager.REASON_DISCONNECTED;
                    break;
                }
                case 1003: 
                case 1008: {
                    newState = ConnectionState.failed;
                    reason = ConnectionManager.REASON_REFUSED;
                    break;
                }
                case 1009: {
                    newState = ConnectionState.failed;
                    reason = ConnectionManager.REASON_TOO_BIG;
                    break;
                }
                default: {
                    newState = ConnectionState.failed;
                    reason = ConnectionManager.REASON_FAILED;
                }
            }
            WebSocketTransport webSocketTransport = WebSocketTransport.this;
            synchronized (webSocketTransport) {
                WebSocketTransport.this.wsConnection = null;
            }
            WebSocketTransport.this.connectionManager.notifyState(WebSocketTransport.this, new ConnectionManager.StateIndication(newState, reason));
            this.dispose();
        }

        public void onError(Exception e) {
            String msg = "Unexpected exception in WsClient";
            Log.e(TAG, msg, e);
            if (WebSocketTransport.this.connectListener != null) {
                WebSocketTransport.this.connectListener.onTransportUnavailable(WebSocketTransport.this, WebSocketTransport.this.params, new ErrorInfo(e.getMessage(), 503, 80000));
                WebSocketTransport.this.connectListener = null;
            }
        }

        private void dispose() {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }

        private void flagActivity() {
            this.lastActivityTime = System.currentTimeMillis();
            WebSocketTransport.this.connectionManager.setLastActivity(this.lastActivityTime);
            if (this.timer == null && ((WebSocketTransport)WebSocketTransport.this).connectionManager.maxIdleInterval != 0L) {
                this.checkActivity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkActivity() {
            long next;
            long timeout = ((WebSocketTransport)WebSocketTransport.this).connectionManager.maxIdleInterval;
            if (timeout == 0L) {
                Log.v(TAG, "checkActivity: infinite timeout");
                this.timer = null;
                return;
            }
            long now = System.currentTimeMillis();
            if (now < (next = this.lastActivityTime + (timeout += ((WebSocketTransport)WebSocketTransport.this).connectionManager.ably.options.realtimeRequestTimeout))) {
                Log.v(TAG, "checkActivity: ok");
                if (this.timer == null) {
                    WsClient wsClient = this;
                    synchronized (wsClient) {
                        if (this.timer == null) {
                            try {
                                this.timer = new Timer();
                            }
                            catch (Throwable t) {
                                Log.e(TAG, "Unexpected exception creating activity timer", t);
                            }
                        }
                    }
                }
                if (this.timer != null) {
                    try {
                        this.timer.schedule((TimerTask)new WsClientTimerTask(this), next - now);
                    }
                    catch (IllegalStateException ise) {
                        Log.e(TAG, "Unexpected exception scheduling activity timer", ise);
                    }
                }
            } else {
                Log.e(TAG, "No activity for " + timeout + "ms, closing connection");
                this.closeConnection(1006, "timed out");
            }
        }

        class WsClientTimerTask
        extends TimerTask {
            private final WsClient client;

            public WsClientTimerTask(WsClient client) {
                this.client = client;
            }

            @Override
            public void run() {
                try {
                    this.client.checkActivity();
                }
                catch (Throwable t) {
                    Log.e(TAG, "Unexpected exception in activity timer handler", t);
                }
            }
        }
    }

    public static class Factory
    implements ITransport.Factory {
        @Override
        public WebSocketTransport getTransport(ITransport.TransportParams params, ConnectionManager connectionManager) {
            return new WebSocketTransport(params, connectionManager);
        }
    }
}

