/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.transport;

import io.ably.lib.types.ErrorInfo;
import java.util.HashSet;
import java.util.Set;

public abstract class NetworkConnectivity {
    protected Set<NetworkConnectivityListener> listeners = new HashSet<NetworkConnectivityListener>();

    public void addListener(NetworkConnectivityListener listener) {
        boolean wasEmpty = this.listeners.isEmpty();
        this.listeners.add(listener);
        if (wasEmpty) {
            this.onNonempty();
        }
    }

    public void removeListener(NetworkConnectivityListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.onEmpty();
        }
    }

    protected void notifyNetworkAvailable() {
        for (NetworkConnectivityListener listener : this.listeners) {
            listener.onNetworkAvailable();
        }
    }

    protected void notifyNetworkUnavailable(ErrorInfo reason) {
        for (NetworkConnectivityListener listener : this.listeners) {
            listener.onNetworkUnavailable(reason);
        }
    }

    protected boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    protected void onEmpty() {
    }

    protected void onNonempty() {
    }

    public static class DelegatedNetworkConnectivity
    extends NetworkConnectivity
    implements NetworkConnectivityListener {
        @Override
        public void onNetworkAvailable() {
            this.notifyNetworkAvailable();
        }

        @Override
        public void onNetworkUnavailable(ErrorInfo reason) {
            this.notifyNetworkUnavailable(reason);
        }
    }

    public static class DefaultNetworkConnectivity
    extends NetworkConnectivity {
    }

    public static interface NetworkConnectivityListener {
        public void onNetworkAvailable();

        public void onNetworkUnavailable(ErrorInfo var1);
    }
}

