/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.realtime;

import io.ably.lib.http.BasePaginatedQuery;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.realtime.AblyRealtime;
import io.ably.lib.realtime.ChannelEvent;
import io.ably.lib.realtime.ChannelState;
import io.ably.lib.realtime.ChannelStateListener;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.realtime.ConnectionState;
import io.ably.lib.realtime.Presence;
import io.ably.lib.transport.ConnectionManager;
import io.ably.lib.transport.Defaults;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.ChannelProperties;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageDecodeException;
import io.ably.lib.types.MessageSerializer;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.types.PresenceMessage;
import io.ably.lib.types.ProtocolMessage;
import io.ably.lib.util.EventEmitter;
import io.ably.lib.util.Log;
import io.ably.lib.util.Multicaster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class Channel
extends EventEmitter<ChannelEvent, ChannelStateListener> {
    public final String name;
    public final Presence presence;
    public ChannelState state;
    public ErrorInfo reason;
    public ChannelProperties properties = new ChannelProperties();
    private Timer attachTimer;
    private Timer reattachTimer;
    static ErrorInfo REASON_NOT_ATTACHED = new ErrorInfo("Channel not attached", 400, 90001);
    private MessageMulticaster listeners = new MessageMulticaster();
    private HashMap<String, MessageMulticaster> eventListeners = new HashMap();
    private static final String KEY_UNTIL_ATTACH = "untilAttach";
    private static final String KEY_FROM_SERIAL = "fromSerial";
    private List<ConnectionManager.QueuedMessage> queuedMessages;
    private static final String TAG = Channel.class.getName();
    final AblyRealtime ably;
    final String basePath;
    ChannelOptions options;
    String syncChannelSerial;

    private void setState(ChannelState newState, ErrorInfo reason) {
        this.setState(newState, reason, false, true);
    }

    private void setState(ChannelState newState, ErrorInfo reason, boolean resumed) {
        this.setState(newState, reason, resumed, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ChannelState newState, ErrorInfo reason, boolean resumed, boolean notifyStateChange) {
        ChannelStateListener.ChannelStateChange stateChange;
        Log.v(TAG, "setState(): channel = " + this.name + "; setting " + (Object)((Object)newState));
        Channel channel = this;
        synchronized (channel) {
            stateChange = new ChannelStateListener.ChannelStateChange(newState, this.state, reason, resumed);
            this.state = stateChange.current;
            this.reason = stateChange.reason;
        }
        if (notifyStateChange) {
            this.emit(newState, stateChange);
        }
    }

    public void attach() throws AblyException {
        this.attach(null);
    }

    public void attach(CompletionListener listener) throws AblyException {
        this.clearAttachTimers();
        this.attachWithTimeout(listener);
    }

    private void attachImpl(CompletionListener listener) throws AblyException {
        Log.v(TAG, "attach(); channel = " + this.name);
        switch (this.state) {
            case attaching: {
                if (listener != null) {
                    this.on(new ChannelStateCompletionListener(listener, ChannelState.attached, ChannelState.failed));
                }
                return;
            }
            case attached: {
                if (listener != null) {
                    listener.onSuccess();
                }
                return;
            }
        }
        ConnectionManager connectionManager = this.ably.connection.connectionManager;
        if (!connectionManager.isActive()) {
            throw AblyException.fromErrorInfo(connectionManager.getStateErrorInfo());
        }
        Log.v(TAG, "attach(); channel = " + this.name + "; sending ATTACH request");
        ProtocolMessage attachMessage = new ProtocolMessage(ProtocolMessage.Action.attach, this.name);
        if (listener != null) {
            this.on(new ChannelStateCompletionListener(listener, ChannelState.attached, ChannelState.failed));
        }
        this.setState(ChannelState.attaching, null);
        connectionManager.send(attachMessage, true, null);
    }

    public void detach() throws AblyException {
        this.detach(null);
    }

    public void detach(CompletionListener listener) throws AblyException {
        this.clearAttachTimers();
        this.detachWithTimeout(listener);
    }

    private void detachImpl(CompletionListener listener) throws AblyException {
        Log.v(TAG, "detach(); channel = " + this.name);
        switch (this.state) {
            case initialized: 
            case detached: {
                if (listener != null) {
                    listener.onSuccess();
                }
                return;
            }
            case detaching: {
                if (listener != null) {
                    this.on(new ChannelStateCompletionListener(listener, ChannelState.detached, ChannelState.failed));
                }
                return;
            }
        }
        ConnectionManager connectionManager = this.ably.connection.connectionManager;
        if (!connectionManager.isActive()) {
            throw AblyException.fromErrorInfo(connectionManager.getStateErrorInfo());
        }
        ProtocolMessage detachMessage = new ProtocolMessage(ProtocolMessage.Action.detach, this.name);
        if (listener != null) {
            this.on(new ChannelStateCompletionListener(listener, ChannelState.detached, ChannelState.failed));
        }
        this.setState(ChannelState.detaching, null);
        connectionManager.send(detachMessage, true, null);
    }

    public void sync() throws AblyException {
        Log.v(TAG, "sync(); channel = " + this.name);
        switch (this.state) {
            case initialized: 
            case detached: 
            case detaching: {
                throw AblyException.fromErrorInfo(new ErrorInfo("Unable to sync to channel; not attached", 40000));
            }
        }
        ConnectionManager connectionManager = this.ably.connection.connectionManager;
        if (!connectionManager.isActive()) {
            throw AblyException.fromErrorInfo(connectionManager.getStateErrorInfo());
        }
        ProtocolMessage syncMessage = new ProtocolMessage(ProtocolMessage.Action.sync, this.name);
        syncMessage.channelSerial = this.syncChannelSerial;
        connectionManager.send(syncMessage, true, null);
    }

    private void setAttached(ProtocolMessage message) {
        this.clearAttachTimers();
        boolean resumed = (message.flags & 1 << ProtocolMessage.Flag.resumed.ordinal()) != 0;
        Log.v(TAG, "setAttached(); channel = " + this.name + ", resumed = " + resumed);
        this.properties.attachSerial = message.channelSerial;
        if (this.state == ChannelState.attached) {
            Log.v(TAG, String.format("Server initiated attach for channel %s", this.name));
            this.emitUpdate(null, resumed);
        } else {
            this.setState(ChannelState.attached, message.error, resumed);
            this.sendQueuedMessages();
            this.presence.setAttached((message.flags & 1 << ProtocolMessage.Flag.has_presence.ordinal()) > 0);
        }
    }

    private void setDetached(ErrorInfo reason) {
        this.clearAttachTimers();
        Log.v(TAG, "setDetached(); channel = " + this.name);
        this.presence.setDetached(reason);
        this.setState(ChannelState.detached, reason);
        this.failQueuedMessages(reason);
    }

    private void setFailed(ErrorInfo reason) {
        this.clearAttachTimers();
        Log.v(TAG, "setFailed(); channel = " + this.name);
        this.presence.setDetached(reason);
        this.setState(ChannelState.failed, reason);
        this.failQueuedMessages(reason);
    }

    private synchronized void clearAttachTimers() {
        Timer[] timers = new Timer[]{this.attachTimer, this.reattachTimer};
        this.reattachTimer = null;
        this.attachTimer = null;
        for (Timer t : timers) {
            if (t == null) continue;
            t.cancel();
            t.purge();
        }
    }

    private synchronized void attachWithTimeout(final CompletionListener listener) throws AblyException {
        Timer currentAttachTimer;
        this.attachTimer = currentAttachTimer = new Timer();
        try {
            this.attachImpl(new CompletionListener(){

                @Override
                public void onSuccess() {
                    Channel.this.clearAttachTimers();
                    if (listener != null) {
                        listener.onSuccess();
                    }
                }

                @Override
                public void onError(ErrorInfo reason) {
                    Channel.this.clearAttachTimers();
                    if (listener != null) {
                        listener.onError(reason);
                    }
                }
            });
        }
        catch (AblyException e) {
            this.attachTimer = null;
        }
        if (this.attachTimer == null) {
            return;
        }
        this.attachTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String errorMessage = String.format("Attach timed out for channel %s", Channel.this.name);
                Log.v(TAG, errorMessage);
                Channel channel = Channel.this;
                synchronized (channel) {
                    if (Channel.this.attachTimer != currentAttachTimer) {
                        return;
                    }
                    Channel.this.attachTimer = null;
                    if (Channel.this.state == ChannelState.attaching) {
                        Channel.this.setSuspended(new ErrorInfo(errorMessage, 91200), true);
                        Channel.this.reattachAfterTimeout();
                    }
                }
            }
        }, Defaults.realtimeRequestTimeout);
    }

    private synchronized void reattachAfterTimeout() {
        Timer currentReattachTimer;
        this.reattachTimer = currentReattachTimer = new Timer();
        this.reattachTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Channel channel = Channel.this;
                synchronized (channel) {
                    if (currentReattachTimer != Channel.this.reattachTimer) {
                        return;
                    }
                    Channel.this.reattachTimer = null;
                    if (Channel.this.state == ChannelState.suspended) {
                        try {
                            Channel.this.attachWithTimeout(null);
                        }
                        catch (AblyException e) {
                            Log.e(TAG, "Reattach channel failed; channel = " + Channel.this.name, e);
                        }
                    }
                }
            }
        }, this.ably.options.channelRetryTimeout);
    }

    private synchronized void detachWithTimeout(final CompletionListener listener) throws AblyException {
        Timer currentDetachTimer;
        final ChannelState originalState = this.state;
        this.attachTimer = currentDetachTimer = new Timer();
        try {
            this.detachImpl(new CompletionListener(){

                @Override
                public void onSuccess() {
                    Channel.this.clearAttachTimers();
                    if (listener != null) {
                        listener.onSuccess();
                    }
                }

                @Override
                public void onError(ErrorInfo reason) {
                    Channel.this.clearAttachTimers();
                    if (listener != null) {
                        listener.onError(reason);
                    }
                }
            });
        }
        catch (AblyException e) {
            this.attachTimer = null;
        }
        if (this.attachTimer == null) {
            return;
        }
        this.attachTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Channel channel = Channel.this;
                synchronized (channel) {
                    if (currentDetachTimer != Channel.this.attachTimer) {
                        return;
                    }
                    Channel.this.attachTimer = null;
                    if (Channel.this.state == ChannelState.detaching) {
                        ErrorInfo reason = new ErrorInfo("Detach operation timed out", 90007);
                        if (listener != null) {
                            listener.onError(reason);
                        }
                        Channel.this.setState(originalState, reason);
                    }
                }
            }
        }, Defaults.realtimeRequestTimeout);
    }

    public void setConnected() {
        if (this.state == ChannelState.attached) {
            try {
                this.sync();
            }
            catch (AblyException e) {
                Log.e(TAG, "setConnected(): Unable to sync; channel = " + this.name, e);
            }
        } else if (this.state == ChannelState.suspended) {
            try {
                this.attachWithTimeout(null);
            }
            catch (AblyException e) {
                Log.e(TAG, "setConnected(): Unable to initiate attach; channel = " + this.name, e);
            }
        }
    }

    public void setConnectionFailed(ErrorInfo reason) {
        this.clearAttachTimers();
        if (this.state == ChannelState.attached || this.state == ChannelState.attaching) {
            this.setFailed(reason);
        }
    }

    public void setConnectionClosed(ErrorInfo reason) {
        this.clearAttachTimers();
        if (this.state == ChannelState.attached || this.state == ChannelState.attaching) {
            this.setDetached(reason);
        }
    }

    public synchronized void setSuspended(ErrorInfo reason, boolean notifyStateChange) {
        this.clearAttachTimers();
        if (this.state == ChannelState.attached || this.state == ChannelState.attaching) {
            Log.v(TAG, "setSuspended(); channel = " + this.name);
            this.presence.setSuspended(reason);
            this.setState(ChannelState.suspended, reason, false, notifyStateChange);
            this.failQueuedMessages(reason);
        }
    }

    @Override
    protected void apply(ChannelStateListener listener, ChannelEvent event, Object ... args) {
        listener.onChannelStateChanged((ChannelStateListener.ChannelStateChange)args[0]);
    }

    public synchronized void unsubscribe() {
        Log.v(TAG, "unsubscribe(); channel = " + this.name);
        this.listeners.clear();
        this.eventListeners.clear();
    }

    public synchronized void subscribe(MessageListener listener) throws AblyException {
        Log.v(TAG, "subscribe(); channel = " + this.name);
        this.listeners.add(listener);
        this.attach();
    }

    public synchronized void unsubscribe(MessageListener listener) {
        Log.v(TAG, "unsubscribe(); channel = " + this.name);
        this.listeners.remove(listener);
        for (MessageMulticaster multicaster : this.eventListeners.values()) {
            multicaster.remove(listener);
        }
    }

    public synchronized void subscribe(String name, MessageListener listener) throws AblyException {
        Log.v(TAG, "subscribe(); channel = " + this.name + "; event = " + name);
        this.subscribeImpl(name, listener);
        this.attach();
    }

    public synchronized void unsubscribe(String name, MessageListener listener) {
        Log.v(TAG, "unsubscribe(); channel = " + this.name + "; event = " + name);
        this.unsubscribeImpl(name, listener);
    }

    public synchronized void subscribe(String[] names, MessageListener listener) throws AblyException {
        Log.v(TAG, "subscribe(); channel = " + this.name + "; (multiple events)");
        for (String name : names) {
            this.subscribeImpl(name, listener);
        }
        this.attach();
    }

    public synchronized void unsubscribe(String[] names, MessageListener listener) {
        Log.v(TAG, "unsubscribe(); channel = " + this.name + "; (multiple events)");
        for (String name : names) {
            this.unsubscribeImpl(name, listener);
        }
    }

    private void onMessage(ProtocolMessage message) {
        Log.v(TAG, "onMessage(); channel = " + this.name);
        Message[] messages = message.messages;
        for (int i = 0; i < messages.length; ++i) {
            MessageMulticaster listeners;
            Message msg = messages[i];
            try {
                msg.decode(this.options);
            }
            catch (MessageDecodeException e) {
                Log.e(TAG, String.format("%s on channel %s", e.errorInfo.message, this.name));
            }
            if (msg.connectionId == null) {
                msg.connectionId = message.connectionId;
            }
            if (msg.timestamp == 0L) {
                msg.timestamp = message.timestamp;
            }
            if (msg.id == null) {
                msg.id = message.id + ':' + i;
            }
            if ((listeners = this.eventListeners.get(msg.name)) == null) continue;
            listeners.onMessage(msg);
        }
        for (Message msg : message.messages) {
            this.listeners.onMessage(msg);
        }
    }

    private void onPresence(ProtocolMessage message, String syncChannelSerial) {
        Log.v(TAG, "onPresence(); channel = " + this.name + "; syncChannelSerial = " + syncChannelSerial);
        PresenceMessage[] messages = message.presence;
        for (int i = 0; i < messages.length; ++i) {
            PresenceMessage msg = messages[i];
            try {
                msg.decode(this.options);
            }
            catch (MessageDecodeException e) {
                Log.e(TAG, String.format("%s on channel %s", e.errorInfo.message, this.name));
            }
            if (msg.connectionId == null) {
                msg.connectionId = message.connectionId;
            }
            if (msg.timestamp == 0L) {
                msg.timestamp = message.timestamp;
            }
            if (msg.id != null) continue;
            msg.id = message.id + ':' + i;
        }
        this.presence.setPresence(messages, true, syncChannelSerial);
    }

    private void onSync(ProtocolMessage message) {
        Log.v(TAG, "onSync(); channel = " + this.name);
        if (message.presence != null) {
            this.syncChannelSerial = message.channelSerial;
            this.onPresence(message, this.syncChannelSerial);
        }
    }

    private void subscribeImpl(String name, MessageListener listener) throws AblyException {
        MessageMulticaster listeners = this.eventListeners.get(name);
        if (listeners == null) {
            listeners = new MessageMulticaster();
            this.eventListeners.put(name, listeners);
        }
        listeners.add(listener);
    }

    private void unsubscribeImpl(String name, MessageListener listener) {
        MessageMulticaster listeners = this.eventListeners.get(name);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.eventListeners.remove(name);
            }
        }
    }

    public void publish(String name, Object data) throws AblyException {
        this.publish(name, data, null);
    }

    public void publish(Message message) throws AblyException {
        this.publish(message, null);
    }

    public void publish(Message[] messages) throws AblyException {
        this.publish(messages, null);
    }

    public void publish(String name, Object data, CompletionListener listener) throws AblyException {
        Log.v(TAG, "publish(String, Object); channel = " + this.name + "; event = " + name);
        this.publish(new Message[]{new Message(name, data)}, listener);
    }

    public void publish(Message message, CompletionListener listener) throws AblyException {
        Log.v(TAG, "publish(Message); channel = " + this.name + "; event = " + message.name);
        this.publish(new Message[]{message}, listener);
    }

    public synchronized void publish(Message[] messages, CompletionListener listener) throws AblyException {
        Log.v(TAG, "publish(Message[]); channel = " + this.name);
        boolean connected = this.ably.connection.state == ConnectionState.connected;
        try {
            for (Message message : messages) {
                this.ably.auth.checkClientId(message, true, connected);
                message.encode(this.options);
            }
        }
        catch (AblyException e) {
            if (listener != null) {
                listener.onError(e.errorInfo);
            }
            return;
        }
        ProtocolMessage msg = new ProtocolMessage(ProtocolMessage.Action.message, this.name);
        msg.messages = messages;
        switch (this.state) {
            case initialized: {
                this.attach();
            }
            case attaching: {
                this.queuedMessages.add(new ConnectionManager.QueuedMessage(msg, listener));
                break;
            }
            case detached: 
            case detaching: 
            case failed: 
            case suspended: {
                throw AblyException.fromErrorInfo(new ErrorInfo("Unable to publish in detached, failed or suspended state", 400, 40000));
            }
            case attached: {
                ConnectionManager connectionManager = this.ably.connection.connectionManager;
                connectionManager.send(msg, this.ably.options.queueMessages, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQueuedMessages() {
        Log.v(TAG, "sendQueuedMessages()");
        ArrayList<FailedMessage> failedMessages = new ArrayList<FailedMessage>();
        Channel channel = this;
        synchronized (channel) {
            boolean queueMessages = this.ably.options.queueMessages;
            ConnectionManager connectionManager = this.ably.connection.connectionManager;
            for (ConnectionManager.QueuedMessage msg : this.queuedMessages) {
                try {
                    connectionManager.send(msg.msg, queueMessages, msg.listener);
                }
                catch (AblyException e) {
                    Log.e(TAG, "sendQueuedMessages(): Unexpected exception sending message", e);
                    if (msg.listener == null) continue;
                    failedMessages.add(new FailedMessage(msg, e.errorInfo));
                }
            }
            this.queuedMessages.clear();
        }
        for (FailedMessage failed : failedMessages) {
            failed.msg.listener.onError(failed.reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failQueuedMessages(ErrorInfo reason) {
        Log.v(TAG, "failQueuedMessages()");
        ArrayList<FailedMessage> failedMessages = new ArrayList<FailedMessage>();
        Channel channel = this;
        synchronized (channel) {
            for (ConnectionManager.QueuedMessage msg : this.queuedMessages) {
                if (msg.listener == null) continue;
                failedMessages.add(new FailedMessage(msg, reason));
            }
            this.queuedMessages.clear();
        }
        for (FailedMessage failed : failedMessages) {
            try {
                failed.msg.listener.onError(failed.reason);
            }
            catch (Throwable t) {
                Log.e(TAG, "failQueuedMessages(): Unexpected exception calling listener", t);
            }
        }
    }

    static Param[] replacePlaceholderParams(Channel channel, Param[] placeholderParams) throws AblyException {
        if (placeholderParams == null) {
            return null;
        }
        HashSet<Param> params = new HashSet<Param>();
        for (int i = 0; i < placeholderParams.length; ++i) {
            Param param = placeholderParams[i];
            if (KEY_UNTIL_ATTACH.equals(param.key)) {
                if ("true".equalsIgnoreCase(param.value)) {
                    if (channel.state != ChannelState.attached) {
                        throw AblyException.fromErrorInfo(new ErrorInfo("option untilAttach requires the channel to be attached", 40000, 400));
                    }
                    params.add(new Param(KEY_FROM_SERIAL, channel.properties.attachSerial));
                    continue;
                }
                if ("false".equalsIgnoreCase(param.value)) continue;
                throw AblyException.fromErrorInfo(new ErrorInfo("option untilAttach is invalid. \"true\" or \"false\" expected", 40000, 400));
            }
            params.add(param);
        }
        return params.toArray(new Param[params.size()]);
    }

    public PaginatedResult<Message> history(Param[] params) throws AblyException {
        return this.historyImpl(params).sync();
    }

    public void historyAsync(Param[] params, Callback<AsyncPaginatedResult<Message>> callback) {
        this.historyImpl(params).async(callback);
    }

    private BasePaginatedQuery.ResultRequest<Message> historyImpl(Param[] params) {
        try {
            params = Channel.replacePlaceholderParams(this, params);
        }
        catch (AblyException e) {
            return new BasePaginatedQuery.ResultRequest.Failed<Message>(e);
        }
        HttpCore.BodyHandler<Message> bodyHandler = MessageSerializer.getMessageResponseHandler(this.options);
        return new BasePaginatedQuery<Message>(this.ably.http, this.basePath + "/history", HttpUtils.defaultAcceptHeaders(this.ably.options.useBinaryProtocol), params, bodyHandler).get();
    }

    public void setOptions(ChannelOptions options) throws AblyException {
        this.options = options;
    }

    Channel(AblyRealtime ably, String name) {
        Log.v(TAG, "RealtimeChannel(); channel = " + name);
        this.ably = ably;
        this.name = name;
        this.basePath = "/channels/" + HttpUtils.encodeURIComponent(name);
        this.presence = new Presence(this);
        this.state = ChannelState.initialized;
        this.queuedMessages = new ArrayList<ConnectionManager.QueuedMessage>();
    }

    void onChannelMessage(ProtocolMessage msg) {
        block1 : switch (msg.action) {
            case attached: {
                this.setAttached(msg);
                break;
            }
            case detach: 
            case detached: {
                ChannelState oldState = this.state;
                switch (oldState) {
                    case attached: {
                        this.setDetached(msg.error != null ? msg.error : REASON_NOT_ATTACHED);
                        Log.v(TAG, String.format("Server initiated detach for channel %s; attempting reattach", this.name));
                        try {
                            this.attachWithTimeout(null);
                        }
                        catch (AblyException e) {
                            Log.e(TAG, "Attempting reattach threw exception", e);
                            this.setDetached(e.errorInfo);
                        }
                        break block1;
                    }
                    case attaching: {
                        Log.v(TAG, String.format("Server initiated detach for channel %s whilst attaching; moving to suspended", this.name));
                        this.setSuspended(msg.error, true);
                        this.reattachAfterTimeout();
                        break block1;
                    }
                    case detaching: {
                        this.setDetached(msg.error != null ? msg.error : REASON_NOT_ATTACHED);
                        break block1;
                    }
                }
                break;
            }
            case message: {
                this.onMessage(msg);
                break;
            }
            case presence: {
                this.onPresence(msg, null);
                break;
            }
            case sync: {
                this.onSync(msg);
                break;
            }
            case error: {
                this.setFailed(msg.error);
                break;
            }
            default: {
                Log.e(TAG, "onChannelMessage(): Unexpected message action (" + (Object)((Object)msg.action) + ")");
            }
        }
    }

    void emitUpdate(ErrorInfo errorInfo, boolean resumed) {
        if (this.state == ChannelState.attached) {
            this.emit(ChannelEvent.update, ChannelStateListener.ChannelStateChange.createUpdateEvent(errorInfo, resumed));
        }
    }

    public void emit(ChannelState state, ChannelStateListener.ChannelStateChange channelStateChange) {
        super.emit(state.getChannelEvent(), channelStateChange);
    }

    @Override
    public void on(ChannelState state, ChannelStateListener listener) {
        super.on(state.getChannelEvent(), listener);
    }

    @Override
    public void once(ChannelState state, ChannelStateListener listener) {
        super.once(state.getChannelEvent(), listener);
    }

    private class ChannelStateCompletionListener
    implements ChannelStateListener {
        private CompletionListener completionListener;
        private final ChannelState successState;
        private final ChannelState failureState;

        public ChannelStateCompletionListener(CompletionListener completionListener, ChannelState successState, ChannelState failureState) {
            this.completionListener = completionListener;
            this.successState = successState;
            this.failureState = failureState;
        }

        @Override
        public void onChannelStateChanged(ChannelStateListener.ChannelStateChange stateChange) {
            if (stateChange.current.equals((Object)this.successState)) {
                Channel.this.off(this);
                this.completionListener.onSuccess();
            } else if (stateChange.current.equals((Object)this.failureState)) {
                Channel.this.off(this);
                this.completionListener.onError(Channel.this.reason);
            }
        }
    }

    private static class FailedMessage {
        ConnectionManager.QueuedMessage msg;
        ErrorInfo reason;

        FailedMessage(ConnectionManager.QueuedMessage msg, ErrorInfo reason) {
            this.msg = msg;
            this.reason = reason;
        }
    }

    private static class MessageMulticaster
    extends Multicaster<MessageListener>
    implements MessageListener {
        private MessageMulticaster() {
            super(new MessageListener[0]);
        }

        @Override
        public void onMessage(Message message) {
            for (MessageListener member : this.members) {
                try {
                    member.onMessage(message);
                }
                catch (Throwable t) {
                    Log.e(TAG, "Unexpected exception calling listener", t);
                }
            }
        }
    }

    public static interface MessageListener {
        public void onMessage(Message var1);
    }
}

