/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.realtime;

import io.ably.lib.realtime.Channel;
import io.ably.lib.realtime.Connection;
import io.ably.lib.realtime.ConnectionEvent;
import io.ably.lib.realtime.ConnectionStateListener;
import io.ably.lib.rest.AblyRest;
import io.ably.lib.transport.ITransport;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.ProtocolMessage;
import io.ably.lib.util.Log;
import java.util.HashMap;
import java.util.Map;

public class AblyRealtime
extends AblyRest {
    public final Connection connection = new Connection(this);
    public Channels channels = new Channels();
    private static final String TAG = AblyRealtime.class.getName();

    public AblyRealtime(String key) throws AblyException {
        this(new ClientOptions(key));
    }

    public AblyRealtime(ClientOptions options) throws AblyException {
        super(options);
        if (options.autoConnect) {
            this.connection.connect();
        }
    }

    public void connect() {
        this.connection.connect();
    }

    public void close() {
        this.connection.close();
    }

    @Override
    protected void onAuthUpdated(String token, boolean waitForResponse) throws AblyException {
        this.connection.connectionManager.onAuthUpdated(token, waitForResponse);
    }

    @Override
    protected void onAuthError(ErrorInfo errorInfo) {
        this.connection.connectionManager.onAuthError(errorInfo);
    }

    public class Channels
    extends HashMap<String, Channel> {
        public Channels() {
            AblyRealtime.this.connection.on(ConnectionEvent.closed, new ConnectionStateListener(){

                @Override
                public void onConnectionStateChanged(ConnectionStateListener.ConnectionStateChange state) {
                    Channels.this.clear();
                }
            });
        }

        public Channel get(String channelName) {
            Channel channel = (Channel)super.get(channelName);
            if (channel == null) {
                channel = new Channel(AblyRealtime.this, channelName);
                this.put(channelName, channel);
            }
            return channel;
        }

        public Channel get(String channelName, ChannelOptions channelOptions) throws AblyException {
            Channel channel = this.get(channelName);
            channel.setOptions(channelOptions);
            return channel;
        }

        public void release(String channelName) {
            Channel channel = (Channel)this.remove(channelName);
            if (channel != null) {
                try {
                    channel.detach();
                }
                catch (AblyException e) {
                    Log.e(TAG, "Unexpected exception detaching channel; channelName = " + channelName, e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChannelMessage(ITransport transport, ProtocolMessage msg) {
            Channel channel;
            String channelName = msg.channel;
            Channels channels = this;
            synchronized (channels) {
                channel = AblyRealtime.this.channels.get(channelName);
            }
            if (channel == null) {
                Log.e(TAG, "Received channel message for non-existent channel");
                return;
            }
            channel.onChannelMessage(msg);
        }

        public void suspendAll(ErrorInfo error, boolean notifyStateChange) {
            for (Map.Entry entry : this.entrySet()) {
                ((Channel)entry.getValue()).setSuspended(error, notifyStateChange);
            }
        }
    }
}

