/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.http;

import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Param;
import io.ably.lib.util.Log;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class HttpScheduler<Executor extends Executor> {
    protected final Executor executor;
    private final HttpCore httpCore;
    protected static final String TAG = HttpScheduler.class.getName();

    public <T> Future<T> get(String path, Param[] headers, Param[] params, HttpCore.ResponseHandler<T> responseHandler, boolean requireAblyAuth, Callback<T> callback) {
        return this.ablyHttpExecuteWithFallback(path, "GET", headers, params, null, responseHandler, requireAblyAuth, callback);
    }

    public <T> Future<T> put(String path, Param[] headers, Param[] params, HttpCore.RequestBody requestBody, HttpCore.ResponseHandler<T> responseHandler, boolean requireAblyAuth, Callback<T> callback) {
        return this.ablyHttpExecuteWithFallback(path, "PUT", headers, params, requestBody, responseHandler, requireAblyAuth, callback);
    }

    public <T> Future<T> patch(String path, Param[] headers, Param[] params, HttpCore.RequestBody requestBody, HttpCore.ResponseHandler<T> responseHandler, boolean requireAblyAuth, Callback<T> callback) {
        return this.ablyHttpExecuteWithFallback(path, "PATCH", headers, params, requestBody, responseHandler, requireAblyAuth, callback);
    }

    public <T> Future<T> post(String path, Param[] headers, Param[] params, HttpCore.RequestBody requestBody, HttpCore.ResponseHandler<T> responseHandler, boolean requireAblyAuth, Callback<T> callback) {
        return this.ablyHttpExecuteWithFallback(path, "POST", headers, params, requestBody, responseHandler, requireAblyAuth, callback);
    }

    public <T> Future<T> del(String path, Param[] headers, Param[] params, HttpCore.ResponseHandler<T> responseHandler, boolean requireAblyAuth, Callback<T> callback) {
        return this.ablyHttpExecuteWithFallback(path, "DELETE", headers, params, null, responseHandler, requireAblyAuth, callback);
    }

    public <T> Future<T> exec(String path, String method, Param[] headers, Param[] params, HttpCore.RequestBody requestBody, HttpCore.ResponseHandler<T> responseHandler, boolean requireAblyAuth, Callback<T> callback) {
        return this.ablyHttpExecuteWithFallback(path, method, headers, params, requestBody, responseHandler, requireAblyAuth, callback);
    }

    protected HttpScheduler(HttpCore httpCore, Executor executor) {
        this.httpCore = httpCore;
        this.executor = executor;
    }

    public <T> Future<T> httpExecute(URL url, String method, Param[] headers, HttpCore.RequestBody requestBody, boolean withCredentials, HttpCore.ResponseHandler<T> responseHandler, Callback<T> callback) {
        UrlRequest request = new UrlRequest(url, method, headers, null, requestBody, withCredentials, responseHandler, callback);
        this.executor.execute(request);
        return request;
    }

    public <T> Future<T> ablyHttpExecuteWithFallback(String path, String method, Param[] headers, Param[] params, HttpCore.RequestBody requestBody, HttpCore.ResponseHandler<T> responseHandler, boolean requireAblyAuth, Callback<T> callback) {
        AblyRequestWithFallback request = new AblyRequestWithFallback(path, method, headers, params, requestBody, responseHandler, requireAblyAuth, callback);
        this.executor.execute(request);
        return request;
    }

    public <T> Future<T> ablyHttpExecuteWithRetry(String host, String path, String method, Param[] headers, Param[] params, HttpCore.RequestBody requestBody, HttpCore.ResponseHandler<T> responseHandler, boolean requireAblyAuth, Callback<T> callback) {
        AblyRequestWithRetry request = new AblyRequestWithRetry(host, path, method, headers, params, requestBody, responseHandler, requireAblyAuth, callback);
        this.executor.execute(request);
        return request;
    }

    private abstract class AsyncRequest<T>
    implements Future<T> {
        protected HttpURLConnection conn;
        protected T result;
        protected ErrorInfo err;
        protected final String method;
        protected final Param[] headers;
        protected final Param[] params;
        protected final HttpCore.RequestBody requestBody;
        protected final HttpCore.ResponseHandler<T> responseHandler;
        protected final Callback<T> callback;
        protected boolean isCancelled = false;
        protected boolean isDone = false;

        private AsyncRequest(String method, Param[] headers, Param[] params, HttpCore.RequestBody requestBody, boolean withCredentials, HttpCore.ResponseHandler<T> responseHandler, Callback<T> callback) {
            this.method = method;
            this.headers = headers;
            this.params = params;
            this.requestBody = requestBody;
            this.responseHandler = responseHandler;
            this.callback = callback;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.isCancelled = true;
            return this.disposeConnection();
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled;
        }

        @Override
        public boolean isDone() {
            return this.isDone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() throws InterruptedException, ExecutionException {
            AsyncRequest asyncRequest = this;
            synchronized (asyncRequest) {
                while (!this.isDone) {
                    this.wait();
                }
                if (this.err != null) {
                    throw new ExecutionException(AblyException.fromErrorInfo(this.err));
                }
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long remaining = unit.toMillis(timeout);
            long deadline = System.currentTimeMillis() + remaining;
            AsyncRequest asyncRequest = this;
            synchronized (asyncRequest) {
                while (remaining > 0L) {
                    this.wait(remaining);
                    if (this.isDone) break;
                    remaining = deadline - System.currentTimeMillis();
                }
                if (!this.isDone) {
                    throw new TimeoutException();
                }
                if (this.err != null) {
                    throw new ExecutionException(AblyException.fromErrorInfo(this.err));
                }
            }
            return this.result;
        }

        protected T httpExecuteWithRetry(URL url) throws AblyException {
            return HttpScheduler.this.httpCore.httpExecuteWithRetry(url, this.method, this.headers, this.requestBody, this.responseHandler, false);
        }

        protected T httpExecuteWithRetry(String host, String path, boolean requireAblyAuth) throws AblyException {
            URL url = HttpUtils.buildURL(((HttpScheduler)HttpScheduler.this).httpCore.scheme, host, ((HttpScheduler)HttpScheduler.this).httpCore.port, path, this.params);
            return HttpScheduler.this.httpCore.httpExecuteWithRetry(url, this.method, this.headers, this.requestBody, this.responseHandler, requireAblyAuth);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setResult(T result) {
            AsyncRequest asyncRequest = this;
            synchronized (asyncRequest) {
                this.result = result;
                this.isDone = true;
                this.notifyAll();
            }
            if (this.callback != null) {
                this.callback.onSuccess(result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setError(ErrorInfo err) {
            AsyncRequest asyncRequest = this;
            synchronized (asyncRequest) {
                this.err = err;
                this.isDone = true;
                this.notifyAll();
            }
            if (this.callback != null) {
                this.callback.onError(err);
            }
        }

        protected synchronized boolean disposeConnection() {
            boolean hasConnection;
            boolean bl = hasConnection = this.conn != null;
            if (hasConnection) {
                this.conn.disconnect();
                this.conn = null;
            }
            return hasConnection;
        }
    }

    private class AblyRequestWithFallback<T>
    extends AsyncRequest<T>
    implements Runnable {
        private final String path;
        private final boolean requireAblyAuth;

        private AblyRequestWithFallback(String path, String method, Param[] headers, Param[] params, HttpCore.RequestBody requestBody, HttpCore.ResponseHandler<T> responseHandler, boolean requireAblyAuth, Callback<T> callback) {
            super(method, headers, params, requestBody, true, responseHandler, callback);
            this.path = path;
            this.requireAblyAuth = requireAblyAuth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int retryCountRemaining;
            String candidateHost = HttpScheduler.this.httpCore.getHost();
            int n = retryCountRemaining = ((HttpScheduler)HttpScheduler.this).httpCore.hosts.getFallback(candidateHost) != null ? ((HttpScheduler)HttpScheduler.this).httpCore.options.httpMaxRetryCount : 0;
            while (!this.isCancelled) {
                try {
                    this.result = this.httpExecuteWithRetry(candidateHost, this.path, this.requireAblyAuth);
                    this.setResult(this.result);
                    break;
                }
                catch (AblyException.HostFailedException e) {
                    if (--retryCountRemaining < 0) {
                        this.setError(e.errorInfo);
                        break;
                    }
                    Log.d(TAG, "Connection failed to host `" + candidateHost + "`. Searching for new host...");
                    candidateHost = ((HttpScheduler)HttpScheduler.this).httpCore.hosts.getFallback(candidateHost);
                    if (candidateHost == null) {
                        this.setError(e.errorInfo);
                        break;
                    }
                    Log.d(TAG, "Switched to `" + candidateHost + "`.");
                }
                catch (AblyException e) {
                    this.setError(e.errorInfo);
                    break;
                }
                finally {
                    this.disposeConnection();
                }
            }
        }
    }

    private class AblyRequestWithRetry<T>
    extends AsyncRequest<T>
    implements Runnable {
        private final String host;
        private final String path;
        private final Boolean requireAblyAuth;

        private AblyRequestWithRetry(String host, String path, String method, Param[] headers, Param[] params, HttpCore.RequestBody requestBody, HttpCore.ResponseHandler<T> responseHandler, boolean requireAblyAuth, Callback<T> callback) {
            super(method, headers, params, requestBody, true, responseHandler, callback);
            this.host = host;
            this.path = path;
            this.requireAblyAuth = requireAblyAuth;
        }

        @Override
        public void run() {
            try {
                this.result = this.httpExecuteWithRetry(this.host, this.path, this.requireAblyAuth);
                this.setResult(this.result);
            }
            catch (AblyException e) {
                this.setError(e.errorInfo);
            }
            finally {
                this.disposeConnection();
            }
        }
    }

    private class UrlRequest<T>
    extends AsyncRequest<T>
    implements Runnable {
        private final URL url;

        private UrlRequest(URL url, String method, Param[] headers, Param[] params, HttpCore.RequestBody requestBody, boolean withCredentials, HttpCore.ResponseHandler<T> responseHandler, Callback<T> callback) {
            super(method, headers, params, requestBody, withCredentials, responseHandler, callback);
            this.url = url;
        }

        @Override
        public void run() {
            try {
                Object result = this.httpExecuteWithRetry(this.url);
                this.setResult(result);
            }
            catch (AblyException e) {
                this.setError(e.errorInfo);
            }
            finally {
                this.disposeConnection();
            }
        }
    }
}

