/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import io.ably.lib.transport.Defaults;
import io.ably.lib.util.Log;
import java.io.IOException;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessageUnpacker;

public class ConnectionDetails {
    public String clientId;
    public String connectionKey;
    public String serverId;
    public Long maxMessageSize;
    public Long maxInboundRate;
    public Long maxFrameSize;
    public Long maxIdleInterval = Defaults.maxIdleInterval;
    public Long connectionStateTtl = Defaults.connectionStateTtl;
    private static final String TAG = ConnectionDetails.class.getName();

    ConnectionDetails() {
    }

    ConnectionDetails readMsgpack(MessageUnpacker unpacker) throws IOException {
        int fieldCount = unpacker.unpackMapHeader();
        block20: for (int i = 0; i < fieldCount; ++i) {
            String fieldName = unpacker.unpackString().intern();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            switch (fieldName) {
                case "clientId": {
                    this.clientId = unpacker.unpackString();
                    continue block20;
                }
                case "connectionKey": {
                    this.connectionKey = unpacker.unpackString();
                    continue block20;
                }
                case "serverId": {
                    this.serverId = unpacker.unpackString();
                    continue block20;
                }
                case "maxMessageSize": {
                    this.maxMessageSize = unpacker.unpackLong();
                    continue block20;
                }
                case "maxInboundRate": {
                    this.maxInboundRate = unpacker.unpackLong();
                    continue block20;
                }
                case "maxFrameSize": {
                    this.maxFrameSize = unpacker.unpackLong();
                    continue block20;
                }
                case "maxIdleInterval": {
                    this.maxIdleInterval = unpacker.unpackLong();
                    continue block20;
                }
                case "connectionStateTtl": {
                    this.connectionStateTtl = unpacker.unpackLong();
                    continue block20;
                }
                default: {
                    Log.v(TAG, "Unexpected field: " + fieldName);
                    unpacker.skipValue();
                }
            }
        }
        return this;
    }

    static ConnectionDetails fromMsgpack(MessageUnpacker unpacker) throws IOException {
        return new ConnectionDetails().readMsgpack(unpacker);
    }
}

