/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.http;

import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpScheduler;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AsyncHttpScheduler
extends HttpScheduler<ThreadPoolExecutor> {
    private static final int DEFAULT_POOL_SIZE = 0;
    private static final int MAX_POOL_SIZE = 64;
    private static final long KEEP_ALIVE_TIME = 2000L;
    private static final long SHUTDOWN_TIME = 5000L;
    protected static final String TAG = AsyncHttpScheduler.class.getName();

    public AsyncHttpScheduler(HttpCore httpCore) {
        super(httpCore, new ThreadPoolExecutor(0, 64, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    public void setThreadPoolSize(int size) {
        ((ThreadPoolExecutor)this.executor).setCorePoolSize(size);
    }

    public void dispose() {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.executor;
        threadPoolExecutor.shutdown();
        try {
            threadPoolExecutor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            threadPoolExecutor.shutdownNow();
        }
    }
}

