/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import io.ably.lib.util.Log;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessageUnpacker;

public class ErrorInfo {
    public int code;
    public int statusCode;
    public String message;
    private static final String TAG = ErrorInfo.class.getName();

    public ErrorInfo() {
    }

    public ErrorInfo(String message, int code) {
        this.code = code;
        this.message = message;
    }

    public ErrorInfo(String message, int statusCode, int code) {
        this(message, code);
        this.statusCode = statusCode;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[ErrorInfo");
        if (this.message != null) {
            result.append(" message = ").append(this.message);
        }
        if (this.code > 0) {
            result.append(" code = ").append(this.code);
        }
        if (this.statusCode > 0) {
            result.append(" statusCode = ").append(this.statusCode);
        }
        result.append(']');
        return result.toString();
    }

    ErrorInfo readMsgpack(MessageUnpacker unpacker) throws IOException {
        int fieldCount = unpacker.unpackMapHeader();
        block10: for (int i = 0; i < fieldCount; ++i) {
            String fieldName = unpacker.unpackString().intern();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            switch (fieldName) {
                case "message": {
                    this.message = unpacker.unpackString();
                    continue block10;
                }
                case "code": {
                    this.code = unpacker.unpackInt();
                    continue block10;
                }
                case "statusCode": {
                    this.statusCode = unpacker.unpackInt();
                    continue block10;
                }
                default: {
                    Log.v(TAG, "Unexpected field: " + fieldName);
                    unpacker.skipValue();
                }
            }
        }
        return this;
    }

    static ErrorInfo fromMsgpack(MessageUnpacker unpacker) throws IOException {
        return new ErrorInfo().readMsgpack(unpacker);
    }

    public static ErrorInfo fromThrowable(Throwable throwable) {
        ErrorInfo errorInfo = throwable instanceof UnknownHostException || throwable instanceof NoRouteToHostException ? new ErrorInfo(throwable.getLocalizedMessage(), 500, 50002) : (throwable instanceof IOException ? new ErrorInfo(throwable.getLocalizedMessage(), 500, 50000) : new ErrorInfo("Unexpected exception: " + throwable.getLocalizedMessage(), 50000, 500));
        return errorInfo;
    }

    public static ErrorInfo fromResponseStatus(String statusLine, int statusCode) {
        return new ErrorInfo(statusLine, statusCode, statusCode * 100);
    }
}

