/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.transport;

import io.ably.lib.transport.Defaults;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import java.util.Arrays;
import java.util.Collections;

public class Hosts {
    private String primaryHost;
    boolean primaryHostIsDefault;
    private final String defaultHost;
    private final String[] fallbackHosts;
    private final boolean fallbackHostsIsDefault;
    private final boolean fallbackHostsUseDefault;

    public Hosts(String primaryHost, String defaultHost, ClientOptions options) throws AblyException {
        this.defaultHost = defaultHost;
        if (primaryHost != null) {
            this.setHost(primaryHost);
            if (options.environment != null) {
                throw AblyException.fromErrorInfo(new ErrorInfo("cannot set both restHost/realtimeHost and environment options", 40000, 400));
            }
        } else if (options.environment != null && !options.environment.equalsIgnoreCase("production")) {
            this.setHost(options.environment + "-" + defaultHost);
        } else {
            this.setHost(defaultHost);
        }
        this.fallbackHostsUseDefault = options.fallbackHostsUseDefault;
        if (options.fallbackHosts == null) {
            this.fallbackHosts = Arrays.copyOf(Defaults.HOST_FALLBACKS, Defaults.HOST_FALLBACKS.length);
            this.fallbackHostsIsDefault = true;
        } else {
            this.fallbackHosts = Arrays.copyOf(options.fallbackHosts, options.fallbackHosts.length);
            this.fallbackHostsIsDefault = false;
            if (options.fallbackHostsUseDefault) {
                throw AblyException.fromErrorInfo(new ErrorInfo("cannot set both fallbackHosts and fallbackHostsUseDefault options", 40000, 400));
            }
        }
        Collections.shuffle(Arrays.asList(this.fallbackHosts));
    }

    public void setHost(String primaryHost) {
        this.primaryHost = primaryHost;
        this.primaryHostIsDefault = primaryHost.equalsIgnoreCase(this.defaultHost);
    }

    public String getHost() {
        return this.primaryHost;
    }

    public String getFallback(String lastHost) {
        int idx;
        if (this.fallbackHosts == null) {
            return null;
        }
        if (lastHost.equals(this.primaryHost)) {
            if (!this.primaryHostIsDefault && !this.fallbackHostsUseDefault && this.fallbackHostsIsDefault) {
                return null;
            }
            idx = 0;
        } else {
            idx = Arrays.asList(this.fallbackHosts).indexOf(lastHost);
            if (idx < 0) {
                return null;
            }
            ++idx;
        }
        if (idx >= this.fallbackHosts.length) {
            return null;
        }
        return this.fallbackHosts[idx];
    }
}

