/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.rest;

import io.ably.annotation.Experimental;
import io.ably.lib.http.AsyncHttpPaginatedQuery;
import io.ably.lib.http.AsyncHttpScheduler;
import io.ably.lib.http.AsyncPaginatedQuery;
import io.ably.lib.http.Http;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpPaginatedQuery;
import io.ably.lib.http.HttpScheduler;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.http.PaginatedQuery;
import io.ably.lib.http.SyncHttpScheduler;
import io.ably.lib.rest.Auth;
import io.ably.lib.rest.Channel;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.AsyncHttpPaginatedResponse;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.HttpPaginatedResponse;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageSerializer;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.types.PublishResponse;
import io.ably.lib.types.Stats;
import io.ably.lib.types.StatsReader;
import io.ably.lib.util.Crypto;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.util.HashMap;

public class AblyRest {
    public final ClientOptions options;
    final String clientId;
    public final Http http;
    public final HttpCore httpCore;
    public final Auth auth;
    public final Channels channels;

    public AblyRest(String key) throws AblyException {
        this(new ClientOptions(key));
    }

    public AblyRest(ClientOptions options) throws AblyException {
        if (options == null) {
            String msg = "no options provided";
            Log.e(this.getClass().getName(), msg);
            throw AblyException.fromErrorInfo(new ErrorInfo(msg, 400, 40000));
        }
        this.options = options;
        Log.setLevel(options.logLevel);
        Log.setHandler(options.logHandler);
        Log.i(this.getClass().getName(), "started");
        this.clientId = options.clientId;
        this.auth = new Auth(this, options);
        this.httpCore = new HttpCore(options, this.auth);
        this.http = new Http(new AsyncHttpScheduler(this.httpCore, options), new SyncHttpScheduler(this.httpCore));
        this.channels = new Channels();
    }

    public long time() throws AblyException {
        return this.timeImpl().sync();
    }

    public void timeAsync(Callback<Long> callback) {
        this.timeImpl().async(callback);
    }

    private Http.Request<Long> timeImpl() {
        return this.http.request(new Http.Execute<Long>(){

            @Override
            public void execute(HttpScheduler http, Callback<Long> callback) throws AblyException {
                http.get("/time", HttpUtils.defaultAcceptHeaders(false), null, new HttpCore.ResponseHandler<Long>(){

                    @Override
                    public Long handleResponse(HttpCore.Response response, ErrorInfo error) throws AblyException {
                        if (error != null) {
                            throw AblyException.fromErrorInfo(error);
                        }
                        return ((Long[])Serialisation.gson.fromJson(new String(response.body), Long[].class))[0];
                    }
                }, false, callback);
            }
        });
    }

    public PaginatedResult<Stats> stats(Param[] params) throws AblyException {
        return new PaginatedQuery<Stats>(this.http, "/stats", HttpUtils.defaultAcceptHeaders(false), params, StatsReader.statsResponseHandler).get();
    }

    public void statsAsync(Param[] params, Callback<AsyncPaginatedResult<Stats>> callback) {
        new AsyncPaginatedQuery<Stats>(this.http, "/stats", HttpUtils.defaultAcceptHeaders(false), params, StatsReader.statsResponseHandler).get(callback);
    }

    public HttpPaginatedResponse request(String method, String path, Param[] params, HttpCore.RequestBody body, Param[] headers) throws AblyException {
        headers = HttpUtils.mergeHeaders(HttpUtils.defaultAcceptHeaders(false), headers);
        return new HttpPaginatedQuery(this.http, method, path, headers, params, body).exec();
    }

    public void requestAsync(String method, String path, Param[] params, HttpCore.RequestBody body, Param[] headers, AsyncHttpPaginatedResponse.Callback callback) {
        headers = HttpUtils.mergeHeaders(HttpUtils.defaultAcceptHeaders(false), headers);
        new AsyncHttpPaginatedQuery(this.http, method, path, headers, params, body).exec(callback);
    }

    @Experimental
    public PublishResponse[] publishBatch(Message.Batch[] pubSpecs, ChannelOptions channelOptions) throws AblyException {
        return this.publishBatchImpl(pubSpecs, channelOptions).sync();
    }

    @Experimental
    public void publishBatchAsync(Message.Batch[] pubSpecs, ChannelOptions channelOptions, Callback<PublishResponse[]> callback) throws AblyException {
        this.publishBatchImpl(pubSpecs, channelOptions).async(callback);
    }

    private Http.Request<PublishResponse[]> publishBatchImpl(final Message.Batch[] pubSpecs, ChannelOptions channelOptions) throws AblyException {
        boolean hasClientSuppliedId = false;
        for (Message.Batch spec : pubSpecs) {
            for (Message message : spec.messages) {
                hasClientSuppliedId |= message.id != null;
                this.auth.checkClientId(message, true, false);
                message.encode(channelOptions);
            }
            if (hasClientSuppliedId || !this.options.idempotentRestPublishing) continue;
            String messageId = Crypto.getRandomMessageId();
            for (int i = 0; i < spec.messages.length; ++i) {
                spec.messages[i].id = messageId + ':' + i;
            }
        }
        return this.http.request(new Http.Execute<PublishResponse[]>(){

            @Override
            public void execute(HttpScheduler http, Callback<PublishResponse[]> callback) throws AblyException {
                HttpCore.RequestBody requestBody = AblyRest.this.options.useBinaryProtocol ? MessageSerializer.asMsgpackRequest(pubSpecs) : MessageSerializer.asJSONRequest(pubSpecs);
                http.post("/messages", HttpUtils.defaultAcceptHeaders(AblyRest.this.options.useBinaryProtocol), null, requestBody, new HttpCore.ResponseHandler<PublishResponse[]>(){

                    @Override
                    public PublishResponse[] handleResponse(HttpCore.Response response, ErrorInfo error) throws AblyException {
                        if (error != null && error.code != 40020) {
                            throw AblyException.fromErrorInfo(error);
                        }
                        return PublishResponse.getBulkPublishResponseHandler(response.statusCode).handleResponseBody(response.contentType, response.body);
                    }
                }, true, callback);
            }
        });
    }

    protected void onAuthUpdated(String token, boolean waitForResponse) throws AblyException {
    }

    protected void onAuthError(ErrorInfo errorInfo) {
    }

    public class Channels
    extends HashMap<String, Channel> {
        private static final long serialVersionUID = 1L;

        public Channel get(String channelName) {
            try {
                return this.get(channelName, null);
            }
            catch (AblyException e) {
                return null;
            }
        }

        public Channel get(String channelName, ChannelOptions channelOptions) throws AblyException {
            Channel channel = (Channel)super.get(channelName);
            if (channel != null) {
                if (channelOptions != null) {
                    channel.options = channelOptions;
                }
                return channel;
            }
            channel = new Channel(AblyRest.this, channelName, channelOptions);
            super.put(channelName, channel);
            return channel;
        }

        public void release(String channelName) {
            super.remove(channelName);
        }
    }
}

