/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.util;

import io.ably.lib.types.AblyException;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.util.Base64Coder;
import io.ably.lib.util.Log;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Crypto {
    public static final String DEFAULT_ALGORITHM = "aes";
    public static final int DEFAULT_KEYLENGTH = Crypto.is256BitsSupported() ? 256 : 128;
    public static final int DEFAULT_BLOCKLENGTH = 16;
    private static final SecureRandom secureRandom = new SecureRandom();
    private static final String TAG = Crypto.class.getName();

    public static CipherParams getDefaultParams() {
        return Crypto.getParams(DEFAULT_ALGORITHM, DEFAULT_KEYLENGTH);
    }

    public static CipherParams getDefaultParams(byte[] key) {
        try {
            return Crypto.getParams(DEFAULT_ALGORITHM, key);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static CipherParams getDefaultParams(String base64Key) {
        return Crypto.getDefaultParams(Base64Coder.decode(base64Key));
    }

    public static CipherParams getDefaultParams(CipherParams params) {
        return new CipherParams(params.algorithm, params.keyLength, params.keySpec, params.ivSpec);
    }

    public static CipherParams getParams(String algorithm, int keyLength) {
        if (algorithm == null) {
            algorithm = DEFAULT_ALGORITHM;
        }
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(algorithm.toUpperCase());
            keygen.init(keyLength);
            byte[] key = keygen.generateKey().getEncoded();
            return Crypto.getParams(algorithm, key);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static CipherParams getParams(String algorithm, byte[] key) throws NoSuchAlgorithmException {
        CipherParams params = new CipherParams(algorithm, key);
        byte[] ivBytes = new byte[16];
        secureRandom.nextBytes(ivBytes);
        params.ivSpec = new IvParameterSpec(ivBytes);
        return params;
    }

    public static byte[] generateRandomKey(int keyLength) {
        byte[] result = new byte[(keyLength + 7) / 8];
        secureRandom.nextBytes(result);
        return result;
    }

    public static byte[] generateRandomKey() {
        return Crypto.generateRandomKey(DEFAULT_KEYLENGTH);
    }

    public static ChannelCipher getCipher(ChannelOptions opts) throws AblyException {
        CipherParams params;
        if (opts.cipherParams == null) {
            params = Crypto.getDefaultParams();
        } else if (opts.cipherParams instanceof CipherParams) {
            params = (CipherParams)opts.cipherParams;
        } else {
            throw AblyException.fromErrorInfo(new ErrorInfo("ChannelOptions not supported", 400, 40000));
        }
        return new CBCCipher(params);
    }

    public static String getRandomMessageId() {
        byte[] entropy = new byte[9];
        secureRandom.nextBytes(entropy);
        return Base64Coder.encode(entropy).toString();
    }

    private static boolean is256BitsSupported() {
        try {
            return Cipher.getMaxAllowedKeyLength(DEFAULT_ALGORITHM) >= 256;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    private static class CBCCipher
    implements ChannelCipher {
        private final SecretKeySpec keySpec;
        private final Cipher encryptCipher;
        private final Cipher decryptCipher;
        private final String algorithm;
        private final int blockLength;
        private byte[] iv;
        private static final byte[] emptyBlock = new byte[16];
        private static final byte[][] pkcs5Padding = new byte[][]{{16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16}, {1}, {2, 2}, {3, 3, 3}, {4, 4, 4, 4}, {5, 5, 5, 5, 5}, {6, 6, 6, 6, 6, 6}, {7, 7, 7, 7, 7, 7, 7}, {8, 8, 8, 8, 8, 8, 8, 8}, {9, 9, 9, 9, 9, 9, 9, 9, 9}, {10, 10, 10, 10, 10, 10, 10, 10, 10, 10}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11}, {12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12}, {13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13}, {14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14}, {15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15}, {16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16}};

        private CBCCipher(CipherParams params) throws AblyException {
            String transformation = params.algorithm.toUpperCase() + "/CBC/PKCS5Padding";
            try {
                this.algorithm = params.algorithm + '-' + params.keyLength + "-cbc";
                this.keySpec = params.keySpec;
                this.encryptCipher = Cipher.getInstance(transformation);
                this.encryptCipher.init(1, (Key)params.keySpec, params.ivSpec);
                this.decryptCipher = Cipher.getInstance(transformation);
                this.iv = params.ivSpec.getIV();
                this.blockLength = this.iv.length;
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw AblyException.fromThrowable(e);
            }
        }

        @Override
        public byte[] encrypt(byte[] plaintext) {
            if (plaintext == null) {
                return null;
            }
            int plaintextLength = plaintext.length;
            int paddedLength = CBCCipher.getPaddedLength(plaintextLength);
            byte[] cipherIn = new byte[paddedLength];
            byte[] ciphertext = new byte[paddedLength + this.blockLength];
            int padding = paddedLength - plaintextLength;
            System.arraycopy(plaintext, 0, cipherIn, 0, plaintextLength);
            System.arraycopy(pkcs5Padding[padding], 0, cipherIn, plaintextLength, padding);
            System.arraycopy(this.getIv(), 0, ciphertext, 0, this.blockLength);
            byte[] cipherOut = this.encryptCipher.update(cipherIn);
            System.arraycopy(cipherOut, 0, ciphertext, this.blockLength, paddedLength);
            return ciphertext;
        }

        @Override
        public byte[] decrypt(byte[] ciphertext) throws AblyException {
            if (ciphertext == null) {
                return null;
            }
            byte[] plaintext = null;
            try {
                this.decryptCipher.init(2, (Key)this.keySpec, new IvParameterSpec(ciphertext, 0, this.blockLength));
                plaintext = this.decryptCipher.doFinal(ciphertext, this.blockLength, ciphertext.length - this.blockLength);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
                Log.e(TAG, "decrypt()", e);
                throw AblyException.fromThrowable(e);
            }
            return plaintext;
        }

        @Override
        public String getAlgorithm() {
            return this.algorithm;
        }

        private byte[] getIv() {
            if (this.iv == null) {
                return this.encryptCipher.update(emptyBlock);
            }
            byte[] result = this.iv;
            this.iv = null;
            return result;
        }

        private static final int getPaddedLength(int plaintextLength) {
            return plaintextLength + 16 & 0xFFFFFFF0;
        }
    }

    public static interface ChannelCipher {
        public byte[] encrypt(byte[] var1) throws AblyException;

        public byte[] decrypt(byte[] var1) throws AblyException;

        public String getAlgorithm();
    }

    public static class CipherParams {
        public final String algorithm;
        public final int keyLength;
        public final SecretKeySpec keySpec;
        public IvParameterSpec ivSpec;

        public CipherParams(String algorithm, byte[] key) throws NoSuchAlgorithmException {
            if (algorithm == null) {
                algorithm = Crypto.DEFAULT_ALGORITHM;
            }
            this.algorithm = algorithm;
            this.keyLength = key.length * 8;
            this.keySpec = new SecretKeySpec(key, algorithm.toUpperCase());
        }

        private CipherParams(String algorithm, int keyLength, SecretKeySpec keySpec, IvParameterSpec ivSpec) {
            this.algorithm = algorithm;
            this.keyLength = keyLength;
            this.keySpec = keySpec;
            this.ivSpec = ivSpec;
        }
    }
}

