/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.rest;

import io.ably.lib.http.AsyncHttp;
import io.ably.lib.http.AsyncHttpPaginatedQuery;
import io.ably.lib.http.AsyncPaginatedQuery;
import io.ably.lib.http.Http;
import io.ably.lib.http.HttpPaginatedQuery;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.http.PaginatedQuery;
import io.ably.lib.rest.Auth;
import io.ably.lib.rest.Channel;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.AsyncHttpPaginatedResponse;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.HttpPaginatedResponse;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.types.Stats;
import io.ably.lib.types.StatsReader;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.util.HashMap;

public class AblyRest {
    public final ClientOptions options;
    final String clientId;
    public final Http http;
    public final AsyncHttp asyncHttp;
    public final Auth auth;
    public final Channels channels;

    public AblyRest(String key) throws AblyException {
        this(new ClientOptions(key));
    }

    public AblyRest(ClientOptions options) throws AblyException {
        if (options == null) {
            String msg = "no options provided";
            Log.e(this.getClass().getName(), msg);
            throw AblyException.fromErrorInfo(new ErrorInfo(msg, 400, 40000));
        }
        this.options = options;
        Log.setLevel(options.logLevel);
        Log.setHandler(options.logHandler);
        Log.i(this.getClass().getName(), "started");
        this.clientId = options.clientId;
        this.auth = new Auth(this, options);
        this.http = new Http(options, this.auth);
        this.asyncHttp = new AsyncHttp(this.http);
        this.channels = new Channels();
    }

    public long time() throws AblyException {
        return this.http.get("/time", HttpUtils.defaultAcceptHeaders(false), null, new Http.ResponseHandler<Long>(){

            @Override
            public Long handleResponse(Http.Response response, ErrorInfo error) throws AblyException {
                if (error != null) {
                    throw AblyException.fromErrorInfo(error);
                }
                return ((Long[])Serialisation.gson.fromJson(new String(response.body), Long[].class))[0];
            }
        }, false);
    }

    public void timeAsync(Callback<Long> callback) {
        this.asyncHttp.get("/time", HttpUtils.defaultAcceptHeaders(false), null, new Http.ResponseHandler<Long>(){

            @Override
            public Long handleResponse(Http.Response response, ErrorInfo error) throws AblyException {
                if (error != null) {
                    throw AblyException.fromErrorInfo(error);
                }
                return ((Long[])Serialisation.gson.fromJson(new String(response.body), Long[].class))[0];
            }
        }, false, callback);
    }

    public PaginatedResult<Stats> stats(Param[] params) throws AblyException {
        return new PaginatedQuery<Stats>(this.http, "/stats", HttpUtils.defaultAcceptHeaders(false), params, StatsReader.statsResponseHandler).get();
    }

    public void statsAsync(Param[] params, Callback<AsyncPaginatedResult<Stats>> callback) {
        new AsyncPaginatedQuery<Stats>(this.asyncHttp, "/stats", HttpUtils.defaultAcceptHeaders(false), params, StatsReader.statsResponseHandler).get(callback);
    }

    public HttpPaginatedResponse request(String method, String path, Param[] params, Http.RequestBody body, Param[] headers) throws AblyException {
        headers = HttpUtils.mergeHeaders(HttpUtils.defaultAcceptHeaders(false), headers);
        return new HttpPaginatedQuery(this.http, method, path, headers, params, body).exec();
    }

    public void requestAsync(String method, String path, Param[] params, Http.RequestBody body, Param[] headers, AsyncHttpPaginatedResponse.Callback callback) {
        headers = HttpUtils.mergeHeaders(HttpUtils.defaultAcceptHeaders(false), headers);
        new AsyncHttpPaginatedQuery(this.asyncHttp, method, path, headers, params, body).exec(callback);
    }

    protected void onAuthUpdated(String token, boolean waitForResponse) throws AblyException {
    }

    protected void onAuthError(ErrorInfo errorInfo) {
    }

    public class Channels
    extends HashMap<String, Channel> {
        private static final long serialVersionUID = 1L;

        public Channel get(String channelName) {
            try {
                return this.get(channelName, null);
            }
            catch (AblyException e) {
                return null;
            }
        }

        public Channel get(String channelName, ChannelOptions channelOptions) throws AblyException {
            Channel channel = (Channel)super.get(channelName);
            if (channel != null) {
                if (channelOptions != null) {
                    channel.options = channelOptions;
                }
                return channel;
            }
            channel = new Channel(AblyRest.this, channelName, channelOptions);
            super.put(channelName, channel);
            return channel;
        }

        public void release(String channelName) {
            super.remove(channelName);
        }
    }
}

