/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.http;

import io.ably.lib.http.Http;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PaginatedQuery<T>
implements Http.ResponseHandler<PaginatedResult<T>> {
    protected static Pattern linkPattern = Pattern.compile("\\s*<(.*)>;\\s*rel=\"(.*)\"");
    protected static Pattern urlPattern = Pattern.compile("\\./(.*)\\?(.*)");
    private final Http http;
    private final String path;
    private final Param[] requestHeaders;
    private final Param[] requestParams;
    private final Http.RequestBody requestBody;
    private final Http.BodyHandler<T> bodyHandler;

    public PaginatedQuery(Http http, String path, Param[] headers, Param[] params, Http.BodyHandler<T> bodyHandler) {
        this(http, path, headers, params, null, bodyHandler);
    }

    public PaginatedQuery(Http http, String path, Param[] headers, Param[] params, Http.RequestBody requestBody, Http.BodyHandler<T> bodyHandler) {
        this.http = http;
        this.path = path;
        this.requestHeaders = headers;
        this.requestParams = params;
        this.requestBody = requestBody;
        this.bodyHandler = bodyHandler;
    }

    public PaginatedResult<T> get() throws AblyException {
        return (PaginatedResult)this.http.get(this.path, this.requestHeaders, this.requestParams, this, true);
    }

    public PaginatedResult<T> exec(String method) throws AblyException {
        return (PaginatedResult)this.http.exec(this.path, method, this.requestHeaders, this.requestParams, this.requestBody, this, true);
    }

    @Override
    public PaginatedResult<T> handleResponse(Http.Response response, ErrorInfo error) throws AblyException {
        if (error != null) {
            throw AblyException.fromErrorInfo(error);
        }
        Object[] responseContents = this.bodyHandler.handleResponseBody(response.contentType, response.body);
        return new ResultPage(responseContents, response.getHeaderFields("Link"));
    }

    protected static HashMap<String, String> parseLinks(Collection<String> linkHeaders) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String link : linkHeaders) {
            Matcher linkMatch = linkPattern.matcher(link);
            if (!linkMatch.matches()) continue;
            String linkUrl = linkMatch.group(1);
            for (String linkRel : linkMatch.group(2).toLowerCase(Locale.ENGLISH).split("\\s")) {
                result.put(linkRel, linkUrl);
            }
        }
        return result;
    }

    public class ResultPage
    implements PaginatedResult<T> {
        private T[] contents;
        private String relFirst;
        private String relCurrent;
        private String relNext;

        private ResultPage(T[] contents, Collection<String> linkHeaders) throws AblyException {
            this.contents = contents;
            if (linkHeaders != null) {
                HashMap<String, String> links = PaginatedQuery.parseLinks(linkHeaders);
                this.relFirst = links.get("first");
                this.relCurrent = links.get("current");
                this.relNext = links.get("next");
            }
        }

        @Override
        public T[] items() {
            return this.contents;
        }

        @Override
        public PaginatedResult<T> first() throws AblyException {
            return this.getRel(this.relFirst);
        }

        @Override
        public PaginatedResult<T> current() throws AblyException {
            return this.getRel(this.relCurrent);
        }

        @Override
        public PaginatedResult<T> next() throws AblyException {
            return this.getRel(this.relNext);
        }

        private PaginatedResult<T> getRel(String linkUrl) throws AblyException {
            if (linkUrl == null) {
                return null;
            }
            Matcher urlMatch = urlPattern.matcher(linkUrl);
            if (urlMatch.matches()) {
                String[] paramSpecs = urlMatch.group(2).split("&");
                Param[] params = new Param[paramSpecs.length];
                try {
                    for (int i = 0; i < paramSpecs.length; ++i) {
                        String[] split = paramSpecs[i].split("=");
                        params[i] = new Param(split[0], URLDecoder.decode(split[1], "UTF-8"));
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                return (PaginatedResult)PaginatedQuery.this.http.get(PaginatedQuery.this.path, PaginatedQuery.this.requestHeaders, params, PaginatedQuery.this, true);
            }
            throw AblyException.fromErrorInfo(new ErrorInfo("Unexpected link URL format", 500, 50000));
        }

        @Override
        public boolean hasFirst() {
            return this.relFirst != null;
        }

        @Override
        public boolean hasCurrent() {
            return this.relCurrent != null;
        }

        @Override
        public boolean hasNext() {
            return this.relNext != null;
        }

        @Override
        public boolean isLast() {
            return this.relNext == null;
        }
    }
}

