/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.http;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.ably.lib.http.Http;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.http.PaginatedQuery;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.HttpPaginatedResponse;
import io.ably.lib.types.Param;
import io.ably.lib.util.Serialisation;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;

public class HttpPaginatedQuery
implements Http.ResponseHandler<HttpPaginatedResponse> {
    static final Http.BodyHandler<JsonElement> jsonArrayResponseHandler = new Http.BodyHandler<JsonElement>(){

        public JsonElement[] handleResponseBody(String contentType, byte[] body) throws AblyException {
            if (!"application/json".equals(contentType)) {
                throw AblyException.fromErrorInfo(new ErrorInfo("Unexpected content type: " + contentType, 500, 50000));
            }
            JsonElement jsonBody = Serialisation.gsonParser.parse(new String(body, Charset.forName("UTF-8")));
            if (!jsonBody.isJsonArray()) {
                return new JsonElement[]{jsonBody};
            }
            JsonArray jsonArray = jsonBody.getAsJsonArray();
            JsonElement[] items = new JsonElement[jsonArray.size()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = jsonArray.get(i);
            }
            return items;
        }
    };
    private final Http http;
    private final String method;
    private final String path;
    private final Param[] requestHeaders;
    private final Param[] requestParams;
    private final Http.RequestBody requestBody;
    private final Http.BodyHandler<JsonElement> bodyHandler;

    public HttpPaginatedQuery(Http http, String method, String path, Param[] headers, Param[] params, Http.RequestBody requestBody) {
        this.http = http;
        this.method = method;
        this.path = path;
        this.requestHeaders = headers;
        this.requestParams = params;
        this.requestBody = requestBody;
        this.bodyHandler = jsonArrayResponseHandler;
    }

    public HttpPaginatedResponse exec() throws AblyException {
        return this.http.exec(this.path, this.method, this.requestHeaders, this.requestParams, this.requestBody, this, true);
    }

    public HttpPaginatedResponse exec(Param[] params) throws AblyException {
        return this.http.exec(this.path, this.method, this.requestHeaders, params, this.requestBody, this, true);
    }

    @Override
    public HttpPaginatedResponse handleResponse(Http.Response response, ErrorInfo error) throws AblyException {
        return new HttpPaginatedResult(response, error);
    }

    public class HttpPaginatedResult
    extends HttpPaginatedResponse {
        private JsonElement[] contents;
        private String relFirst;
        private String relCurrent;
        private String relNext;

        private HttpPaginatedResult(Http.Response response, ErrorInfo error) throws AblyException {
            this.statusCode = response.statusCode;
            this.headers = HttpUtils.toParamArray(response.headers);
            if (error != null) {
                this.errorCode = error.code;
                this.errorMessage = error.message;
            } else {
                this.success = true;
                if (response.body != null) {
                    this.contents = (JsonElement[])HttpPaginatedQuery.this.bodyHandler.handleResponseBody(response.contentType, response.body);
                }
            }
            List<String> linkHeaders = response.getHeaderFields("Link");
            if (linkHeaders != null) {
                HashMap<String, String> links = PaginatedQuery.parseLinks(linkHeaders);
                this.relFirst = links.get("first");
                this.relCurrent = links.get("current");
                this.relNext = links.get("next");
            }
        }

        @Override
        public JsonElement[] items() {
            return this.contents;
        }

        @Override
        public HttpPaginatedResponse first() throws AblyException {
            return this.execRel(this.relFirst);
        }

        @Override
        public HttpPaginatedResponse current() throws AblyException {
            return this.execRel(this.relCurrent);
        }

        @Override
        public HttpPaginatedResponse next() throws AblyException {
            return this.execRel(this.relNext);
        }

        private HttpPaginatedResponse execRel(String linkUrl) throws AblyException {
            if (linkUrl == null) {
                return null;
            }
            Matcher urlMatch = PaginatedQuery.urlPattern.matcher(linkUrl);
            if (urlMatch.matches()) {
                String[] paramSpecs = urlMatch.group(2).split("&");
                Param[] params = new Param[paramSpecs.length];
                try {
                    for (int i = 0; i < paramSpecs.length; ++i) {
                        String[] split = paramSpecs[i].split("=");
                        String paramKey = split[0];
                        String paramValue = split.length >= 2 ? split[1] : "";
                        params[i] = new Param(paramKey, URLDecoder.decode(paramValue, "UTF-8"));
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                return HttpPaginatedQuery.this.exec(params);
            }
            throw AblyException.fromErrorInfo(new ErrorInfo("Unexpected link URL format", 500, 50000));
        }

        @Override
        public boolean hasFirst() {
            return this.relFirst != null;
        }

        @Override
        public boolean hasCurrent() {
            return this.relCurrent != null;
        }

        @Override
        public boolean hasNext() {
            return this.relNext != null;
        }

        @Override
        public boolean isLast() {
            return this.relNext == null;
        }
    }
}

