/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.http;

import io.ably.lib.http.AsyncHttp;
import io.ably.lib.http.Http;
import io.ably.lib.http.PaginatedQuery;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Param;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;

public class AsyncPaginatedQuery<T>
implements Http.ResponseHandler<AsyncPaginatedResult<T>> {
    private final AsyncHttp http;
    private final String path;
    private final Param[] headers;
    private final Param[] params;
    private final Http.RequestBody requestBody;
    private final Http.BodyHandler<T> bodyHandler;

    public AsyncPaginatedQuery(AsyncHttp http, String path, Param[] headers, Param[] params, Http.BodyHandler<T> bodyHandler) {
        this(http, path, headers, params, null, bodyHandler);
    }

    public AsyncPaginatedQuery(AsyncHttp http, String path, Param[] headers, Param[] params, Http.RequestBody requestBody, Http.BodyHandler<T> bodyHandler) {
        this.http = http;
        this.path = path;
        this.headers = headers;
        this.params = params;
        this.requestBody = requestBody;
        this.bodyHandler = bodyHandler;
    }

    public void get(Callback<AsyncPaginatedResult<T>> callback) {
        this.http.get(this.path, this.headers, this.params, this, true, callback);
    }

    public void exec(String method, Callback<AsyncPaginatedResult<T>> callback) {
        this.exec(method, this.params, callback);
    }

    public void exec(String method, Param[] params, Callback<AsyncPaginatedResult<T>> callback) {
        this.http.exec(this.path, method, this.headers, params, this.requestBody, this, true, callback);
    }

    @Override
    public AsyncPaginatedResult<T> handleResponse(Http.Response response, ErrorInfo error) throws AblyException {
        if (error != null) {
            throw AblyException.fromErrorInfo(error);
        }
        Object[] responseContents = this.bodyHandler.handleResponseBody(response.contentType, response.body);
        List<String> linkHeaders = response.getHeaderFields("Link");
        return new ResultPage(responseContents, linkHeaders);
    }

    public class ResultPage
    implements AsyncPaginatedResult<T> {
        private T[] contents;
        private String relFirst;
        private String relCurrent;
        private String relNext;

        private ResultPage(T[] contents, Collection<String> linkHeaders) {
            this.contents = contents;
            if (linkHeaders != null) {
                HashMap<String, String> links = PaginatedQuery.parseLinks(linkHeaders);
                this.relFirst = links.get("first");
                this.relCurrent = links.get("current");
                this.relNext = links.get("next");
            }
        }

        @Override
        public T[] items() {
            return this.contents;
        }

        @Override
        public void first(Callback<AsyncPaginatedResult<T>> callback) {
            this.getRel(this.relFirst, callback);
        }

        @Override
        public void current(Callback<AsyncPaginatedResult<T>> callback) {
            this.getRel(this.relCurrent, callback);
        }

        @Override
        public void next(Callback<AsyncPaginatedResult<T>> callback) {
            this.getRel(this.relNext, callback);
        }

        private void getRel(String linkUrl, Callback<AsyncPaginatedResult<T>> callback) {
            if (linkUrl == null) {
                callback.onSuccess(null);
                return;
            }
            Matcher urlMatch = PaginatedQuery.urlPattern.matcher(linkUrl);
            if (!urlMatch.matches()) {
                callback.onError(new ErrorInfo("Unexpected link URL format", 500, 50000));
                return;
            }
            String[] paramSpecs = urlMatch.group(2).split("&");
            Param[] params = new Param[paramSpecs.length];
            try {
                for (int i = 0; i < paramSpecs.length; ++i) {
                    String[] split = paramSpecs[i].split("=");
                    params[i] = new Param(split[0], URLDecoder.decode(split[1], "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            AsyncPaginatedQuery.this.http.get(AsyncPaginatedQuery.this.path, AsyncPaginatedQuery.this.headers, params, AsyncPaginatedQuery.this, true, callback);
        }

        @Override
        public boolean hasFirst() {
            return this.relFirst != null;
        }

        @Override
        public boolean hasCurrent() {
            return this.relCurrent != null;
        }

        @Override
        public boolean hasNext() {
            return this.relNext != null;
        }
    }
}

