/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.http;

import com.google.gson.JsonElement;
import io.ably.lib.http.AsyncHttp;
import io.ably.lib.http.Http;
import io.ably.lib.http.HttpPaginatedQuery;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.http.PaginatedQuery;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.AsyncHttpPaginatedResponse;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Param;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;

public class AsyncHttpPaginatedQuery
implements Http.ResponseHandler<AsyncHttpPaginatedResponse> {
    private final AsyncHttp http;
    private final String method;
    private final String path;
    private final Param[] headers;
    private final Param[] params;
    private final Http.RequestBody requestBody;
    private final Http.BodyHandler<JsonElement> bodyHandler;

    public AsyncHttpPaginatedQuery(AsyncHttp http, String method, String path, Param[] headers, Param[] params, Http.RequestBody requestBody) {
        this.http = http;
        this.method = method;
        this.path = path;
        this.headers = headers;
        this.params = params;
        this.requestBody = requestBody;
        this.bodyHandler = HttpPaginatedQuery.jsonArrayResponseHandler;
    }

    public void exec(AsyncHttpPaginatedResponse.Callback callback) {
        this.exec(this.params, callback);
    }

    public void exec(Param[] params, AsyncHttpPaginatedResponse.Callback callback) {
        this.http.exec(this.path, this.method, this.headers, params, this.requestBody, this, true, AsyncHttpPaginatedQuery.wrap(callback));
    }

    @Override
    public AsyncHttpPaginatedResponse handleResponse(Http.Response response, ErrorInfo error) {
        return new AsyncHttpPaginatedResult(response, error);
    }

    private static Callback<AsyncHttpPaginatedResponse> wrap(final AsyncHttpPaginatedResponse.Callback callback) {
        return new Callback<AsyncHttpPaginatedResponse>(){

            @Override
            public void onSuccess(AsyncHttpPaginatedResponse result) {
                callback.onResponse(result);
            }

            @Override
            public void onError(ErrorInfo reason) {
                callback.onError(reason);
            }
        };
    }

    public class AsyncHttpPaginatedResult
    extends AsyncHttpPaginatedResponse {
        private JsonElement[] contents;
        private String relFirst;
        private String relCurrent;
        private String relNext;

        private AsyncHttpPaginatedResult(Http.Response response, ErrorInfo error) {
            this.statusCode = response.statusCode;
            this.headers = HttpUtils.toParamArray(response.headers);
            if (error != null) {
                this.errorCode = error.code;
                this.errorMessage = error.message;
            } else {
                this.success = true;
                if (response.body != null) {
                    try {
                        this.contents = (JsonElement[])AsyncHttpPaginatedQuery.this.bodyHandler.handleResponseBody(response.contentType, response.body);
                    }
                    catch (AblyException e) {
                        e.printStackTrace();
                    }
                }
            }
            List<String> linkHeaders = response.getHeaderFields("Link");
            if (linkHeaders != null) {
                HashMap<String, String> links = PaginatedQuery.parseLinks(linkHeaders);
                this.relFirst = links.get("first");
                this.relCurrent = links.get("current");
                this.relNext = links.get("next");
            }
        }

        @Override
        public JsonElement[] items() {
            return this.contents;
        }

        @Override
        public void first(AsyncHttpPaginatedResponse.Callback callback) {
            this.execRel(this.relFirst, callback);
        }

        @Override
        public void current(AsyncHttpPaginatedResponse.Callback callback) {
            this.execRel(this.relCurrent, callback);
        }

        @Override
        public void next(AsyncHttpPaginatedResponse.Callback callback) {
            this.execRel(this.relNext, callback);
        }

        private void execRel(String linkUrl, AsyncHttpPaginatedResponse.Callback callback) {
            if (linkUrl == null) {
                callback.onResponse(null);
                return;
            }
            Matcher urlMatch = PaginatedQuery.urlPattern.matcher(linkUrl);
            if (!urlMatch.matches()) {
                callback.onError(new ErrorInfo("Unexpected link URL format", 500, 50000));
                return;
            }
            String[] paramSpecs = urlMatch.group(2).split("&");
            Param[] params = new Param[paramSpecs.length];
            try {
                for (int i = 0; i < paramSpecs.length; ++i) {
                    String[] split = paramSpecs[i].split("=");
                    String paramKey = split[0];
                    String paramValue = split.length >= 2 ? split[1] : "";
                    params[i] = new Param(paramKey, URLDecoder.decode(paramValue, "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            AsyncHttpPaginatedQuery.this.exec(params, callback);
        }

        @Override
        public boolean hasFirst() {
            return this.relFirst != null;
        }

        @Override
        public boolean hasCurrent() {
            return this.relCurrent != null;
        }

        @Override
        public boolean hasNext() {
            return this.relNext != null;
        }
    }
}

