/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import io.ably.lib.http.Http;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.Stats;
import io.ably.lib.util.Serialisation;
import java.io.UnsupportedEncodingException;

public class StatsReader {
    public static Http.BodyHandler<Stats> statsResponseHandler = new Http.BodyHandler<Stats>(){

        public Stats[] handleResponseBody(String contentType, byte[] body) throws AblyException {
            if ("application/json".equals(contentType)) {
                return StatsReader.readJson(body);
            }
            return null;
        }
    };

    public static Stats[] readJson(byte[] jsonBytes) throws AblyException {
        try {
            return StatsReader.readJson(new String(jsonBytes, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw AblyException.fromThrowable(e);
        }
    }

    public static Stats[] readJson(String packed) throws AblyException {
        return (Stats[])Serialisation.gson.fromJson(packed, Stats[].class);
    }
}

