/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.ably.lib.types.BaseMessage;
import io.ably.lib.util.Log;
import java.io.IOException;
import java.lang.reflect.Type;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class Message
extends BaseMessage {
    public String name;
    private static final String TAG = Message.class.getName();

    public Message() {
    }

    public Message(String name, Object data) {
        this(name, data, null);
    }

    public Message(String name, Object data, String clientId) {
        this.name = name;
        this.clientId = clientId;
        this.data = data;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[Message");
        super.getDetails(result);
        if (this.name != null) {
            result.append(" name=").append(this.name);
        }
        result.append(']');
        return result.toString();
    }

    void writeMsgpack(MessagePacker packer) throws IOException {
        int fieldCount = super.countFields();
        if (this.name != null) {
            ++fieldCount;
        }
        packer.packMapHeader(fieldCount);
        super.writeFields(packer);
        if (this.name != null) {
            packer.packString("name");
            packer.packString(this.name);
        }
    }

    Message readMsgpack(MessageUnpacker unpacker) throws IOException {
        int fieldCount = unpacker.unpackMapHeader();
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = unpacker.unpackString().intern();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            if (super.readField(unpacker, fieldName, fieldFormat)) continue;
            if (fieldName == "name") {
                this.name = unpacker.unpackString();
                continue;
            }
            Log.v(TAG, "Unexpected field: " + fieldName);
            unpacker.skipValue();
        }
        return this;
    }

    static Message fromMsgpack(MessageUnpacker unpacker) throws IOException {
        return new Message().readMsgpack(unpacker);
    }

    public static class Serializer
    extends BaseMessage.Serializer
    implements JsonSerializer<Message> {
        public JsonElement serialize(Message message, Type typeOfMessage, JsonSerializationContext ctx) {
            JsonObject json = (JsonObject)super.serialize(message, typeOfMessage, ctx);
            if (message.name != null) {
                json.addProperty("name", message.name);
            }
            return json;
        }
    }
}

