/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.realtime;

import io.ably.lib.realtime.AblyRealtime;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.realtime.ConnectionEvent;
import io.ably.lib.realtime.ConnectionState;
import io.ably.lib.realtime.ConnectionStateListener;
import io.ably.lib.transport.ConnectionManager;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.util.EventEmitter;

public class Connection
extends EventEmitter<ConnectionEvent, ConnectionStateListener> {
    public ConnectionState state;
    public ErrorInfo reason;
    public String key;
    public String recoveryKey;
    public String id;
    public long serial;
    final AblyRealtime ably;
    public final ConnectionManager connectionManager;

    public void connect() {
        this.connectionManager.connect();
    }

    public void ping(CompletionListener listener) {
        this.connectionManager.ping(listener);
    }

    public void close() {
        this.key = null;
        this.recoveryKey = null;
        this.connectionManager.close();
    }

    Connection(AblyRealtime ably) {
        this.ably = ably;
        this.state = ConnectionState.initialized;
        this.connectionManager = new ConnectionManager(ably, this);
    }

    public void onConnectionStateChange(ConnectionStateListener.ConnectionStateChange stateChange) {
        this.state = stateChange.current;
        this.reason = stateChange.reason;
        this.emit(this.state, stateChange);
    }

    @Override
    protected void apply(ConnectionStateListener listener, ConnectionEvent event, Object ... args) {
        listener.onConnectionStateChanged((ConnectionStateListener.ConnectionStateChange)args[0]);
    }

    public void emitUpdate(ErrorInfo errorInfo) {
        if (this.state == ConnectionState.connected) {
            this.emit(ConnectionEvent.update, ConnectionStateListener.ConnectionStateChange.createUpdateEvent(errorInfo));
        }
    }

    @Deprecated
    public void emit(ConnectionState state, ConnectionStateListener.ConnectionStateChange stateChange) {
        super.emit(state.getConnectionEvent(), stateChange);
    }

    @Override
    @Deprecated
    public void on(ConnectionState state, ConnectionStateListener listener) {
        super.on(state.getConnectionEvent(), listener);
    }

    @Override
    @Deprecated
    public void once(ConnectionState state, ConnectionStateListener listener) {
        super.once(state.getConnectionEvent(), listener);
    }
}

