/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.rest;

import io.ably.lib.http.AsyncHttp;
import io.ably.lib.http.AsyncPaginatedQuery;
import io.ably.lib.http.Http;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.http.PaginatedQuery;
import io.ably.lib.rest.Auth;
import io.ably.lib.rest.Channel;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.types.Stats;
import io.ably.lib.types.StatsReader;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.util.Collection;

public class AblyRest {
    public final ClientOptions options;
    final String clientId;
    public final Http http;
    public final AsyncHttp asyncHttp;
    public final Auth auth;
    public final Channels channels;

    public AblyRest(String key) throws AblyException {
        this(new ClientOptions(key));
    }

    public AblyRest(ClientOptions options) throws AblyException {
        if (options == null) {
            String msg = "no options provided";
            Log.e(this.getClass().getName(), msg);
            throw AblyException.fromErrorInfo(new ErrorInfo(msg, 400, 40000));
        }
        this.options = options;
        Log.setLevel(options.logLevel);
        Log.setHandler(options.logHandler);
        Log.i(this.getClass().getName(), "started");
        this.clientId = options.clientId;
        this.auth = new Auth(this, options);
        this.http = new Http(options, this.auth);
        this.asyncHttp = new AsyncHttp(this.http);
        this.channels = new Channels();
    }

    public long time() throws AblyException {
        return this.http.get("/time", HttpUtils.defaultAcceptHeaders(false), null, new Http.ResponseHandler<Long>(){

            @Override
            public Long handleResponse(int statusCode, String contentType, Collection<String> linkHeaders, byte[] body) throws AblyException {
                return ((Long[])Serialisation.gson.fromJson(new String(body), Long[].class))[0];
            }
        });
    }

    public void timeAsync(Callback<Long> callback) {
        this.asyncHttp.get("/time", HttpUtils.defaultAcceptHeaders(false), null, new Http.ResponseHandler<Long>(){

            @Override
            public Long handleResponse(int statusCode, String contentType, Collection<String> linkHeaders, byte[] body) throws AblyException {
                return ((Long[])Serialisation.gson.fromJson(new String(body), Long[].class))[0];
            }
        }, callback);
    }

    public PaginatedResult<Stats> stats(Param[] params) throws AblyException {
        return new PaginatedQuery<Stats>(this.http, "/stats", HttpUtils.defaultAcceptHeaders(false), params, StatsReader.statsResponseHandler).get();
    }

    public void statsAsync(Param[] params, Callback<AsyncPaginatedResult<Stats>> callback) {
        new AsyncPaginatedQuery<Stats>(this.asyncHttp, "/stats", HttpUtils.defaultAcceptHeaders(false), params, StatsReader.statsResponseHandler).get(callback);
    }

    public void onAuthUpdated() {
    }

    public class Channels {
        public Channel get(String channelName) {
            try {
                return this.get(channelName, null);
            }
            catch (AblyException e) {
                return null;
            }
        }

        public Channel get(String channelName, ChannelOptions channelOptions) throws AblyException {
            return new Channel(AblyRest.this, channelName, channelOptions);
        }
    }
}

