/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.http;

import io.ably.lib.http.Http;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Param;
import io.ably.lib.util.Log;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AsyncHttp
extends ThreadPoolExecutor {
    private final Http http;
    private static final int DEFAULT_POOL_SIZE = 0;
    private static final int MAX_POOL_SIZE = 64;
    private static final long KEEP_ALIVE_TIME = 2000L;
    private static final long SHUTDOWN_TIME = 5000L;
    private static final String TAG = AsyncHttp.class.getName();

    public <T> Future<T> get(String path, Param[] headers, Param[] params, Http.ResponseHandler<T> responseHandler, Callback<T> callback) {
        return this.ablyHttpExecuteWithFallback(path, "GET", headers, params, null, responseHandler, callback);
    }

    public <T> Future<T> post(String path, Param[] headers, Param[] params, Http.RequestBody requestBody, Http.ResponseHandler<T> responseHandler, Callback<T> callback) {
        return this.ablyHttpExecuteWithFallback(path, "POST", headers, params, requestBody, responseHandler, callback);
    }

    public <T> Future<T> del(String path, Param[] headers, Param[] params, Http.ResponseHandler<T> responseHandler, Callback<T> callback) {
        return this.ablyHttpExecuteWithFallback(path, "DELETE", headers, params, null, responseHandler, callback);
    }

    public AsyncHttp(Http http) {
        super(0, 64, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.http = http;
    }

    public void setThreadPoolSize(int size) {
        this.setCorePoolSize(size);
    }

    public <T> Future<T> httpExecute(URL url, String method, Param[] headers, Http.RequestBody requestBody, boolean withCredentials, Http.ResponseHandler<T> responseHandler, Callback<T> callback) {
        UrlRequest request = new UrlRequest(url, method, headers, null, requestBody, withCredentials, responseHandler, callback);
        this.execute(request);
        return request;
    }

    public <T> Future<T> ablyHttpExecuteWithFallback(String path, String method, Param[] headers, Param[] params, Http.RequestBody requestBody, Http.ResponseHandler<T> responseHandler, Callback<T> callback) {
        AblyRequestWithFallback request = new AblyRequestWithFallback(path, method, headers, null, requestBody, responseHandler, callback);
        this.execute(request);
        return request;
    }

    public <T> Future<T> ablyHttpExecuteWithRetry(String host, String path, String method, Param[] headers, Param[] params, Http.RequestBody requestBody, Http.ResponseHandler<T> responseHandler, Callback<T> callback) {
        AblyRequestWithRetry request = new AblyRequestWithRetry(host, path, method, headers, null, requestBody, responseHandler, callback);
        this.execute(request);
        return request;
    }

    public void dispose() {
        this.shutdown();
        try {
            this.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.shutdownNow();
        }
    }

    private abstract class AsyncRequest<T>
    implements Future<T> {
        protected HttpURLConnection conn;
        protected T result;
        protected ErrorInfo err;
        protected final String method;
        protected final Param[] headers;
        protected final Param[] params;
        protected final Http.RequestBody requestBody;
        protected final Http.ResponseHandler<T> responseHandler;
        protected final Callback<T> callback;
        protected boolean isCancelled = false;
        protected boolean isDone = false;

        private AsyncRequest(String method, Param[] headers, Param[] params, Http.RequestBody requestBody, boolean withCredentials, Http.ResponseHandler<T> responseHandler, Callback<T> callback) {
            this.method = method;
            this.headers = headers;
            this.params = params;
            this.requestBody = requestBody;
            this.responseHandler = responseHandler;
            this.callback = callback;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.isCancelled = true;
            return this.disposeConnection();
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled;
        }

        @Override
        public boolean isDone() {
            return this.isDone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() throws InterruptedException, ExecutionException {
            AsyncRequest asyncRequest = this;
            synchronized (asyncRequest) {
                while (!this.isDone) {
                    this.wait();
                }
                if (this.err != null) {
                    throw new ExecutionException(AblyException.fromErrorInfo(this.err));
                }
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long remaining = unit.toMillis(timeout);
            long deadline = System.currentTimeMillis() + remaining;
            AsyncRequest asyncRequest = this;
            synchronized (asyncRequest) {
                while (remaining > 0L) {
                    this.wait(remaining);
                    if (this.isDone) break;
                    remaining = deadline - System.currentTimeMillis();
                }
                if (!this.isDone) {
                    throw new TimeoutException();
                }
                if (this.err != null) {
                    throw new ExecutionException(AblyException.fromErrorInfo(this.err));
                }
            }
            return this.result;
        }

        protected T httpExecuteWithRetry(URL url) throws AblyException {
            return AsyncHttp.this.http.httpExecuteWithRetry(url, this.method, this.headers, this.requestBody, this.responseHandler, false);
        }

        protected T httpExecuteWithRetry(String host, String path, boolean allowAblyAuth) throws AblyException {
            URL url = Http.buildURL(((AsyncHttp)AsyncHttp.this).http.scheme, host, ((AsyncHttp)AsyncHttp.this).http.port, path, this.params);
            return AsyncHttp.this.http.httpExecuteWithRetry(url, this.method, this.headers, this.requestBody, this.responseHandler, allowAblyAuth);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setResult(T result) {
            AsyncRequest asyncRequest = this;
            synchronized (asyncRequest) {
                this.result = result;
                this.isDone = true;
                this.notifyAll();
            }
            if (this.callback != null) {
                this.callback.onSuccess(result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setError(ErrorInfo err) {
            AsyncRequest asyncRequest = this;
            synchronized (asyncRequest) {
                this.err = err;
                this.isDone = true;
                this.notifyAll();
            }
            if (this.callback != null) {
                this.callback.onError(err);
            }
        }

        protected synchronized boolean disposeConnection() {
            boolean hasConnection;
            boolean bl = hasConnection = this.conn != null;
            if (hasConnection) {
                this.conn.disconnect();
                this.conn = null;
            }
            return hasConnection;
        }
    }

    private class AblyRequestWithFallback<T>
    extends AsyncRequest<T>
    implements Runnable {
        private final String path;

        private AblyRequestWithFallback(String path, String method, Param[] headers, Param[] params, Http.RequestBody requestBody, Http.ResponseHandler<T> responseHandler, Callback<T> callback) {
            super(method, headers, params, requestBody, true, responseHandler, callback);
            this.path = path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int retryCountRemaining;
            String candidateHost = AsyncHttp.this.http.getHost();
            int n = retryCountRemaining = ((AsyncHttp)AsyncHttp.this).http.hosts.getFallback(candidateHost) != null ? ((AsyncHttp)AsyncHttp.this).http.options.httpMaxRetryCount : 0;
            while (!this.isCancelled) {
                try {
                    this.result = this.httpExecuteWithRetry(candidateHost, this.path, true);
                    this.setResult(this.result);
                    break;
                }
                catch (AblyException.HostFailedException e) {
                    if (--retryCountRemaining < 0) {
                        this.setError(e.errorInfo);
                        break;
                    }
                    Log.d(TAG, "Connection failed to host `" + candidateHost + "`. Searching for new host...");
                    candidateHost = ((AsyncHttp)AsyncHttp.this).http.hosts.getFallback(candidateHost);
                    if (candidateHost == null) {
                        this.setError(e.errorInfo);
                        break;
                    }
                    Log.d(TAG, "Switched to `" + candidateHost + "`.");
                }
                catch (AblyException e) {
                    this.setError(e.errorInfo);
                    break;
                }
                finally {
                    this.disposeConnection();
                }
            }
        }
    }

    private class AblyRequestWithRetry<T>
    extends AsyncRequest<T>
    implements Runnable {
        private final String host;
        private final String path;

        private AblyRequestWithRetry(String host, String path, String method, Param[] headers, Param[] params, Http.RequestBody requestBody, Http.ResponseHandler<T> responseHandler, Callback<T> callback) {
            super(method, headers, params, requestBody, true, responseHandler, callback);
            this.host = host;
            this.path = path;
        }

        @Override
        public void run() {
            try {
                this.result = this.httpExecuteWithRetry(this.host, this.path, true);
                this.setResult(this.result);
            }
            catch (AblyException e) {
                this.setError(e.errorInfo);
            }
            finally {
                this.disposeConnection();
            }
        }
    }

    private class UrlRequest<T>
    extends AsyncRequest<T>
    implements Runnable {
        private final URL url;

        private UrlRequest(URL url, String method, Param[] headers, Param[] params, Http.RequestBody requestBody, boolean withCredentials, Http.ResponseHandler<T> responseHandler, Callback<T> callback) {
            super(method, headers, params, requestBody, withCredentials, responseHandler, callback);
            this.url = url;
        }

        @Override
        public void run() {
            try {
                Object result = this.httpExecuteWithRetry(this.url);
                this.setResult(result);
            }
            catch (AblyException e) {
                this.setError(e.errorInfo);
            }
            finally {
                this.disposeConnection();
            }
        }
    }
}

