/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.rest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.ably.lib.http.Http;
import io.ably.lib.http.TokenAuth;
import io.ably.lib.rest.AblyRest;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.Capability;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Param;
import io.ably.lib.util.Base64Coder;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Auth {
    private final AblyRest ably;
    private final AuthMethod method;
    private AuthOptions authOptions;
    private TokenParams tokenParams;
    private String basicCredentials;
    private TokenAuth tokenAuth;

    public TokenDetails authorise(AuthOptions options, TokenParams params) throws AblyException {
        options = options == null ? this.authOptions : options.merge(this.authOptions);
        TokenParams tokenParams = params = params == null ? this.tokenParams : params.merge(this.tokenParams);
        if (options != null) {
            this.authOptions = options.storedValues();
        }
        if (params != null) {
            this.tokenParams = params.storedValues();
        }
        options = options == null ? this.authOptions : options.copy();
        params = params == null ? this.tokenParams : params.copy();
        TokenDetails tokenDetails = this.tokenAuth.authorise(options, params);
        if (options != null && options.force) {
            this.ably.onAuthUpdated();
        }
        return tokenDetails;
    }

    public TokenDetails requestToken(TokenParams params, AuthOptions tokenOptions) throws AblyException {
        TokenRequest signedTokenRequest;
        tokenOptions = tokenOptions == null ? this.authOptions : tokenOptions.merge(this.authOptions);
        params = params == null ? this.tokenParams : params.merge(this.tokenParams);
        tokenOptions = tokenOptions == null ? this.authOptions : tokenOptions.copy();
        TokenParams tokenParams = params = params == null ? this.tokenParams : params.copy();
        if (params.clientId == null) {
            params.clientId = this.ably.clientId;
        }
        params.capability = Capability.c14n(params.capability);
        if (tokenOptions.authCallback != null) {
            Log.i("Auth.requestToken()", "using token auth with auth_callback");
            try {
                Object authCallbackResponse = tokenOptions.authCallback.getTokenRequest(params);
                if (authCallbackResponse instanceof String) {
                    return new TokenDetails((String)authCallbackResponse);
                }
                if (authCallbackResponse instanceof TokenDetails) {
                    return (TokenDetails)authCallbackResponse;
                }
                if (!(authCallbackResponse instanceof TokenRequest)) {
                    throw AblyException.fromErrorInfo(new ErrorInfo("Invalid authCallback response", 40000, 400));
                }
                signedTokenRequest = (TokenRequest)authCallbackResponse;
            }
            catch (AblyException e) {
                ErrorInfo errorInfo = e.errorInfo;
                if (errorInfo.code == 0) {
                    errorInfo.code = 40170;
                }
                if (errorInfo.statusCode == 0) {
                    errorInfo.statusCode = 401;
                }
                throw e;
            }
        }
        if (tokenOptions.authUrl != null) {
            Log.i("Auth.requestToken()", "using token auth with auth_url");
            List<Param> tokenParams2 = params.asParams();
            if (tokenOptions.authParams != null) {
                tokenParams2.addAll(Arrays.asList(tokenOptions.authParams));
            }
            Param[] requestParams = tokenParams2.toArray(new Param[tokenParams2.size()]);
            Object authUrlResponse = null;
            try {
                authUrlResponse = this.ably.http.getUri(tokenOptions.authUrl, tokenOptions.authHeaders, requestParams, new Http.ResponseHandler<Object>(){

                    @Override
                    public Object handleResponse(int statusCode, String contentType, Collection<String> linkHeaders, byte[] body) throws AblyException {
                        try {
                            JsonElement json;
                            if (contentType != null) {
                                if (contentType.startsWith("text/plain")) {
                                    String token = new String(body);
                                    return new TokenDetails(token);
                                }
                                if (!contentType.startsWith("application/json")) {
                                    throw AblyException.fromErrorInfo(new ErrorInfo("Unacceptable content type from auth callback", 406, 40170));
                                }
                            }
                            if (!((json = Serialisation.gsonParser.parse(new String(body))) instanceof JsonObject)) {
                                throw AblyException.fromErrorInfo(new ErrorInfo("Unexpected response type from auth callback", 406, 40170));
                            }
                            JsonObject jsonObject = (JsonObject)json;
                            if (jsonObject.has("issued")) {
                                return TokenDetails.fromJSON(jsonObject);
                            }
                            return TokenRequest.fromJSON(jsonObject);
                        }
                        catch (JsonParseException e) {
                            throw AblyException.fromErrorInfo(new ErrorInfo("Unable to parse response from auth callback", 406, 40170));
                        }
                    }
                });
            }
            catch (AblyException e) {
                ErrorInfo errorInfo = e.errorInfo;
                if (errorInfo.code == 0) {
                    errorInfo.code = 40170;
                }
                if (errorInfo.statusCode == 0) {
                    errorInfo.statusCode = 401;
                }
                throw e;
            }
            if (authUrlResponse instanceof TokenDetails) {
                return (TokenDetails)authUrlResponse;
            }
            signedTokenRequest = (TokenRequest)authUrlResponse;
        } else if (tokenOptions.key != null) {
            Log.i("Auth.requestToken()", "using token auth with client-side signing");
            signedTokenRequest = this.createTokenRequest(tokenOptions, params);
        } else {
            throw AblyException.fromErrorInfo(new ErrorInfo("Auth.requestToken(): options must include valid authentication parameters", 400, 40000));
        }
        String tokenPath = "/keys/" + signedTokenRequest.keyName + "/requestToken";
        return this.ably.http.post(tokenPath, tokenOptions.authHeaders, tokenOptions.authParams, new Http.JSONRequestBody(signedTokenRequest.asJSON().toString()), new Http.ResponseHandler<TokenDetails>(){

            @Override
            public TokenDetails handleResponse(int statusCode, String contentType, Collection<String> linkHeaders, byte[] body) throws AblyException {
                try {
                    String jsonText = new String(body);
                    JsonObject json = (JsonObject)Serialisation.gsonParser.parse(jsonText);
                    return TokenDetails.fromJSON(json);
                }
                catch (JsonParseException e) {
                    throw AblyException.fromThrowable(e);
                }
            }
        });
    }

    public TokenRequest createTokenRequest(AuthOptions options, TokenParams params) throws AblyException {
        String clientIdText;
        String capabilityText;
        options = options == null ? this.authOptions : options.merge(this.authOptions);
        params = params == null ? this.tokenParams : params.merge(this.tokenParams);
        options = options == null ? this.authOptions : options.copy();
        TokenParams tokenParams = params = params == null ? this.tokenParams : params.copy();
        if (params.capability != null) {
            params.capability = Capability.c14n(params.capability);
        }
        TokenRequest request = new TokenRequest(params);
        String key = options.key;
        if (key == null) {
            throw AblyException.fromErrorInfo(new ErrorInfo("No key specified", 401, 40101));
        }
        String[] keyParts = key.split(":");
        if (keyParts.length != 2) {
            throw AblyException.fromErrorInfo(new ErrorInfo("Invalid key specified", 401, 40101));
        }
        String keyName = keyParts[0];
        String keySecret = keyParts[1];
        if (request.keyName == null) {
            request.keyName = keyName;
        } else if (!request.keyName.equals(keyName)) {
            throw AblyException.fromErrorInfo(new ErrorInfo("Incompatible keys specified", 401, 40102));
        }
        String ttlText = request.ttl == 0L ? "" : String.valueOf(request.ttl);
        String string = capabilityText = request.capability == null ? "" : request.capability;
        if (request.clientId == null) {
            request.clientId = this.ably.clientId;
        }
        String string2 = clientIdText = request.clientId == null ? "" : request.clientId;
        if (request.timestamp == 0L) {
            request.timestamp = options.queryTime ? this.ably.time() : Auth.timestamp();
        }
        request.nonce = Auth.random();
        String signText = request.keyName + '\n' + ttlText + '\n' + capabilityText + '\n' + clientIdText + '\n' + request.timestamp + '\n' + request.nonce + '\n';
        request.mac = Auth.hmac(signText, keySecret);
        Log.i("Auth.getTokenRequest()", "generated signed request");
        return request;
    }

    public AuthMethod getAuthMethod() {
        return this.method;
    }

    public String getBasicCredentials() {
        return this.method == AuthMethod.basic ? this.basicCredentials : null;
    }

    public Param[] getAuthParams() throws AblyException {
        Param[] params = null;
        switch (this.method) {
            case basic: {
                params = new Param[]{new Param("key", this.authOptions.key)};
                break;
            }
            case token: {
                this.authorise(null, null);
                params = new Param[]{new Param("access_token", this.tokenAuth.getTokenDetails().token)};
            }
        }
        return params;
    }

    public AuthOptions getAuthOptions() {
        return this.authOptions.copy();
    }

    public TokenAuth getTokenAuth() {
        return this.tokenAuth;
    }

    public void onAuthError(ErrorInfo err) {
        if (err.code == 40140) {
            this.tokenAuth.clear();
        }
    }

    public static long timestamp() {
        return System.currentTimeMillis();
    }

    Auth(AblyRest ably, ClientOptions options) throws AblyException {
        this.ably = ably;
        this.authOptions = options;
        TokenParams tokenParams = this.tokenParams = options.defaultTokenParams != null ? options.defaultTokenParams : new TokenParams();
        if (this.authOptions.key != null && options.clientId == null && !options.useTokenAuth) {
            Log.i("Auth()", "anonymous, using basic auth");
            this.method = AuthMethod.basic;
            this.basicCredentials = this.authOptions.key;
            return;
        }
        this.method = AuthMethod.token;
        this.tokenAuth = new TokenAuth(this);
        if (this.authOptions.token != null) {
            this.authOptions.tokenDetails = new TokenDetails(this.authOptions.token);
        }
        if (this.authOptions.tokenDetails != null) {
            this.tokenAuth.setTokenDetails(this.authOptions.tokenDetails);
        }
        if (this.authOptions.authCallback != null) {
            Log.i("Auth()", "using token auth with authCallback");
        } else if (this.authOptions.authUrl != null) {
            Log.i("Auth()", "using token auth with authUrl");
        } else if (this.authOptions.key != null) {
            Log.i("Auth()", "using token auth with client-side signing");
        } else if (this.authOptions.tokenDetails != null) {
            Log.i("Auth()", "using token auth with supplied token only");
        } else {
            Log.i("Auth()", "no authentication parameters supplied");
        }
    }

    private static String random() {
        return String.format("%016d", (long)(Math.random() * 1.0E16));
    }

    private static final String hmac(String text, String key) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key.getBytes(), "HmacSHA256"));
            return new String(Base64Coder.encode(mac.doFinal(text.getBytes())));
        }
        catch (GeneralSecurityException e) {
            Log.e("Auth.hmac", "Unexpected exception", e);
            return null;
        }
    }

    public static interface TokenCallback {
        public Object getTokenRequest(TokenParams var1) throws AblyException;
    }

    public static class TokenRequest
    extends TokenParams {
        public String keyName;
        public String nonce;
        public String mac;

        TokenRequest() {
        }

        TokenRequest(TokenParams params) {
            this.ttl = params.ttl;
            this.capability = params.capability;
            this.clientId = params.clientId;
            this.timestamp = params.timestamp;
        }

        public static TokenRequest fromJSON(JsonObject json) {
            return (TokenRequest)Serialisation.gson.fromJson((JsonElement)json, TokenRequest.class);
        }

        public JsonObject asJSON() {
            return (JsonObject)Serialisation.gson.toJsonTree((Object)this);
        }
    }

    public static class TokenParams {
        public long ttl;
        public String capability;
        public String clientId;
        public long timestamp;

        public List<Param> asParams() {
            ArrayList<Param> params = new ArrayList<Param>();
            if (this.ttl > 0L) {
                params.add(new Param("ttl", String.valueOf(this.ttl)));
            }
            if (this.capability != null) {
                params.add(new Param("capability", this.capability));
            }
            if (this.clientId != null) {
                params.add(new Param("client_id", this.clientId));
            }
            if (this.timestamp > 0L) {
                params.add(new Param("timestamp", String.valueOf(this.timestamp)));
            }
            return params;
        }

        private TokenParams storedValues() {
            TokenParams result = new TokenParams();
            result.ttl = this.ttl;
            result.capability = this.capability;
            result.clientId = this.clientId;
            return result;
        }

        private TokenParams copy() {
            TokenParams result = new TokenParams();
            result.ttl = this.ttl;
            result.capability = this.capability;
            result.clientId = this.clientId;
            result.timestamp = this.timestamp;
            return result;
        }

        public TokenParams merge(TokenParams defaults) {
            if (this.ttl == 0L) {
                this.ttl = defaults.ttl;
            }
            if (this.capability == null) {
                this.capability = defaults.capability;
            }
            if (this.clientId == null) {
                this.clientId = defaults.clientId;
            }
            if (this.timestamp == 0L) {
                this.timestamp = defaults.timestamp;
            }
            return this;
        }
    }

    public static class TokenDetails {
        public String token;
        public long expires;
        public long issued;
        public String capability;
        public String clientId;

        public TokenDetails() {
        }

        public TokenDetails(String token) {
            this.token = token;
        }

        public static TokenDetails fromJSON(JsonObject json) {
            return (TokenDetails)Serialisation.gson.fromJson((JsonElement)json, TokenDetails.class);
        }
    }

    public static class AuthOptions {
        public TokenCallback authCallback;
        public String authUrl;
        public boolean force;
        public String key;
        public String token;
        public TokenDetails tokenDetails;
        public Param[] authHeaders;
        public Param[] authParams;
        public boolean queryTime;
        public boolean useTokenAuth;

        public AuthOptions() {
        }

        public AuthOptions(String key) throws AblyException {
            if (key == null) {
                throw AblyException.fromErrorInfo(new ErrorInfo("key string cannot be null", 40000, 400));
            }
            if (key.indexOf(58) > -1) {
                this.key = key;
            } else {
                this.token = key;
            }
        }

        public AuthOptions merge(AuthOptions defaults) {
            if (this.authCallback == null) {
                this.authCallback = defaults.authCallback;
            }
            if (this.authUrl == null) {
                this.authUrl = defaults.authUrl;
            }
            if (this.key == null) {
                this.key = defaults.key;
            }
            if (this.authHeaders == null) {
                this.authHeaders = defaults.authHeaders;
            }
            if (this.authParams == null) {
                this.authParams = defaults.authParams;
            }
            this.queryTime |= defaults.queryTime;
            return this;
        }

        private AuthOptions storedValues() {
            AuthOptions result = new AuthOptions();
            result.key = this.key;
            result.authUrl = this.authUrl;
            result.authParams = this.authParams;
            result.authHeaders = this.authHeaders;
            result.token = this.token;
            result.tokenDetails = this.tokenDetails;
            result.authCallback = this.authCallback;
            return result;
        }

        private AuthOptions copy() {
            AuthOptions result = new AuthOptions();
            result.key = this.key;
            result.authUrl = this.authUrl;
            result.authParams = this.authParams;
            result.authHeaders = this.authHeaders;
            result.token = this.token;
            result.tokenDetails = this.tokenDetails;
            result.authCallback = this.authCallback;
            result.queryTime = this.queryTime;
            result.force = this.force;
            return result;
        }
    }

    public static enum AuthMethod {
        basic,
        token;

    }
}

