/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import java.io.IOException;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessageUnpacker;

public class ConnectionDetails {
    public String clientId;
    public String connectionKey;
    public String serverId;
    public Long maxMessageSize;
    public Long maxInboundRate;
    public Long maxFrameSize;
    public Long maxIdleInterval = 20000L;

    ConnectionDetails() {
    }

    ConnectionDetails readMsgpack(MessageUnpacker unpacker) throws IOException {
        int fieldCount = unpacker.unpackMapHeader();
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = unpacker.unpackString().intern();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            if (fieldName == "clientId") {
                this.clientId = unpacker.unpackString();
                continue;
            }
            if (fieldName == "connectionKey") {
                this.connectionKey = unpacker.unpackString();
                continue;
            }
            if (fieldName == "serverId") {
                this.serverId = unpacker.unpackString();
                continue;
            }
            if (fieldName == "maxMessageSize") {
                this.maxMessageSize = unpacker.unpackLong();
                continue;
            }
            if (fieldName == "maxInboundRate") {
                this.maxInboundRate = unpacker.unpackLong();
                continue;
            }
            if (fieldName == "maxFrameSize") {
                this.maxFrameSize = unpacker.unpackLong();
                continue;
            }
            if (fieldName == "maxIdleInterval") {
                this.maxIdleInterval = unpacker.unpackLong();
                continue;
            }
            System.out.println("Unexpected field: " + fieldName);
            unpacker.skipValue();
        }
        return this;
    }

    static ConnectionDetails fromMsgpack(MessageUnpacker unpacker) throws IOException {
        return new ConnectionDetails().readMsgpack(unpacker);
    }
}

