/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.rest;

import io.ably.lib.http.AsyncPaginatedQuery;
import io.ably.lib.http.Http;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.http.PaginatedQuery;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.rest.AblyRest;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageSerializer;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.types.PresenceMessage;
import io.ably.lib.types.PresenceSerializer;

public class Channel {
    public final String name;
    public final Presence presence;
    private final AblyRest ably;
    private final String basePath;
    private ChannelOptions options;

    public void publish(String name, Object data) throws AblyException {
        Message message = new Message(name, data);
        message.encode(this.options);
        Http.RequestBody requestBody = this.ably.options.useBinaryProtocol ? MessageSerializer.asMsgpackRequest(message) : MessageSerializer.asJSONRequest(message);
        this.ably.http.post(this.basePath + "/messages", HttpUtils.defaultAcceptHeaders(this.ably.options.useBinaryProtocol), null, requestBody, null);
    }

    public void publish(Message[] messages) throws AblyException {
        for (Message message : messages) {
            message.encode(this.options);
        }
        Http.RequestBody requestBody = this.ably.options.useBinaryProtocol ? MessageSerializer.asMsgpackRequest(messages) : MessageSerializer.asJSONRequest(messages);
        this.ably.http.post(this.basePath + "/messages", HttpUtils.defaultAcceptHeaders(this.ably.options.useBinaryProtocol), null, requestBody, null);
    }

    public void publishAsync(Message[] messages, final CompletionListener listener) {
        try {
            for (Message message : messages) {
                message.encode(this.options);
            }
        }
        catch (AblyException e) {
            listener.onError(e.errorInfo);
            return;
        }
        Http.RequestBody requestBody = this.ably.options.useBinaryProtocol ? MessageSerializer.asMsgpackRequest(messages) : MessageSerializer.asJSONRequest(messages);
        this.ably.asyncHttp.post(this.basePath + "/messages", HttpUtils.defaultAcceptHeaders(this.ably.options.useBinaryProtocol), null, requestBody, null, new Callback<Void>(){

            @Override
            public void onSuccess(Void result) {
                listener.onSuccess();
            }

            @Override
            public void onError(ErrorInfo reason) {
                listener.onError(reason);
            }
        });
    }

    public PaginatedResult<Message> history(Param[] params) throws AblyException {
        Http.BodyHandler<Message> bodyHandler = MessageSerializer.getMessageResponseHandler(this.options);
        return new PaginatedQuery<Message>(this.ably.http, this.basePath + "/messages", HttpUtils.defaultAcceptHeaders(this.ably.options.useBinaryProtocol), params, bodyHandler).get();
    }

    public void historyAsync(Param[] params, Callback<AsyncPaginatedResult<Message>> callback) {
        Http.BodyHandler<Message> bodyHandler = MessageSerializer.getMessageResponseHandler(this.options);
        new AsyncPaginatedQuery<Message>(this.ably.asyncHttp, this.basePath + "/messages", HttpUtils.defaultAcceptHeaders(this.ably.options.useBinaryProtocol), params, bodyHandler).get(callback);
    }

    Channel(AblyRest ably, String name, ChannelOptions options) throws AblyException {
        this.ably = ably;
        this.name = name;
        this.options = options;
        this.basePath = "/channels/" + HttpUtils.encodeURIComponent(name);
        this.presence = new Presence();
    }

    public class Presence {
        public PaginatedResult<PresenceMessage> get(Param[] params) throws AblyException {
            Http.BodyHandler<PresenceMessage> bodyHandler = PresenceSerializer.getPresenceResponseHandler(Channel.this.options);
            return new PaginatedQuery<PresenceMessage>(((Channel)Channel.this).ably.http, Channel.this.basePath + "/presence", HttpUtils.defaultAcceptHeaders(((Channel)Channel.this).ably.options.useBinaryProtocol), params, bodyHandler).get();
        }

        public void getAsync(Param[] params, Callback<AsyncPaginatedResult<PresenceMessage>> callback) {
            Http.BodyHandler<PresenceMessage> bodyHandler = PresenceSerializer.getPresenceResponseHandler(Channel.this.options);
            new AsyncPaginatedQuery<PresenceMessage>(((Channel)Channel.this).ably.asyncHttp, Channel.this.basePath + "/presence", HttpUtils.defaultAcceptHeaders(((Channel)Channel.this).ably.options.useBinaryProtocol), params, bodyHandler).get(callback);
        }

        public PaginatedResult<PresenceMessage> history(Param[] params) throws AblyException {
            Http.BodyHandler<PresenceMessage> bodyHandler = PresenceSerializer.getPresenceResponseHandler(Channel.this.options);
            return new PaginatedQuery<PresenceMessage>(((Channel)Channel.this).ably.http, Channel.this.basePath + "/presence/history", HttpUtils.defaultAcceptHeaders(((Channel)Channel.this).ably.options.useBinaryProtocol), params, bodyHandler).get();
        }

        public void historyAsync(Param[] params, Callback<AsyncPaginatedResult<PresenceMessage>> callback) {
            Http.BodyHandler<PresenceMessage> bodyHandler = PresenceSerializer.getPresenceResponseHandler(Channel.this.options);
            new AsyncPaginatedQuery<PresenceMessage>(((Channel)Channel.this).ably.asyncHttp, Channel.this.basePath + "/presence/history", HttpUtils.defaultAcceptHeaders(((Channel)Channel.this).ably.options.useBinaryProtocol), params, bodyHandler).get(callback);
        }
    }
}

