/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.transport;

import io.ably.lib.transport.Defaults;
import java.util.List;

public class Hosts {
    private static final List<String> FALLBACKS = Defaults.HOST_FALLBACKS;
    private static final String REST_PROD_HOST = "rest.ably.io";
    private static final String REALTIME_PROD_HOST = "realtime.ably.io";

    private Hosts() {
    }

    public static String getFallback(String host) {
        int size = FALLBACKS.size();
        int indexCurrent = FALLBACKS.indexOf(host);
        int indexNext = indexCurrent + 1;
        if (indexNext >= size) {
            return null;
        }
        return FALLBACKS.get(indexNext);
    }

    public static boolean isFallback(String host) {
        return FALLBACKS.indexOf(host) >= 0;
    }

    public static boolean isRestFallbackSupported(String host) {
        return host.equalsIgnoreCase(REST_PROD_HOST);
    }

    public static boolean isRealtimeFallbackSupported(String host) {
        return host.equalsIgnoreCase(REALTIME_PROD_HOST);
    }
}

