/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class EventEmitter<Event, Listener> {
    Map<Listener, Filter> filters = new HashMap<Listener, Filter>();
    Set<Listener> listeners = new HashSet<Listener>();

    public synchronized void off() {
        this.listeners.clear();
        this.filters.clear();
    }

    public synchronized void on(Listener listener) {
        this.listeners.add(listener);
    }

    public synchronized void once(Listener listener) {
        this.filters.put(listener, new Filter(null, listener, true));
    }

    public synchronized void off(Listener listener) {
        this.listeners.remove(listener);
        this.filters.remove(listener);
    }

    public synchronized void on(Event event, Listener listener) {
        this.filters.put(listener, new Filter(event, listener, false));
    }

    public synchronized void once(Event event, Listener listener) {
        this.filters.put(listener, new Filter(event, listener, true));
    }

    public synchronized void off(Event event, Listener listener) {
        Filter filter = this.filters.get(listener);
        if (filter != null && filter.event == event) {
            this.filters.remove(listener);
        }
    }

    public synchronized void emit(Event event, Object ... args) {
        Iterator<Object> it = this.listeners.iterator();
        while (it.hasNext()) {
            this.apply(it.next(), event, args);
        }
        it = this.filters.entrySet().iterator();
        while (it.hasNext()) {
            if (!((Filter)((Map.Entry)it.next()).getValue()).apply(event, args)) continue;
            it.remove();
        }
    }

    protected abstract void apply(Listener var1, Event var2, Object ... var3);

    protected class Filter {
        private Event event;
        private Listener listener;
        private boolean once;

        Filter(Event event, Listener listener, boolean once) {
            this.event = event;
            this.listener = listener;
            this.once = once;
        }

        protected boolean apply(Event event, Object ... args) {
            if (this.event == event || this.event == null) {
                EventEmitter.this.apply(this.listener, event, args);
                return this.once;
            }
            return false;
        }
    }
}

