/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.transport;

import io.ably.lib.transport.ConnectionManager;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Param;
import io.ably.lib.types.ProtocolMessage;
import io.ably.lib.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface ITransport {
    public static final String TAG = ITransport.class.getName();

    public void connect(ConnectListener var1);

    public void close(boolean var1);

    public void abort(ErrorInfo var1);

    public void send(ProtocolMessage var1) throws AblyException;

    public String getHost();

    public static interface ConnectListener {
        public void onTransportAvailable(ITransport var1, TransportParams var2);

        public void onTransportUnavailable(ITransport var1, TransportParams var2, ErrorInfo var3);
    }

    public static class TransportParams {
        ClientOptions options;
        String host;
        int port;
        String connectionKey;
        String connectionSerial;
        Mode mode;

        public Param[] getConnectParams(Param[] baseParams) {
            ArrayList<Param> paramList = new ArrayList<Param>(Arrays.asList(baseParams));
            if (this.options.useBinaryProtocol) {
                paramList.add(new Param("format", "msgpack"));
            }
            if (!this.options.echoMessages) {
                paramList.add(new Param("echo", "false"));
            }
            if (this.connectionKey != null) {
                this.mode = Mode.resume;
                paramList.add(new Param("resume", this.connectionKey));
                if (this.connectionSerial != null) {
                    paramList.add(new Param("connection_serial", this.connectionSerial));
                }
            } else if (this.options.recover != null) {
                this.mode = Mode.recover;
                Pattern recoverSpec = Pattern.compile("^([\\w\\-\\!]+):(\\-?\\d+)$");
                Matcher match = recoverSpec.matcher(this.options.recover);
                if (match.matches()) {
                    paramList.add(new Param("recover", match.group(1)));
                    paramList.add(new Param("connection_serial", match.group(2)));
                } else {
                    Log.e(TAG, "Invalid recover string specified");
                }
            }
            if (this.options.clientId != null) {
                paramList.add(new Param("client_id", this.options.clientId));
            }
            return paramList.toArray(new Param[paramList.size()]);
        }
    }

    public static enum Mode {
        clean,
        resume,
        recover;

    }

    public static interface Factory {
        public ITransport getTransport(TransportParams var1, ConnectionManager var2);
    }
}

