/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.transport;

import io.ably.lib.transport.Defaults;
import java.util.List;

public class Hosts {
    private static final List<String> FALLBACKS = Defaults.HOST_FALLBACKS;
    private static final String PATTERN_REST_PROD = "^rest.ably.io$";
    private static final String PATTERN_REALTIME_PROD = "^realtime.ably.io$";

    private Hosts() {
    }

    public static String getFallback(String host) {
        int size = FALLBACKS.size();
        int indexCurrent = FALLBACKS.indexOf(host);
        return FALLBACKS.get((indexCurrent + 1) % size);
    }

    public static boolean isRestFallbackSupported(String host) {
        return host.matches(PATTERN_REST_PROD);
    }

    public static boolean isRealtimeFallbackSupported(String host) {
        return host.matches(PATTERN_REALTIME_PROD);
    }
}

