/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.ably.lib.types.ConnectionDetails;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageSerializer;
import io.ably.lib.types.PresenceMessage;
import io.ably.lib.types.PresenceSerializer;
import io.ably.lib.util.Log;
import java.io.IOException;
import java.lang.reflect.Type;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class ProtocolMessage {
    public Action action;
    public int flags;
    public int count;
    public ErrorInfo error;
    public String id;
    public String channel;
    public String channelSerial;
    public String connectionId;
    public Long connectionSerial;
    public Long msgSerial;
    public long timestamp;
    public Message[] messages;
    public PresenceMessage[] presence;
    public ConnectionDetails connectionDetails;
    private static final String TAG = ProtocolMessage.class.getName();

    public static boolean mergeTo(ProtocolMessage dest, ProtocolMessage src) {
        Action action;
        boolean result = false;
        if (dest.channel == src.channel && (action = dest.action) == src.action) {
            switch (action) {
                case message: {
                    Message[] srcMessages = src.messages;
                    Message[] destMessages = dest.messages;
                    dest.messages = new Message[destMessages.length + srcMessages.length];
                    Message[] mergedMessages = dest.messages;
                    System.arraycopy(destMessages, 0, mergedMessages, 0, destMessages.length);
                    System.arraycopy(srcMessages, 0, mergedMessages, destMessages.length, srcMessages.length);
                    result = true;
                    break;
                }
                case presence: {
                    PresenceMessage[] srcMessages = src.presence;
                    PresenceMessage[] destMessages = dest.presence;
                    dest.presence = new PresenceMessage[destMessages.length + srcMessages.length];
                    PresenceMessage[] mergedMessages = dest.presence;
                    System.arraycopy(mergedMessages, 0, destMessages, 0, destMessages.length);
                    System.arraycopy(mergedMessages, destMessages.length, srcMessages, 0, srcMessages.length);
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    public static boolean ackRequired(ProtocolMessage msg) {
        return msg.action == Action.message || msg.action == Action.presence;
    }

    public ProtocolMessage() {
    }

    public ProtocolMessage(Action action) {
        this.action = action;
    }

    public ProtocolMessage(Action action, String channel) {
        this.action = action;
        this.channel = channel;
    }

    void writeMsgpack(MessagePacker packer) throws IOException {
        int fieldCount = 1;
        if (this.channel != null) {
            ++fieldCount;
        }
        if (this.msgSerial != null) {
            ++fieldCount;
        }
        if (this.messages != null) {
            ++fieldCount;
        }
        if (this.presence != null) {
            ++fieldCount;
        }
        packer.packMapHeader(fieldCount);
        packer.packString("action");
        packer.packInt(this.action.getValue());
        if (this.channel != null) {
            packer.packString("channel");
            packer.packString(this.channel);
        }
        if (this.msgSerial != null) {
            packer.packString("msgSerial");
            packer.packLong(this.msgSerial.longValue());
        }
        if (this.messages != null) {
            packer.packString("messages");
            MessageSerializer.writeMsgpackArray(this.messages, packer);
        }
        if (this.presence != null) {
            packer.packString("presence");
            PresenceSerializer.writeMsgpackArray(this.presence, packer);
        }
    }

    ProtocolMessage readMsgpack(MessageUnpacker unpacker) throws IOException {
        int fieldCount = unpacker.unpackMapHeader();
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = unpacker.unpackString().intern();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            if (fieldName == "action") {
                this.action = Action.findByValue(unpacker.unpackInt());
                continue;
            }
            if (fieldName == "flags") {
                this.flags = unpacker.unpackInt();
                continue;
            }
            if (fieldName == "count") {
                this.count = unpacker.unpackInt();
                continue;
            }
            if (fieldName == "error") {
                this.error = ErrorInfo.fromMsgpack(unpacker);
                continue;
            }
            if (fieldName == "id") {
                this.id = unpacker.unpackString();
                continue;
            }
            if (fieldName == "channel") {
                this.channel = unpacker.unpackString();
                continue;
            }
            if (fieldName == "channelSerial") {
                this.channelSerial = unpacker.unpackString();
                continue;
            }
            if (fieldName == "connectionId") {
                this.connectionId = unpacker.unpackString();
                continue;
            }
            if (fieldName == "connectionSerial") {
                this.connectionSerial = unpacker.unpackLong();
                continue;
            }
            if (fieldName == "msgSerial") {
                this.msgSerial = unpacker.unpackLong();
                continue;
            }
            if (fieldName == "timestamp") {
                this.timestamp = unpacker.unpackLong();
                continue;
            }
            if (fieldName == "messages") {
                this.messages = MessageSerializer.readMsgpackArray(unpacker);
                continue;
            }
            if (fieldName == "presence") {
                this.presence = PresenceSerializer.readMsgpackArray(unpacker);
                continue;
            }
            if (fieldName == "connectionDetails") {
                this.connectionDetails = ConnectionDetails.fromMsgpack(unpacker);
                continue;
            }
            Log.v(TAG, "Unexpected field: " + fieldName);
            unpacker.skipValue();
        }
        return this;
    }

    static ProtocolMessage fromMsgpack(MessageUnpacker unpacker) throws IOException {
        return new ProtocolMessage().readMsgpack(unpacker);
    }

    public static class ActionSerializer
    implements JsonSerializer<Action>,
    JsonDeserializer<Action> {
        public Action deserialize(JsonElement json, Type t, JsonDeserializationContext ctx) throws JsonParseException {
            return Action.findByValue(json.getAsInt());
        }

        public JsonElement serialize(Action action, Type t, JsonSerializationContext ctx) {
            return new JsonPrimitive((Number)action.getValue());
        }
    }

    public static enum Flag {
        has_presence,
        has_backlog;


        public int getValue() {
            return this.ordinal();
        }

        public static Flag findByValue(int value) {
            return Flag.values()[value];
        }
    }

    public static enum Action {
        heartbeat,
        ack,
        nack,
        connect,
        connected,
        disconnect,
        disconnected,
        close,
        closed,
        error,
        attach,
        attached,
        detach,
        detached,
        presence,
        message,
        sync;


        public int getValue() {
            return this.ordinal();
        }

        public static Action findByValue(int value) {
            return Action.values()[value];
        }
    }
}

