/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.transport;

import io.ably.lib.debug.DebugOptions;
import io.ably.lib.debug.RawProtocolListener;
import io.ably.lib.realtime.AblyRealtime;
import io.ably.lib.realtime.Channel;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.realtime.Connection;
import io.ably.lib.realtime.ConnectionState;
import io.ably.lib.realtime.ConnectionStateListener;
import io.ably.lib.transport.Defaults;
import io.ably.lib.transport.Hosts;
import io.ably.lib.transport.ITransport;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.ProtocolMessage;
import io.ably.lib.types.ProtocolSerializer;
import io.ably.lib.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ConnectionManager
implements Runnable,
ITransport.ConnectListener {
    private static final String TAG = ConnectionManager.class.getName();
    private static final String INTERNET_CHECK_URL = "http://internet-up.ably-realtime.com/is-the-internet-up.txt";
    private static final String INTERNET_CHECK_OK = "yes";
    static ErrorInfo REASON_CLOSED = new ErrorInfo("Connection closed by client", 200, 10000);
    static ErrorInfo REASON_DISCONNECTED = new ErrorInfo("Connection temporarily unavailable", 503, 80003);
    static ErrorInfo REASON_SUSPENDED = new ErrorInfo("Connection unavailable", 503, 80002);
    static ErrorInfo REASON_FAILED = new ErrorInfo("Connection failed", 503, 80000);
    static ErrorInfo REASON_REFUSED = new ErrorInfo("Access refused", 401, 40100);
    static ErrorInfo REASON_TOO_BIG = new ErrorInfo("Connection closed; message too large", 400, 40000);
    static ErrorInfo REASON_NEVER_CONNECTED = new ErrorInfo("Unable to establish connection", 503, 80002);
    static ErrorInfo REASON_TIMEDOUT = new ErrorInfo("Unable to establish connection", 503, 80014);
    public static final HashMap<ConnectionState, StateInfo> states = new HashMap<ConnectionState, StateInfo>(){
        {
            this.put(ConnectionState.initialized, new StateInfo(ConnectionState.initialized, true, false, false, false, 0L, null));
            this.put(ConnectionState.connecting, new StateInfo(ConnectionState.connecting, true, false, false, false, Defaults.TIMEOUT_CONNECT, null));
            this.put(ConnectionState.connected, new StateInfo(ConnectionState.connected, false, true, false, false, 0L, null));
            this.put(ConnectionState.disconnected, new StateInfo(ConnectionState.disconnected, true, false, false, true, Defaults.TIMEOUT_DISCONNECT, REASON_DISCONNECTED));
            this.put(ConnectionState.suspended, new StateInfo(ConnectionState.suspended, false, false, false, true, Defaults.TIMEOUT_SUSPEND, REASON_SUSPENDED));
            this.put(ConnectionState.closing, new StateInfo(ConnectionState.closing, false, false, false, false, Defaults.TIMEOUT_CONNECT, REASON_CLOSED));
            this.put(ConnectionState.closed, new StateInfo(ConnectionState.closed, false, false, true, false, 0L, REASON_CLOSED));
            this.put(ConnectionState.failed, new StateInfo(ConnectionState.failed, false, false, true, false, 0L, REASON_FAILED));
        }
    };
    long maxIdleInterval;
    private Thread mgrThread;
    final AblyRealtime ably;
    private final ClientOptions options;
    private final Connection connection;
    private final ITransport.Factory factory;
    private final List<QueuedMessage> queuedMessages;
    private final PendingMessageQueue pendingMessages;
    private final HashSet<Object> heartbeatWaiters = new HashSet();
    private final Hosts hosts;
    private StateInfo state;
    private StateIndication indicatedState;
    private StateIndication requestedState;
    private ConnectParams pendingConnect;
    private ITransport transport;
    private long suspendTime;
    private long msgSerial;
    private RawProtocolListener protocolListener;
    private static final long HEARTBEAT_TIMEOUT = 5000L;

    public ErrorInfo getStateErrorInfo() {
        return this.state.defaultErrorInfo;
    }

    public boolean isActive() {
        return this.state.queueEvents || this.state.sendEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionManager(AblyRealtime ably, Connection connection) {
        this.ably = ably;
        this.options = ably.options;
        this.connection = connection;
        this.queuedMessages = new ArrayList<QueuedMessage>();
        this.pendingMessages = new PendingMessageQueue();
        this.state = states.get((Object)ConnectionState.initialized);
        String transportClass = Defaults.TRANSPORT;
        try {
            this.hosts = new Hosts(this.options.realtimeHost, "realtime.ably.io", this.options);
            if (this.options instanceof DebugOptions) {
                this.protocolListener = ((DebugOptions)this.options).protocolListener;
            }
            this.factory = (ITransport.Factory)Class.forName(transportClass).newInstance();
        }
        catch (Exception e) {
            String msg = "Unable to instance factory class";
            Log.e(this.getClass().getName(), msg, e);
            throw new RuntimeException(msg, e);
        }
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            this.setSuspendTime();
        }
    }

    public String getHost() {
        if (this.transport != null) {
            return this.transport.getHost();
        }
        return this.pendingConnect.host;
    }

    public void connect() {
        boolean connectionAttemptInProgress;
        boolean connectionExist = this.state.state == ConnectionState.connected;
        boolean bl = connectionAttemptInProgress = this.requestedState != null && this.requestedState.state == ConnectionState.connecting || this.state.state == ConnectionState.connecting;
        if (!connectionExist && !connectionAttemptInProgress) {
            this.startThread();
            this.requestState(ConnectionState.connecting);
        }
    }

    public void close() {
        this.requestState(ConnectionState.closing);
    }

    public synchronized StateInfo getConnectionState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(StateIndication newState) {
        block7: {
            block6: {
                ConnectionStateListener.ConnectionStateChange change;
                Log.v(TAG, "setState(): setting " + (Object)((Object)newState.state));
                StateInfo newStateInfo = states.get((Object)newState.state);
                Iterator iterator = this;
                synchronized (iterator) {
                    ErrorInfo reason = newState.reason;
                    if (reason == null) {
                        reason = newStateInfo.defaultErrorInfo;
                    }
                    change = new ConnectionStateListener.ConnectionStateChange(this.state.state, newState.state, newStateInfo.timeout, reason);
                    newStateInfo.host = newState.currentHost;
                    this.state = newStateInfo;
                }
                this.connection.onConnectionStateChange(change);
                if (!this.state.sendEvents) break block6;
                this.sendQueuedMessages();
                for (Channel channel : this.ably.channels.values()) {
                    channel.setConnected();
                }
                break block7;
            }
            if (this.state.queueEvents) break block7;
            this.failQueuedMessages(this.state.defaultErrorInfo);
            for (Channel channel : this.ably.channels.values()) {
                channel.setSuspended(this.state.defaultErrorInfo);
            }
        }
    }

    public void requestState(ConnectionState state) {
        this.requestState(new StateIndication(state, null));
    }

    public synchronized void requestState(StateIndication state) {
        Log.v(TAG, "requestState(): requesting " + (Object)((Object)state.state) + "; id = " + this.connection.key);
        this.requestedState = state;
        this.notify();
    }

    synchronized void notifyState(ITransport transport, StateIndication state) {
        if (this.transport == transport) {
            if (ConnectionManager.states.get((Object)((Object)state.state)).terminal) {
                this.transport = null;
            }
            this.notifyState(state);
        } else {
            Log.v(TAG, "notifyState: wrong transport");
        }
    }

    synchronized void notifyState(StateIndication state) {
        Log.v(TAG, "notifyState(): notifying " + (Object)((Object)state.state) + "; id = " + this.connection.key);
        if (Thread.currentThread() == this.mgrThread) {
            this.handleStateChange(state);
        } else {
            this.indicatedState = state;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping(final CompletionListener listener) {
        block8: {
            if (this.state.state != ConnectionState.connected) {
                if (listener != null) {
                    listener.onError(new ErrorInfo("Unable to ping service; not connected", 40000, 400));
                }
                return;
            }
            if (listener != null) {
                Runnable waiter = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean pending;
                        HashSet hashSet = ConnectionManager.this.heartbeatWaiters;
                        synchronized (hashSet) {
                            pending = ConnectionManager.this.heartbeatWaiters.contains(this);
                            if (pending) {
                                try {
                                    ConnectionManager.this.heartbeatWaiters.wait(5000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            pending = ConnectionManager.this.heartbeatWaiters.remove(this);
                        }
                        if (pending) {
                            listener.onError(new ErrorInfo("Timed out waiting for heartbeat response", 50000, 500));
                        } else {
                            listener.onSuccess();
                        }
                    }
                };
                HashSet<Object> hashSet = this.heartbeatWaiters;
                synchronized (hashSet) {
                    this.heartbeatWaiters.add(waiter);
                    new Thread(waiter).start();
                }
            }
            try {
                this.send(new ProtocolMessage(ProtocolMessage.Action.heartbeat), false, null);
            }
            catch (AblyException e) {
                if (listener == null) break block8;
                listener.onError(e.errorInfo);
            }
        }
    }

    public void onAuthUpdated() {
        switch (this.state.state) {
            case connected: 
            case connecting: {
                ITransport transport = this.transport;
                if (transport == null) break;
                Log.v(TAG, "onAuthUpdated: closing transport");
                transport.close(false);
                break;
            }
        }
    }

    public void onMessage(ProtocolMessage message) throws AblyException {
        if (Log.level <= 2) {
            Log.v(TAG, "onMessage(): " + new String(ProtocolSerializer.writeJSON(message)));
        }
        try {
            if (this.protocolListener != null) {
                this.protocolListener.onRawMessage(message);
            }
            switch (message.action) {
                case heartbeat: {
                    this.onHeartbeat(message);
                    break;
                }
                case error: {
                    ErrorInfo reason = message.error;
                    if (reason == null) {
                        Log.e(TAG, "onMessage(): ERROR message received (no error detail)");
                    } else {
                        Log.e(TAG, "onMessage(): ERROR message received; message = " + reason.message + "; code = " + reason.code);
                    }
                    if (message.channel != null) {
                        this.onChannelMessage(message);
                        break;
                    }
                    this.onError(message);
                    break;
                }
                case connected: {
                    this.onConnected(message);
                    break;
                }
                case disconnect: 
                case disconnected: {
                    this.onDisconnected(message);
                    break;
                }
                case closed: {
                    this.onClosed(message);
                    break;
                }
                case ack: {
                    this.onAck(message);
                    break;
                }
                case nack: {
                    this.onNack(message);
                    break;
                }
                default: {
                    this.onChannelMessage(message);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw AblyException.fromThrowable(e);
        }
    }

    private void onChannelMessage(ProtocolMessage message) {
        if (message.connectionSerial != null) {
            this.connection.serial = message.connectionSerial;
        }
        this.ably.channels.onChannelMessage(this.transport, message);
    }

    private synchronized void onConnected(ProtocolMessage message) {
        if (this.pendingConnect.host == this.options.realtimeHost) {
            this.ably.http.setHost(this.options.restHost);
        } else {
            this.ably.http.setHost(this.pendingConnect.host);
        }
        ErrorInfo error = message.error;
        if (error != null && !message.connectionId.equals(this.connection.id)) {
            this.ably.channels.suspendAll(error);
        }
        this.connection.key = message.connectionDetails.connectionKey;
        if (!message.connectionId.equals(this.connection.id)) {
            this.pendingMessages.reset(this.msgSerial, new ErrorInfo("Connection resume failed", 500, 50000));
            this.msgSerial = 0L;
        }
        this.connection.id = message.connectionId;
        if (message.connectionSerial != null) {
            this.connection.serial = message.connectionSerial;
        }
        this.maxIdleInterval = message.connectionDetails.maxIdleInterval;
        this.setSuspendTime();
        this.notifyState(new StateIndication(ConnectionState.connected, error));
    }

    private synchronized void onDisconnected(ProtocolMessage message) {
        this.onTransportUnavailable(this.transport, null, message.error);
    }

    private synchronized void onClosed(ProtocolMessage message) {
        if (message.error != null) {
            this.onError(message);
        } else {
            this.connection.key = null;
            this.notifyState(new StateIndication(ConnectionState.closed, null));
        }
    }

    private synchronized void onError(ProtocolMessage message) {
        this.connection.key = null;
        ConnectionState destinationState = this.isFatalError(message.error) ? ConnectionState.failed : ConnectionState.disconnected;
        this.notifyState(this.transport, new StateIndication(destinationState, message.error));
    }

    private void onAck(ProtocolMessage message) {
        this.pendingMessages.ack(message.msgSerial, message.count, message.error);
    }

    private void onNack(ProtocolMessage message) {
        this.pendingMessages.nack(message.msgSerial, message.count, message.error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onHeartbeat(ProtocolMessage message) {
        HashSet<Object> hashSet = this.heartbeatWaiters;
        synchronized (hashSet) {
            this.heartbeatWaiters.clear();
            this.heartbeatWaiters.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startThread() {
        boolean creating = false;
        Runnable runnable = this;
        synchronized (runnable) {
            if (this.mgrThread == null) {
                this.mgrThread = new Thread(this);
                this.state = states.get((Object)ConnectionState.initialized);
                creating = true;
            }
        }
        if (creating) {
            runnable = this.mgrThread;
            synchronized (runnable) {
                this.mgrThread.start();
                try {
                    this.mgrThread.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return creating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopThread() {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (this.mgrThread != null) {
                this.mgrThread.interrupt();
                this.mgrThread = null;
            }
        }
    }

    private void handleStateRequest() {
        boolean handled = false;
        switch (this.requestedState.state) {
            case failed: {
                if (this.transport == null) break;
                this.transport.abort(this.requestedState.reason);
                handled = true;
                break;
            }
            case closed: {
                if (this.state.state == ConnectionState.failed) {
                    handled = true;
                    break;
                }
                if (this.transport == null) break;
                this.transport.close(this.state.state == ConnectionState.connected);
                handled = true;
                break;
            }
            case connecting: {
                if (!this.connectImpl(this.requestedState)) {
                    this.indicatedState = new StateIndication(ConnectionState.failed, new ErrorInfo("Connection failed; no host available", 404, 80000), null, this.requestedState.currentHost);
                }
                handled = true;
                break;
            }
            case closing: {
                this.closeImpl(this.requestedState);
                handled = true;
            }
        }
        if (!handled) {
            this.indicatedState = this.requestedState;
        }
        this.requestedState = null;
    }

    private void handleStateChange(StateIndication stateChange) {
        if (stateChange.state == ConnectionState.disconnected) {
            switch (this.state.state) {
                case connecting: {
                    stateChange = this.checkSuspend(stateChange);
                    this.pendingConnect = null;
                    break;
                }
                case closing: {
                    ErrorInfo closeReason = stateChange.reason == REASON_DISCONNECTED ? REASON_CLOSED : stateChange.reason;
                    stateChange = new StateIndication(ConnectionState.closed, closeReason);
                    break;
                }
                case failed: 
                case closed: {
                    if (this.transport != null) {
                        this.transport.close(false);
                        this.transport = null;
                    }
                    stateChange = null;
                    this.stopThread();
                    break;
                }
                case connected: {
                    this.setSuspendTime();
                    this.requestState(ConnectionState.connecting);
                    break;
                }
                case suspended: {
                    Log.v(TAG, "handleStateChange: not moving out of suspended");
                    stateChange = null;
                    break;
                }
            }
        }
        if (stateChange != null && stateChange.state != this.state.state) {
            this.setState(stateChange);
        }
    }

    private void setSuspendTime() {
        this.suspendTime = System.currentTimeMillis() + (long)Defaults.TIMEOUT_SUSPEND;
    }

    private StateIndication checkSuspend(StateIndication stateChange) {
        String hostFallback;
        if (this.pendingConnect != null && (stateChange.reason == null || stateChange.reason.statusCode >= 500) && this.checkConnectivity() && (hostFallback = this.hosts.getFallback(this.pendingConnect.host)) != null) {
            Log.v(TAG, "checkSuspend: fallback to " + hostFallback);
            this.requestState(new StateIndication(ConnectionState.connecting, null, hostFallback, this.pendingConnect.host));
            return null;
        }
        Log.v(TAG, "checkSuspend: not falling back");
        boolean suspendMode = System.currentTimeMillis() > this.suspendTime;
        ConnectionState expiredState = suspendMode ? ConnectionState.suspended : ConnectionState.disconnected;
        return new StateIndication(expiredState, stateChange.reason);
    }

    private void tryWait(long timeout) {
        if (this.requestedState == null && this.indicatedState == null) {
            try {
                if (timeout == 0L) {
                    this.wait();
                } else {
                    this.wait(timeout);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ConnectionManager connectionManager;
        Thread thisThread = Thread.currentThread();
        while (!this.state.terminal) {
            StateIndication stateChange = null;
            connectionManager = this;
            synchronized (connectionManager) {
                if (this.state.state == ConnectionState.initialized) {
                    Thread thread = thisThread;
                    synchronized (thread) {
                        thisThread.notify();
                    }
                }
                while (stateChange == null) {
                    this.tryWait(this.state.timeout);
                    if (this.requestedState != null) {
                        this.handleStateRequest();
                        continue;
                    }
                    if (this.indicatedState != null) {
                        stateChange = this.indicatedState;
                        this.indicatedState = null;
                        break;
                    }
                    if (this.state.retry) {
                        this.requestState(ConnectionState.connecting);
                        continue;
                    }
                    stateChange = this.checkSuspend(new StateIndication(ConnectionState.disconnected, REASON_TIMEDOUT));
                }
            }
            if (stateChange == null) continue;
            this.handleStateChange(stateChange);
        }
        connectionManager = this;
        synchronized (connectionManager) {
            if (this.mgrThread == thisThread) {
                this.mgrThread = null;
            }
        }
    }

    @Override
    public void onTransportAvailable(ITransport transport, ITransport.TransportParams params) {
    }

    @Override
    public synchronized void onTransportUnavailable(ITransport transport, ITransport.TransportParams params, ErrorInfo reason) {
        if (this.transport != transport) {
            Log.v(TAG, "onTransportUnavailable: wrong transport");
            return;
        }
        this.ably.auth.onAuthError(reason);
        this.notifyState(new StateIndication(ConnectionState.disconnected, reason, null, transport.getHost()));
        transport = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectImpl(StateIndication request) {
        ITransport oldTransport;
        ITransport transport;
        String host = request.fallback;
        if (host == null) {
            host = this.hosts.getHost();
        }
        this.pendingConnect = new ConnectParams(this.options);
        this.pendingConnect.host = host;
        this.notifyState(request);
        try {
            transport = this.factory.getTransport(this.pendingConnect, this);
        }
        catch (Exception e) {
            String msg = "Unable to instance transport class";
            Log.e(this.getClass().getName(), msg, e);
            throw new RuntimeException(msg, e);
        }
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            oldTransport = this.transport;
            this.transport = transport;
        }
        if (oldTransport != null) {
            oldTransport.abort(REASON_TIMEDOUT);
        }
        transport.connect(this);
        return true;
    }

    private void closeImpl(StateIndication request) {
        boolean connectionExist = this.state.state == ConnectionState.connected;
        this.notifyState(request);
        if (connectionExist) {
            try {
                this.transport.send(new ProtocolMessage(ProtocolMessage.Action.close));
            }
            catch (AblyException e) {
                this.transport.abort(e.errorInfo);
            }
            return;
        }
        this.notifyState(new StateIndication(ConnectionState.closed, null));
    }

    protected boolean checkConnectivity() {
        try {
            return this.ably.http.getUrlString(INTERNET_CHECK_URL).contains(INTERNET_CHECK_OK);
        }
        catch (AblyException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ProtocolMessage msg, boolean queueEvents, CompletionListener listener) throws AblyException {
        StateInfo state;
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            state = this.state;
            if (state.sendEvents) {
                this.sendImpl(msg, listener);
                return;
            }
            if (state.queueEvents && queueEvents) {
                int queueSize = this.queuedMessages.size();
                if (queueSize > 0) {
                    QueuedMessage lastQueued = this.queuedMessages.get(queueSize - 1);
                    ProtocolMessage lastMessage = lastQueued.msg;
                    if (ProtocolMessage.mergeTo(lastMessage, msg)) {
                        if (!lastQueued.isMerged) {
                            lastQueued.listener = new CompletionListener.Multicaster(lastQueued.listener);
                            lastQueued.isMerged = true;
                        }
                        ((CompletionListener.Multicaster)lastQueued.listener).add(listener);
                        return;
                    }
                }
                this.queuedMessages.add(new QueuedMessage(msg, listener));
                return;
            }
        }
        throw AblyException.fromErrorInfo(state.defaultErrorInfo);
    }

    private void sendImpl(ProtocolMessage message) throws AblyException {
        this.transport.send(message);
    }

    private void sendImpl(ProtocolMessage message, CompletionListener listener) throws AblyException {
        if (ProtocolMessage.ackRequired(message)) {
            message.msgSerial = this.msgSerial++;
            this.pendingMessages.push(new QueuedMessage(message, listener));
        }
        this.transport.send(message);
    }

    private void sendImpl(QueuedMessage msg) throws AblyException {
        ProtocolMessage message = msg.msg;
        if (ProtocolMessage.ackRequired(message)) {
            message.msgSerial = this.msgSerial++;
            this.pendingMessages.push(msg);
        }
        this.transport.send(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQueuedMessages() {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            while (this.queuedMessages.size() > 0) {
                try {
                    this.sendImpl(this.queuedMessages.get(0));
                }
                catch (AblyException e) {
                    Log.e(TAG, "sendQueuedMessages(): Unexpected error sending queued messages", e);
                }
                finally {
                    this.queuedMessages.remove(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failQueuedMessages(ErrorInfo reason) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            for (QueuedMessage queued : this.queuedMessages) {
                if (queued.listener == null) continue;
                try {
                    queued.listener.onError(reason);
                }
                catch (Throwable t) {
                    Log.e(TAG, "failQueuedMessages(): Unexpected error calling listener", t);
                }
            }
            this.queuedMessages.clear();
        }
    }

    private boolean isFatalError(ErrorInfo err) {
        if (err.code != 0) {
            if (err.code >= 40140 && err.code < 40150) {
                return false;
            }
            if (err.code >= 40000 && err.code < 50000) {
                return true;
            }
        }
        return err.statusCode != 0 && err.statusCode < 500;
    }

    private class PendingMessageQueue {
        private long startSerial = 0L;
        private ArrayList<QueuedMessage> queue = new ArrayList();

        private PendingMessageQueue() {
        }

        public synchronized void push(QueuedMessage msg) {
            this.queue.add(msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ack(long msgSerial, int count, ErrorInfo reason) {
            QueuedMessage[] ackMessages = null;
            QueuedMessage[] nackMessages = null;
            PendingMessageQueue pendingMessageQueue = this;
            synchronized (pendingMessageQueue) {
                if (msgSerial < this.startSerial) {
                    if ((count -= (int)(this.startSerial - msgSerial)) < 0) {
                        count = 0;
                    }
                    msgSerial = this.startSerial;
                }
                if (msgSerial > this.startSerial) {
                    int nCount = (int)(msgSerial - this.startSerial);
                    List<QueuedMessage> nackList = this.queue.subList(0, nCount);
                    nackMessages = nackList.toArray(new QueuedMessage[nCount]);
                    nackList.clear();
                    this.startSerial = msgSerial;
                }
                if (msgSerial == this.startSerial) {
                    List<QueuedMessage> ackList = this.queue.subList(0, count);
                    ackMessages = ackList.toArray(new QueuedMessage[count]);
                    ackList.clear();
                    this.startSerial += (long)count;
                }
            }
            if (nackMessages != null) {
                if (reason == null) {
                    reason = new ErrorInfo("Unknown error", 500, 50000);
                }
                for (PendingMessageQueue pendingMessageQueue2 : nackMessages) {
                    try {
                        if (((QueuedMessage)((Object)pendingMessageQueue2)).listener == null) continue;
                        ((QueuedMessage)((Object)pendingMessageQueue2)).listener.onError(reason);
                    }
                    catch (Throwable t) {
                        Log.e(TAG, "ack(): listener exception", t);
                    }
                }
            }
            if (ackMessages != null) {
                for (PendingMessageQueue pendingMessageQueue3 : ackMessages) {
                    try {
                        if (((QueuedMessage)((Object)pendingMessageQueue3)).listener == null) continue;
                        ((QueuedMessage)((Object)pendingMessageQueue3)).listener.onSuccess();
                    }
                    catch (Throwable t) {
                        Log.e(TAG, "ack(): listener exception", t);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void nack(long serial, int count, ErrorInfo reason) {
            QueuedMessage[] nackMessages = null;
            QueuedMessage[] queuedMessageArray = this;
            synchronized (this) {
                if (serial != this.startSerial) {
                    count -= (int)(this.startSerial - serial);
                    serial = this.startSerial;
                }
                List<QueuedMessage> nackList = this.queue.subList(0, count);
                nackMessages = nackList.toArray(new QueuedMessage[count]);
                nackList.clear();
                this.startSerial += (long)count;
                // ** MonitorExit[var6_5] (shouldn't be in output)
                if (nackMessages != null) {
                    if (reason == null) {
                        reason = new ErrorInfo("Unknown error", 500, 50000);
                    }
                    for (QueuedMessage msg : nackMessages) {
                        try {
                            if (msg.listener == null) continue;
                            msg.listener.onError(reason);
                        }
                        catch (Throwable t) {
                            Log.e(TAG, "nack(): listener exception", t);
                        }
                    }
                }
                return;
            }
        }

        public synchronized void reset(long oldMsgSerial, ErrorInfo err) {
            this.nack(this.startSerial, (int)(oldMsgSerial - this.startSerial), err);
            this.startSerial = 0L;
        }
    }

    public static class QueuedMessage {
        public final ProtocolMessage msg;
        public CompletionListener listener;
        private boolean isMerged;

        public QueuedMessage(ProtocolMessage msg, CompletionListener listener) {
            this.msg = msg;
            this.listener = listener;
        }
    }

    private class ConnectParams
    extends ITransport.TransportParams {
        ConnectParams(ClientOptions options) {
            this.options = options;
            this.connectionKey = ((ConnectionManager)ConnectionManager.this).connection.key;
            this.connectionSerial = String.valueOf(((ConnectionManager)ConnectionManager.this).connection.serial);
            this.port = Defaults.getPort(options);
        }
    }

    public static class StateInfo {
        public final ConnectionState state;
        public final ErrorInfo defaultErrorInfo;
        final boolean queueEvents;
        final boolean sendEvents;
        final boolean terminal;
        final boolean retry;
        final long timeout;
        String host;

        StateInfo(ConnectionState state, boolean queueEvents, boolean sendEvents, boolean terminal, boolean retry, long timeout, ErrorInfo defaultErrorInfo) {
            this.state = state;
            this.queueEvents = queueEvents;
            this.sendEvents = sendEvents;
            this.terminal = terminal;
            this.retry = retry;
            this.timeout = timeout;
            this.defaultErrorInfo = defaultErrorInfo;
        }
    }

    public static class StateIndication {
        final ConnectionState state;
        final ErrorInfo reason;
        final String fallback;
        final String currentHost;

        public StateIndication(ConnectionState state, ErrorInfo reason) {
            this(state, reason, null, null);
        }

        public StateIndication(ConnectionState state, ErrorInfo reason, String fallback, String currentHost) {
            this.state = state;
            this.reason = reason;
            this.fallback = fallback;
            this.currentHost = currentHost;
        }
    }
}

