/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.http;

import io.ably.lib.rest.Auth;
import io.ably.lib.types.AblyException;
import io.ably.lib.util.Base64Coder;
import io.ably.lib.util.Log;

public class TokenAuth {
    private Auth auth;
    private Auth.TokenDetails tokenDetails;
    private String encodedToken;

    public TokenAuth(Auth auth) {
        this.auth = auth;
    }

    public Auth.TokenDetails getTokenDetails() {
        Log.i("TokenAuth.getTokenDetails()", "");
        return this.tokenDetails;
    }

    public String getEncodedToken() {
        Log.i("TokenAuth.getEncodedToken()", "");
        return this.encodedToken;
    }

    public void setTokenDetails(Auth.TokenDetails tokenDetails) {
        Log.i("TokenAuth.setTokenDetails()", "");
        this.tokenDetails = tokenDetails;
        this.encodedToken = Base64Coder.encodeString(tokenDetails.token).replace("=", "");
    }

    public boolean authorise(Auth.AuthOptions options, Auth.TokenParams params, boolean force) throws AblyException {
        Log.i("TokenAuth.authorise()", "");
        if (this.tokenDetails != null) {
            if (this.tokenDetails.expires == 0L || TokenAuth.tokenValid(this.tokenDetails)) {
                if (options == null || !force) {
                    Log.i("TokenAuth.authorise()", "using cached token; expires = " + this.tokenDetails.expires);
                    return false;
                }
            } else {
                Log.i("TokenAuth.authorise()", "deleting expired token");
                this.clear();
            }
        }
        Log.i("TokenAuth.authorise()", "requesting new token");
        this.setTokenDetails(this.auth.requestToken(params, options));
        return true;
    }

    public void clear() {
        this.tokenDetails = null;
        this.encodedToken = null;
    }

    private static boolean tokenValid(Auth.TokenDetails tokenDetails) {
        return tokenDetails.expires > Auth.timestamp();
    }
}

