/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.util;

public class HexDump {
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String dump(String str) {
        return HexDump.dump(str.getBytes());
    }

    public static String dump(byte[] bytes) {
        int i = 0;
        int len = bytes.length;
        StringBuffer result = new StringBuffer();
        while (i < len) {
            StringBuffer charBuf = new StringBuffer();
            StringBuffer hexBuf = new StringBuffer();
            for (int j = 0; j < 16; ++j) {
                if (i >= len) {
                    hexBuf.append("   ");
                    continue;
                }
                byte b = bytes[i++];
                hexBuf.append(HexDump.hex(b)).append(' ');
                charBuf.append(HexDump.printable(b));
            }
            result.append(hexBuf).append("  ").append(charBuf).append('\n');
        }
        return result.toString();
    }

    private static int uint8(byte b) {
        return b & 0xFF;
    }

    private static String hex(byte b) {
        int i = HexDump.uint8(b);
        return new String(new char[]{hexChars[i / 16], hexChars[i % 16]});
    }

    private static char printable(byte b) {
        int i = HexDump.uint8(b);
        return i >= 32 && i <= 126 ? (char)i : (char)'.';
    }
}

