/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import java.io.IOException;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessageUnpacker;

public class ErrorInfo {
    public int code;
    public int statusCode;
    public String message;

    public ErrorInfo() {
    }

    public ErrorInfo(String message, int code) {
        this.code = code;
        this.message = message;
    }

    public ErrorInfo(String message, int statusCode, int code) {
        this(message, code);
        this.statusCode = statusCode;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[ErrorInfo");
        if (this.message != null) {
            result.append(" message = ").append(this.message);
        }
        if (this.code > 0) {
            result.append(" code = ").append(this.code);
        }
        if (this.statusCode > 0) {
            result.append(" statusCode = ").append(this.statusCode);
        }
        result.append(']');
        return result.toString();
    }

    ErrorInfo readMsgpack(MessageUnpacker unpacker) throws IOException {
        int fieldCount = unpacker.unpackMapHeader();
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = unpacker.unpackString().intern();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            if (fieldName == "message") {
                this.message = unpacker.unpackString();
                continue;
            }
            if (fieldName == "code") {
                this.code = unpacker.unpackInt();
                continue;
            }
            if (fieldName == "statusCode") {
                this.statusCode = unpacker.unpackInt();
                continue;
            }
            System.out.println("Unexpected field: " + fieldName);
            unpacker.skipValue();
        }
        return this;
    }

    static ErrorInfo fromMsgpack(MessageUnpacker unpacker) throws IOException {
        return new ErrorInfo().readMsgpack(unpacker);
    }
}

