/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.ErrorResponse;
import io.ably.lib.util.Serialisation;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public class AblyException
extends Exception {
    private static final long serialVersionUID = -3804072091596832634L;
    public ErrorInfo errorInfo;

    public AblyException(Throwable cause) {
        super(cause);
        this.errorInfo = new ErrorInfo("Unexpected exception: " + cause.getLocalizedMessage(), 50000, 500);
    }

    public AblyException(ErrorInfo reason) {
        super(reason.message);
        this.errorInfo = reason;
    }

    public AblyException(String reason, int statusCode, int code) {
        super(reason);
        this.errorInfo = new ErrorInfo(reason, statusCode, code);
    }

    public static AblyException fromJSON(String jsonText) throws AblyException {
        ErrorResponse errorResponse = (ErrorResponse)Serialisation.gson.fromJson(jsonText, ErrorResponse.class);
        return new AblyException(errorResponse.error);
    }

    public static AblyException fromError(ErrorInfo error) throws AblyException {
        return new AblyException(error);
    }

    public static AblyException fromJSON(byte[] jsonBytes) {
        try {
            String jsonText = new String(jsonBytes);
            return AblyException.fromJSON(jsonText);
        }
        catch (AblyException e) {
            return e;
        }
    }

    public static AblyException fromIOException(IOException ioe) {
        if (ioe instanceof UnknownHostException || ioe instanceof NoRouteToHostException) {
            return new AblyException(ioe.getLocalizedMessage(), 404, 40400);
        }
        return new AblyException(ioe.getLocalizedMessage(), 500, 50000);
    }

    public static AblyException fromResponseStatus(String statusLine, int statusCode) {
        return new AblyException(statusLine, statusCode, statusCode * 100);
    }

    public static AblyException fromThrowable(Throwable t) {
        if (t instanceof AblyException) {
            return (AblyException)t;
        }
        if (t instanceof IOException) {
            return AblyException.fromIOException((IOException)t);
        }
        return new AblyException(t);
    }
}

