/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.realtime;

import io.ably.lib.http.Http;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.http.PaginatedQuery;
import io.ably.lib.realtime.AblyRealtime;
import io.ably.lib.realtime.Channel;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.transport.ConnectionManager;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.types.PresenceMessage;
import io.ably.lib.types.PresenceSerializer;
import io.ably.lib.types.ProtocolMessage;
import io.ably.lib.util.Log;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class Presence {
    private final Multicaster listeners = new Multicaster();
    private final Map<String, QueuedPresence> pendingPresence = new HashMap<String, QueuedPresence>();
    private final PresenceMap presence = new PresenceMap();
    private static final String TAG = Channel.class.getName();
    private final Channel channel;
    private final String clientId;

    public synchronized PresenceMessage[] get() {
        Collection<PresenceMessage> values = this.presence.values();
        return values.toArray(new PresenceMessage[values.size()]);
    }

    public synchronized PresenceMessage[] get(boolean wait) throws InterruptedException {
        Collection<PresenceMessage> values = this.presence.values(wait);
        return values.toArray(new PresenceMessage[values.size()]);
    }

    public synchronized PresenceMessage[] get(String clientId, boolean wait) throws InterruptedException {
        Collection<PresenceMessage> values = this.presence.getClient(clientId, wait);
        return values.toArray(new PresenceMessage[values.size()]);
    }

    public void subscribe(PresenceListener listener) throws AblyException {
        this.listeners.add(listener);
        this.channel.attach();
    }

    public void unsubscribe(PresenceListener listener) {
        this.listeners.remove(listener);
    }

    void setPresence(PresenceMessage[] messages, boolean broadcast, String syncChannelSerial) {
        Log.v(TAG, "setPresence(); channel = " + this.channel.name + "; broadcast = " + broadcast + "; syncChannelSerial = " + syncChannelSerial);
        String syncCursor = null;
        if (syncChannelSerial != null && (syncCursor = syncChannelSerial.substring(syncChannelSerial.indexOf(58))).length() > 1) {
            this.presence.startSync();
        }
        block5: for (PresenceMessage update : messages) {
            switch (update.action) {
                case ENTER: 
                case UPDATE: {
                    update = (PresenceMessage)update.clone();
                    update.action = PresenceMessage.Action.PRESENT;
                }
                case PRESENT: {
                    broadcast &= this.presence.put(update);
                    continue block5;
                }
                case LEAVE: {
                    broadcast &= this.presence.remove(update);
                    continue block5;
                }
            }
        }
        if (syncChannelSerial == null || syncCursor.length() <= 1) {
            this.presence.endSync();
        }
        if (broadcast) {
            this.broadcastPresence(messages);
        }
    }

    private void broadcastPresence(PresenceMessage[] messages) {
        this.listeners.onPresenceMessage(messages);
    }

    public void enter(Object data, CompletionListener listener) throws AblyException {
        this.enterClient(this.clientId, data, listener);
    }

    public void update(Object data, CompletionListener listener) throws AblyException {
        this.updateClient(this.clientId, data, listener);
    }

    public void leave(Object data, CompletionListener listener) throws AblyException {
        this.leaveClient(this.clientId, data, listener);
    }

    public void leave(CompletionListener listener) throws AblyException {
        this.leaveClient(this.clientId, null, listener);
    }

    public void enterClient(String clientId, Object data, CompletionListener listener) throws AblyException {
        Log.v(TAG, "enterClient(); channel = " + this.channel.name + "; clientId = " + clientId);
        this.updatePresence(new PresenceMessage(PresenceMessage.Action.ENTER, clientId, data), listener);
    }

    public void updateClient(String clientId, Object data, CompletionListener listener) throws AblyException {
        Log.v(TAG, "updateClient(); channel = " + this.channel.name + "; clientId = " + clientId);
        this.updatePresence(new PresenceMessage(PresenceMessage.Action.UPDATE, clientId, data), listener);
    }

    public void leaveClient(String clientId, Object data, CompletionListener listener) throws AblyException {
        Log.v(TAG, "leaveClient(); channel = " + this.channel.name + "; clientId = " + clientId);
        this.updatePresence(new PresenceMessage(PresenceMessage.Action.LEAVE, clientId, data), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePresence(PresenceMessage msg, CompletionListener listener) throws AblyException {
        Log.v(TAG, "update(); channel = " + this.channel.name + "; clientId = " + this.clientId);
        if (msg.clientId == null) {
            msg.clientId = this.clientId;
        }
        if (msg.clientId == null) {
            throw new AblyException("Unable to enter presence channel without clientId", 400, 91000);
        }
        msg.encode(null);
        Channel channel = this.channel;
        synchronized (channel) {
            switch (this.channel.state) {
                case initialised: {
                    this.channel.attach();
                }
                case attaching: {
                    QueuedPresence queued = new QueuedPresence(msg, listener);
                    this.pendingPresence.put(msg.clientId, queued);
                    break;
                }
                case attached: {
                    ProtocolMessage message = new ProtocolMessage(ProtocolMessage.Action.PRESENCE, this.channel.name);
                    message.presence = new PresenceMessage[]{msg};
                    AblyRealtime ably = this.channel.ably;
                    ConnectionManager connectionManager = ably.connection.connectionManager;
                    connectionManager.send(message, ably.options.queueMessages, listener);
                    break;
                }
                default: {
                    throw new AblyException("Unable to enter presence channel in detached or failed state", 400, 91001);
                }
            }
        }
    }

    public PaginatedResult<PresenceMessage> history(Param[] params) throws AblyException {
        AblyRealtime ably = this.channel.ably;
        Http.BodyHandler<PresenceMessage> bodyHandler = PresenceSerializer.getPresenceResponseHandler(this.channel.options);
        return new PaginatedQuery<PresenceMessage>(ably.http, this.channel.basePath + "/presence/history", HttpUtils.defaultAcceptHeaders(ably.options.useBinaryProtocol), params, bodyHandler).get();
    }

    private void sendQueuedMessages() {
        block6: {
            CompletionListener listener;
            Log.v(TAG, "sendQueuedMessages()");
            AblyRealtime ably = this.channel.ably;
            boolean queueMessages = ably.options.queueMessages;
            ConnectionManager connectionManager = ably.connection.connectionManager;
            int count = this.pendingPresence.size();
            if (count == 0) {
                return;
            }
            ProtocolMessage message = new ProtocolMessage(ProtocolMessage.Action.PRESENCE, this.channel.name);
            Iterator<QueuedPresence> allQueued = this.pendingPresence.values().iterator();
            message.presence = new PresenceMessage[count];
            PresenceMessage[] presenceMessages = message.presence;
            if (count == 1) {
                QueuedPresence queued = allQueued.next();
                presenceMessages[0] = queued.msg;
                listener = queued.listener;
            } else {
                int idx = 0;
                CompletionListener.Multicaster mListener = new CompletionListener.Multicaster(new CompletionListener[0]);
                while (allQueued.hasNext()) {
                    QueuedPresence queued = allQueued.next();
                    presenceMessages[idx++] = queued.msg;
                    if (queued.listener == null) continue;
                    mListener.add(queued.listener);
                }
                listener = mListener.isEmpty() ? null : mListener;
            }
            try {
                connectionManager.send(message, queueMessages, listener);
            }
            catch (AblyException e) {
                Log.e(TAG, "sendQueuedMessages(): Unexpected exception sending message", e);
                if (listener == null) break block6;
                listener.onError(e.errorInfo);
            }
        }
    }

    private void failQueuedMessages(ErrorInfo reason) {
        Log.v(TAG, "failQueuedMessages()");
        for (QueuedPresence msg : this.pendingPresence.values()) {
            if (msg.listener == null) continue;
            try {
                msg.listener.onError(reason);
            }
            catch (Throwable t) {
                Log.e(TAG, "failQueuedMessages(): Unexpected exception calling listener", t);
            }
        }
    }

    void setAttached() {
        this.sendQueuedMessages();
    }

    void setDetached(ErrorInfo reason) {
        this.failQueuedMessages(reason);
    }

    void setSuspended(ErrorInfo reason) {
        this.failQueuedMessages(reason);
    }

    void awaitSync() {
        this.presence.startSync();
    }

    Presence(Channel channel) {
        this.channel = channel;
        this.clientId = channel.ably.options.clientId;
    }

    private class PresenceMap {
        private boolean syncInProgress;
        private Collection<String> residualMembers;
        private final HashMap<String, PresenceMessage> members = new HashMap();

        private PresenceMap() {
        }

        synchronized Collection<PresenceMessage> getClient(String clientId, boolean wait) throws InterruptedException {
            HashSet<PresenceMessage> result = new HashSet<PresenceMessage>();
            Iterator<Map.Entry<String, PresenceMessage>> it = this.members.entrySet().iterator();
            while (it.hasNext()) {
                PresenceMessage entry = it.next().getValue();
                if (!entry.clientId.equals(clientId) || entry.action == PresenceMessage.Action.ABSENT) continue;
                result.add(entry);
            }
            return result;
        }

        synchronized boolean put(PresenceMessage item) {
            PresenceMessage existingItem;
            String key = this.memberKey(item);
            if (this.residualMembers != null) {
                this.residualMembers.remove(key);
            }
            if ((existingItem = this.members.get(key)) != null && item.timestamp < existingItem.timestamp) {
                return false;
            }
            this.members.put(key, item);
            return true;
        }

        synchronized Collection<PresenceMessage> values() {
            try {
                return this.values(false);
            }
            catch (InterruptedException e) {
                return null;
            }
        }

        synchronized Collection<PresenceMessage> values(boolean wait) throws InterruptedException {
            if (wait) {
                while (this.syncInProgress) {
                    this.wait();
                }
            }
            HashSet<PresenceMessage> result = new HashSet<PresenceMessage>();
            result.addAll(this.members.values());
            Iterator it = result.iterator();
            while (it.hasNext()) {
                PresenceMessage entry = (PresenceMessage)it.next();
                if (entry.action != PresenceMessage.Action.ABSENT) continue;
                it.remove();
            }
            return result;
        }

        synchronized boolean remove(PresenceMessage item) {
            String key = this.memberKey(item);
            PresenceMessage existingItem = this.members.remove(key);
            return existingItem == null || existingItem.action != PresenceMessage.Action.ABSENT;
        }

        synchronized void startSync() {
            Log.v(TAG, "startSync(); channel = " + ((Presence)Presence.this).channel.name + "; syncInProgress = " + this.syncInProgress);
            if (!this.syncInProgress) {
                this.residualMembers = new HashSet<String>(this.members.keySet());
                this.syncInProgress = true;
            }
        }

        synchronized void endSync() {
            Log.v(TAG, "endSync(); channel = " + ((Presence)Presence.this).channel.name + "; syncInProgress = " + this.syncInProgress);
            if (this.syncInProgress) {
                Iterator<Object> it = this.members.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, PresenceMessage> entry = it.next();
                    if (entry.getValue().action != PresenceMessage.Action.ABSENT) continue;
                    it.remove();
                }
                it = this.residualMembers.iterator();
                while (it.hasNext()) {
                    this.members.remove(it.next());
                }
                this.residualMembers = null;
                this.syncInProgress = false;
            }
            this.notifyAll();
        }

        private String memberKey(PresenceMessage message) {
            return message.connectionId + ':' + message.clientId;
        }
    }

    private static class QueuedPresence {
        public PresenceMessage msg;
        public CompletionListener listener;

        public QueuedPresence(PresenceMessage msg, CompletionListener listener) {
            this.msg = msg;
            this.listener = listener;
        }
    }

    private static class Multicaster
    extends io.ably.lib.util.Multicaster<PresenceListener>
    implements PresenceListener {
        private Multicaster() {
            super(new PresenceListener[0]);
        }

        @Override
        public void onPresenceMessage(PresenceMessage[] messages) {
            for (PresenceListener member : this.members) {
                try {
                    member.onPresenceMessage(messages);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static interface PresenceListener {
        public void onPresenceMessage(PresenceMessage[] var1);
    }
}

