/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.realtime;

import io.ably.lib.http.Http;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.http.PaginatedQuery;
import io.ably.lib.realtime.AblyRealtime;
import io.ably.lib.realtime.ChannelState;
import io.ably.lib.realtime.ChannelStateListener;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.realtime.Presence;
import io.ably.lib.transport.ConnectionManager;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageSerializer;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.types.PresenceMessage;
import io.ably.lib.types.ProtocolMessage;
import io.ably.lib.util.EventEmitter;
import io.ably.lib.util.Log;
import io.ably.lib.util.Multicaster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Channel
extends EventEmitter<ChannelState, ChannelStateListener> {
    public final String name;
    public final Presence presence;
    public ChannelState state;
    public ErrorInfo reason;
    public String attachSerial;
    static ErrorInfo REASON_NOT_ATTACHED = new ErrorInfo("Channel not attached", 400, 90001);
    private MessageMulticaster listeners = new MessageMulticaster();
    private HashMap<String, MessageMulticaster> eventListeners = new HashMap();
    private List<ConnectionManager.QueuedMessage> queuedMessages;
    private static final String TAG = Channel.class.getName();
    final AblyRealtime ably;
    final String basePath;
    ChannelOptions options;
    String syncChannelSerial;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ChannelState newState, ErrorInfo reason) {
        Log.v(TAG, "setState(): channel = " + this.name + "; setting " + (Object)((Object)newState));
        Channel channel = this;
        synchronized (channel) {
            this.state = newState;
            this.reason = reason;
        }
        this.emit(newState, reason);
    }

    public void attach() throws AblyException {
        Log.v(TAG, "attach(); channel = " + this.name);
        switch (this.state) {
            case attaching: 
            case attached: {
                return;
            }
        }
        ConnectionManager connectionManager = this.ably.connection.connectionManager;
        if (!connectionManager.isActive()) {
            throw new AblyException(connectionManager.getStateErrorInfo());
        }
        ProtocolMessage attachMessage = new ProtocolMessage(ProtocolMessage.Action.ATTACH, this.name);
        this.setState(ChannelState.attaching, null);
        connectionManager.send(attachMessage, true, null);
    }

    public void detach() throws AblyException {
        Log.v(TAG, "detach(); channel = " + this.name);
        switch (this.state) {
            case initialised: 
            case detaching: 
            case detached: {
                return;
            }
        }
        ConnectionManager connectionManager = this.ably.connection.connectionManager;
        if (!connectionManager.isActive()) {
            throw new AblyException(connectionManager.getStateErrorInfo());
        }
        ProtocolMessage detachMessage = new ProtocolMessage(ProtocolMessage.Action.DETACH, this.name);
        this.setState(ChannelState.detaching, null);
        connectionManager.send(detachMessage, true, null);
    }

    public void sync() throws AblyException {
        Log.v(TAG, "sync(); channel = " + this.name);
        switch (this.state) {
            case initialised: 
            case detaching: 
            case detached: {
                throw new AblyException(new ErrorInfo("Unable to sync to channel; not attached", 40000));
            }
        }
        ConnectionManager connectionManager = this.ably.connection.connectionManager;
        if (!connectionManager.isActive()) {
            throw new AblyException(connectionManager.getStateErrorInfo());
        }
        ProtocolMessage syncMessage = new ProtocolMessage(ProtocolMessage.Action.SYNC, this.name);
        syncMessage.channelSerial = this.syncChannelSerial;
        connectionManager.send(syncMessage, true, null);
    }

    private void setAttached(ProtocolMessage message) {
        Log.v(TAG, "setAttached(); channel = " + this.name);
        this.attachSerial = message.channelSerial;
        this.setState(ChannelState.attached, message.error);
        this.sendQueuedMessages();
        if ((message.flags & 1 << ProtocolMessage.Flag.HAS_PRESENCE.ordinal()) > 0) {
            Log.v(TAG, "setAttached(); awaiting sync; channel = " + this.name);
            this.presence.awaitSync();
        }
        this.presence.setAttached();
    }

    private void setDetached(ProtocolMessage message) {
        Log.v(TAG, "setDetached(); channel = " + this.name);
        ErrorInfo reason = message.error != null ? message.error : REASON_NOT_ATTACHED;
        this.setState(ChannelState.detached, reason);
        this.failQueuedMessages(reason);
        this.presence.setDetached(reason);
    }

    private void setFailed(ProtocolMessage message) {
        Log.v(TAG, "setFailed(); channel = " + this.name);
        ErrorInfo reason = message.error;
        this.setState(ChannelState.failed, reason);
        this.failQueuedMessages(reason);
        this.presence.setDetached(reason);
    }

    public void setConnected() {
        if (this.state == ChannelState.attached) {
            try {
                this.sync();
            }
            catch (AblyException e) {
                Log.e(TAG, "setConnected(): Unable to sync; channel = " + this.name, e);
            }
        }
    }

    public void setSuspended(ErrorInfo reason) {
        Log.v(TAG, "setSuspended(); channel = " + this.name);
        this.setState(ChannelState.detached, reason);
        this.failQueuedMessages(reason);
        this.presence.setSuspended(reason);
    }

    @Override
    protected void apply(ChannelStateListener listener, ChannelState state, Object ... args) {
        listener.onChannelStateChanged(state, (ErrorInfo)args[0]);
    }

    public synchronized void subscribe(MessageListener listener) throws AblyException {
        Log.v(TAG, "subscribe(); channel = " + this.name);
        this.listeners.add(listener);
        this.attach();
    }

    public synchronized void unsubscribe(MessageListener listener) {
        Log.v(TAG, "unsubscribe(); channel = " + this.name);
        this.listeners.remove(listener);
    }

    public synchronized void subscribe(String name, MessageListener listener) throws AblyException {
        Log.v(TAG, "subscribe(); channel = " + this.name + "; event = " + name);
        this.subscribeImpl(name, listener);
        this.attach();
    }

    public synchronized void unsubscribe(String name, MessageListener listener) {
        Log.v(TAG, "unsubscribe(); channel = " + this.name + "; event = " + name);
        this.unsubscribeImpl(name, listener);
    }

    public synchronized void subscribe(String[] names, MessageListener listener) throws AblyException {
        Log.v(TAG, "subscribe(); channel = " + this.name + "; (multiple events)");
        for (String name : names) {
            this.subscribeImpl(name, listener);
        }
        this.attach();
    }

    public synchronized void unsubscribe(String[] names, MessageListener listener) {
        Log.v(TAG, "unsubscribe(); channel = " + this.name + "; (multiple events)");
        for (String name : names) {
            this.unsubscribeImpl(name, listener);
        }
    }

    private void onMessage(ProtocolMessage message) {
        Log.v(TAG, "onMessage(); channel = " + this.name);
        Message[] messages = message.messages;
        for (int i = 0; i < messages.length; ++i) {
            Message msg = messages[i];
            try {
                msg.decode(this.options);
            }
            catch (AblyException e) {
                Log.e(TAG, "Unexpected exception decrypting message", e);
            }
            if (msg.connectionId == null) {
                msg.connectionId = message.connectionId;
            }
            if (msg.timestamp == 0L) {
                msg.timestamp = message.timestamp;
            }
            if (msg.id == null) {
                msg.id = message.id + ':' + i;
            }
            Message[] singleMessage = new Message[]{msg};
            MessageMulticaster listeners = this.eventListeners.get(msg.name);
            if (listeners == null) continue;
            listeners.onMessage(singleMessage);
        }
        this.listeners.onMessage(message.messages);
    }

    private void onPresence(ProtocolMessage message, String syncChannelSerial) {
        Log.v(TAG, "onPresence(); channel = " + this.name + "; syncChannelSerial = " + syncChannelSerial);
        PresenceMessage[] messages = message.presence;
        for (int i = 0; i < messages.length; ++i) {
            PresenceMessage msg = messages[i];
            try {
                msg.decode(this.options);
            }
            catch (AblyException e) {
                Log.e(TAG, "Unexpected exception decrypting message", e);
            }
            if (msg.connectionId == null) {
                msg.connectionId = message.connectionId;
            }
            if (msg.timestamp == 0L) {
                msg.timestamp = message.timestamp;
            }
            if (msg.id != null) continue;
            msg.id = message.id + ':' + i;
        }
        this.presence.setPresence(messages, true, syncChannelSerial);
    }

    private void onSync(ProtocolMessage message) {
        Log.v(TAG, "onSync(); channel = " + this.name);
        if (message.presence != null) {
            this.syncChannelSerial = message.channelSerial;
            this.onPresence(message, this.syncChannelSerial);
        }
    }

    private void subscribeImpl(String name, MessageListener listener) throws AblyException {
        MessageMulticaster listeners = this.eventListeners.get(name);
        if (listeners == null) {
            listeners = new MessageMulticaster();
            this.eventListeners.put(name, listeners);
        }
        listeners.add(listener);
    }

    private void unsubscribeImpl(String name, MessageListener listener) {
        MessageMulticaster listeners = this.eventListeners.get(name);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.eventListeners.remove(name);
            }
        }
    }

    public void publish(String name, Object data, CompletionListener listener) throws AblyException {
        Log.v(TAG, "publish(String, Object); channel = " + this.name + "; event = " + name);
        this.publish(new Message[]{new Message(name, data)}, listener);
    }

    public void publish(Message message, CompletionListener listener) throws AblyException {
        Log.v(TAG, "publish(Message); channel = " + this.name + "; event = " + message.name);
        this.publish(new Message[]{message}, listener);
    }

    public void publish(Message[] messages, CompletionListener listener) throws AblyException {
        Log.v(TAG, "publish(Message[]); channel = " + this.name);
        for (Message message : messages) {
            message.encode(this.options);
        }
        ProtocolMessage msg = new ProtocolMessage(ProtocolMessage.Action.MESSAGE, this.name);
        msg.messages = messages;
        switch (this.state) {
            case initialised: {
                this.attach();
            }
            case attaching: {
                this.queuedMessages.add(new ConnectionManager.QueuedMessage(msg, listener));
                break;
            }
            case detaching: 
            case detached: 
            case failed: {
                throw new AblyException(new ErrorInfo("Unable to publish in detached or failed state", 400, 40000));
            }
            case attached: {
                ConnectionManager connectionManager = this.ably.connection.connectionManager;
                connectionManager.send(msg, this.ably.options.queueMessages, listener);
            }
        }
    }

    private void sendQueuedMessages() {
        Log.v(TAG, "sendQueuedMessages()");
        boolean queueMessages = this.ably.options.queueMessages;
        ConnectionManager connectionManager = this.ably.connection.connectionManager;
        for (ConnectionManager.QueuedMessage msg : this.queuedMessages) {
            try {
                connectionManager.send(msg.msg, queueMessages, msg.listener);
            }
            catch (AblyException e) {
                Log.e(TAG, "sendQueuedMessages(): Unexpected exception sending message", e);
                if (msg.listener == null) continue;
                msg.listener.onError(e.errorInfo);
            }
        }
        this.queuedMessages.clear();
    }

    private void failQueuedMessages(ErrorInfo reason) {
        Log.v(TAG, "failQueuedMessages()");
        for (ConnectionManager.QueuedMessage msg : this.queuedMessages) {
            if (msg.listener == null) continue;
            try {
                msg.listener.onError(reason);
            }
            catch (Throwable t) {
                Log.e(TAG, "failQueuedMessages(): Unexpected exception calling listener", t);
            }
        }
        this.queuedMessages.clear();
    }

    public PaginatedResult<Message> history(Param[] params) throws AblyException {
        Http.BodyHandler<Message> bodyHandler = MessageSerializer.getMessageResponseHandler(this.options);
        return new PaginatedQuery<Message>(this.ably.http, this.basePath + "/history", HttpUtils.defaultAcceptHeaders(this.ably.options.useBinaryProtocol), params, bodyHandler).get();
    }

    public void setOptions(ChannelOptions options) throws AblyException {
        this.options = options;
    }

    Channel(AblyRealtime ably, String name) {
        Log.v(TAG, "RealtimeChannel(); channel = " + name);
        this.ably = ably;
        this.name = name;
        this.basePath = "/channels/" + HttpUtils.encodeURIComponent(name);
        this.presence = new Presence(this);
        this.state = ChannelState.initialised;
        this.queuedMessages = new ArrayList<ConnectionManager.QueuedMessage>();
    }

    void onChannelMessage(ProtocolMessage msg) {
        switch (msg.action) {
            case ATTACHED: {
                this.setAttached(msg);
                break;
            }
            case DETACHED: {
                this.setDetached(msg);
                break;
            }
            case MESSAGE: {
                this.onMessage(msg);
                break;
            }
            case PRESENCE: {
                this.onPresence(msg, null);
                break;
            }
            case SYNC: {
                this.onSync(msg);
                break;
            }
            case ERROR: {
                this.setFailed(msg);
                break;
            }
            default: {
                Log.e(TAG, "onChannelMessage(): Unexpected message action (" + (Object)((Object)msg.action) + ")");
            }
        }
    }

    private static class MessageMulticaster
    extends Multicaster<MessageListener>
    implements MessageListener {
        private MessageMulticaster() {
            super(new MessageListener[0]);
        }

        @Override
        public void onMessage(Message[] messages) {
            for (MessageListener member : this.members) {
                try {
                    member.onMessage(messages);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static interface MessageListener {
        public void onMessage(Message[] var1);
    }
}

